/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.form.designer.gui.property;

import com.kingdee.bos.ctrl.common.layout.table.Table;
import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.DataExtend;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.IBind;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.IR1DataManager;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ElementPath;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core.ComboPanel;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.property.AbstractPropertyPanel;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.element.PictureObject;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.gui.property.panels.CommonPanelWithBindField;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.filechooser.FileFilter;

public class PanelPictureSet
extends AbstractPropertyPanel {
    private CommonPanelWithBindField panelBind;
    private KDRadioButton rbSelfDefine;
    private KDRadioButton rbBind;
    private KDComboBox cmbSaveType;
    private KDComboBox cmbScale;
    private F7FileChooser fileChooser;
    private KDPromptBox f7Source;
    private StyleAttributes sa;
    private IR1DataManager dm;
    private ActionListener actionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Object obj = e.getSource();
            if (obj.equals(PanelPictureSet.this.rbBind) && PanelPictureSet.this.rbBind.isSelected()) {
                PanelPictureSet.this.panelBind.setCmbEnabeled(true);
                PanelPictureSet.this.f7Source.setEnabled(false);
                PanelPictureSet.this.cmbSaveType.setEnabled(false);
            }
            if (obj.equals(PanelPictureSet.this.rbSelfDefine) && PanelPictureSet.this.rbSelfDefine.isSelected()) {
                PanelPictureSet.this.panelBind.setCmbEnabeled(false);
                PanelPictureSet.this.panelBind.getCmbDataBind().setSelectedIndex(0);
                PanelPictureSet.this.f7Source.setEnabled(true);
                PanelPictureSet.this.cmbSaveType.setEnabled(true);
            }
        }
    };

    public PanelPictureSet() {
        this.initComponents();
        this.addListener();
    }

    private void addListener() {
    }

    private void initComponents() {
        Object[] sScale = new String[]{MultiLanguageUtil.getMLS("noZoom", ""), MultiLanguageUtil.getMLS("zoomByScale", "")};
        Object[] sSave = new String[]{MultiLanguageUtil.getMLS("embed", ""), MultiLanguageUtil.getMLS("link", "")};
        this.rbBind = new KDRadioButton(MultiLanguageUtil.getMLS("bind", ""));
        this.rbSelfDefine = new KDRadioButton(MultiLanguageUtil.getMLS("selfDefine", ""));
        this.rbBind.addActionListener(this.actionListener);
        this.rbSelfDefine.addActionListener(this.actionListener);
        this.rbSelfDefine.setSelected(true);
        ButtonGroup group = new ButtonGroup();
        group.add((AbstractButton)this.rbBind);
        group.add((AbstractButton)this.rbSelfDefine);
        this.panelBind = new CommonPanelWithBindField();
        this.f7Source = new KDPromptBox();
        this.fileChooser = new F7FileChooser();
        this.f7Source.setEditable(true);
        this.cmbScale = new KDComboBox(sScale);
        this.cmbSaveType = new KDComboBox(sSave);
        KDLabelContainer lbcSave = new KDLabelContainer((JComponent)this.cmbSaveType);
        lbcSave.setBoundLabelText(MultiLanguageUtil.getMLS("saveType", ""));
        lbcSave.setBoundLabelLength(100);
        lbcSave.setBoundLabelUnderline(true);
        KDLabelContainer lbcScale = new KDLabelContainer((JComponent)this.cmbScale);
        lbcScale.setBoundLabelText(MultiLanguageUtil.getMLS("zoom", ""));
        lbcScale.setBoundLabelLength(100);
        lbcScale.setBoundLabelUnderline(true);
        KDLabelContainer lbcSource = new KDLabelContainer((JComponent)this.f7Source);
        lbcSource.setBoundLabelText(MultiLanguageUtil.getMLS("picSource", ""));
        lbcSource.setBoundLabelLength(100);
        lbcSource.setBoundLabelUnderline(true);
        KDPanel panInfo = new KDPanel();
        panInfo.setBorder((Border)BorderFactory.createTitledBorder(MultiLanguageUtil.getMLS("data", "")));
        TableLayout ti = TableLayout.split((int)7, (int)1);
        ti.getStyle().setMargin(10, 21, 12, 9);
        ti.rowStyle(1).setMargin(20, 3, 0, 0);
        ti.rowStyle(2).setMargin(0, 8, 0, 6);
        ti.rowStyle(3).setMargin(0, 0, 0, 0);
        ti.rowStyle(4).setMargin(20, 3, 0, 0);
        ti.rowStyle(5).setMargin(20, 3, 0, 32);
        ti.rowStyle(6).setPriY(1);
        panInfo.setLayout((LayoutManager)ti);
        panInfo.add((Component)this.rbBind, (Object)ti.cell(0, 0));
        panInfo.add((Component)((Object)this.panelBind), (Object)ti.cell(1, 0));
        panInfo.add((Component)new KDSeparator(), (Object)ti.cell(2, 0));
        panInfo.add((Component)this.rbSelfDefine, (Object)ti.cell(3, 0));
        panInfo.add((Component)lbcSource, (Object)ti.cell(4, 0));
        panInfo.add((Component)lbcSave, (Object)ti.cell(5, 0));
        TableLayout tl = TableLayout.split((int)3, (int)1);
        tl.getStyle().setMargin(6, 4, 6, 8);
        Table tt = tl.cell(1, 0).split(1, 2);
        tt.colStyle(0).setWidth(80);
        tt.rowStyle(0).setMargin(2, 6, 0, 0);
        tt.colStyle(1).setPriX(1);
        tl.rowStyle(1).setHeight(19);
        tl.rowStyle(2).setPriY(1);
        this.setLayout((LayoutManager)tl);
        this.add((Component)panInfo, tl.cell(0, 0));
        this.add((Component)lbcScale, tt.cell(0, 0));
        this.fileChooser.setDialogTitle(MultiLanguageUtil.getMLS("selectPic", ""));
        this.fileChooser.setMultiSelectionEnabled(false);
        this.fileChooser.setDialogType(0);
        this.fileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String name = f.getName();
                String ext = name.substring(name.lastIndexOf(".") + 1);
                return "jpg".equalsIgnoreCase(ext) || "jpeg".equalsIgnoreCase(ext) || "bmp".equalsIgnoreCase(ext) || "dib".equalsIgnoreCase(ext) || "rle".equalsIgnoreCase(ext) || "gif".equalsIgnoreCase(ext) || "png".equalsIgnoreCase(ext);
            }

            @Override
            public String getDescription() {
                return "All supported image files (*.jpg;*.bmp;*.gif;*.png)";
            }
        });
        this.f7Source.setSelector((KDPromptSelector)this.fileChooser);
        this.f7Source.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                if (StringUtil.isEmptyString((String)PanelPictureSet.this.f7Source.getText())) {
                    PanelPictureSet.this.fileChooser.setSelectedFile(new File(PanelPictureSet.this.f7Source.getText()));
                }
            }
        });
    }

    public void setSA(StyleAttributes sa) {
        this.sa = sa;
    }

    private boolean getIsLinked() {
        return this.cmbSaveType.getSelectedItem().toString().equals("");
    }

    private boolean getIsRbBind() {
        return this.rbBind.isSelected();
    }

    private boolean getIsZoom() {
        return this.cmbScale.getSelectedIndex() != 0;
    }

    @Override
    protected void updateElementValue(ElementPath elePath) {
        Object obj = elePath.getLastPathComponent();
        PictureObject picObject = (PictureObject)obj;
        picObject.setLinked(this.getIsLinked());
        String newExpr = this.f7Source.getText();
        if (!StringUtil.isEmptyString((String)newExpr) && !StringUtil.equals((String)picObject.getImageExpression(), (String)newExpr)) {
            picObject.setImageExpression(this.f7Source.getText());
        }
        if (this.getIsZoom()) {
            picObject.setScale(2);
        } else {
            picObject.setScale(1);
        }
        DataExtend ext = this.panelBind.getSelectedDsExt();
        IBind objBind = (IBind)obj;
        IBind.IBindDataSource bindDS = objBind.getDataSource();
        IBind.IBindField bindField = objBind.getBindField();
        if (ext == null) {
            bindDS.setDs(null);
            bindField.setField(null);
            return;
        }
        if (!(obj instanceof IBind)) {
            return;
        }
        if (bindDS != null) {
            bindDS.setDs(ext.getName());
        }
        Object objDs = this.dm.getObject(ext.getName());
        this.panelBind.updateBind(objDs, bindField);
    }

    @Override
    public String getTitle() {
        return MultiLanguageUtil.getMLS("picture", "");
    }

    @Override
    public void prepareCtrlValue(ElementPath[] eps) {
        PictureObject picObj = (PictureObject)eps[0].getLastPathComponent();
        if (picObj.isBindData()) {
            this.rbBind.setSelected(true);
            this.panelBind.setCmbEnabeled(true);
            this.f7Source.setEnabled(false);
            this.cmbSaveType.setEnabled(false);
        } else {
            this.rbBind.setSelected(false);
            this.panelBind.setCmbEnabeled(false);
            this.f7Source.setEnabled(true);
            this.cmbSaveType.setEnabled(true);
        }
        if (picObj.getScale() == 1) {
            this.cmbScale.setSelectedIndex(0);
        } else {
            this.cmbScale.setSelectedIndex(1);
        }
        this.f7Source.setText(picObj.getImageExpression());
        if (!(picObj instanceof IBind)) {
            return;
        }
        if (picObj.isLinked()) {
            this.cmbSaveType.setSelectedIndex(1);
        } else {
            this.cmbSaveType.setSelectedIndex(0);
        }
        PictureObject objBind = picObj;
        IBind.IBindDataSource bindDS = objBind.getDataSource();
        if (bindDS == null) {
            this.panelBind.setCmbBindDataSelectedItem(null);
        } else {
            String name = bindDS.getDs();
            DataExtend ext = this.dm.getDataExtend(name);
            this.panelBind.setCmbBindDataSelectedItem((Object)ext);
        }
        IBind.IBindField bindField = objBind.getBindField();
        this.panelBind.prepareValue(bindField);
    }

    @Override
    public void prepareSupplyValue(ComboPanel core, ElementPath[] eles) {
        Object obj = eles[0].getLastPathComponent();
        if (!(obj instanceof IBind)) {
            return;
        }
        String dsName = null;
        IBind objBind = (IBind)obj;
        IBind.IBindDataSource bindDS = objBind.getDataSource();
        this.dm = core.getModel().getDataManager();
        this.panelBind.prepareDsSupplyValue(this.dm, bindDS);
        if (bindDS != null) {
            dsName = bindDS.getDs();
        }
        this.panelBind.prepareFieldSupplyValue(dsName);
        IBind.IBindField bindField = objBind.getBindField();
        IBind.IBindField showField = objBind.getShowField();
        this.panelBind.setCmbDisplay(bindField == null && showField == null);
    }

    @Override
    public boolean verify() {
        if (null != this.panelBind.getCmbDataBind().getSelectedItem() && !this.panelBind.getCmbDataBind().getSelectedItem().toString().equals("") && (null == this.panelBind.getCmbBindField().getSelectedItem() || this.panelBind.getCmbBindField().getSelectedItem().toString().equals(""))) {
            WindowUtil.msgboxError((Object)MultiLanguageUtil.getMLS("megDoBind", ""), (String)this.getTitle(), (Component)((Object)this));
            return false;
        }
        return true;
    }

    private class F7FileChooser
    extends KDFileChooser
    implements KDPromptSelector {
        private int result;

        private F7FileChooser() {
        }

        public boolean isCanceled() {
            return this.result != 0;
        }

        public Object getData() {
            return "file://" + this.getSelectedFile();
        }

        public void show() {
            this.result = this.showOpenDialog((Component)((Object)this));
        }
    }
}

