/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.form.designer.model.xmltrans;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.reportone.r1.common.R1Exception;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IReportObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.factory.IAnObjectFactory;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.element.CheckBoxObject;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.model.xmltrans.AbstractR1FormXmlTrans;
import org.jdom2.Element;

public class CheckBoxXmlTrans
extends AbstractR1FormXmlTrans {
    public CheckBoxXmlTrans(IAnObjectFactory factory) {
        super(factory);
    }

    @Override
    protected boolean isMatch(Element node) {
        return "CheckBox".equalsIgnoreCase(node.getName());
    }

    @Override
    protected IReportObject fromXml(Element node) throws R1Exception {
        CheckBoxObject checkbox = (CheckBoxObject)this.getFactory().create();
        this.loadObjectCommon(node, checkbox);
        return checkbox;
    }

    @Override
    protected Element loadDataNode(Element nodeRo, IReportObject ro) {
        CheckBoxObject checkbox = (CheckBoxObject)ro;
        Element dataNode = super.loadDataNode(nodeRo, ro);
        if (checkbox.isBindData()) {
            checkbox.setToSelectedCompareValue(nodeRo.getAttributeValue("toSelectedCompareValue"));
        } else {
            if (dataNode != null) {
                checkbox.setText(dataNode.getText());
            }
            checkbox.setSelected("true".equals(nodeRo.getAttributeValue("selected")));
        }
        return dataNode;
    }

    @Override
    protected boolean isMatch(IReportObject ro) {
        return ro instanceof CheckBoxObject;
    }

    @Override
    protected Element toXml(IReportObject ro) {
        Element node = new Element("CheckBox");
        this.saveObjectCommon(ro, node);
        this.saveDataNode(ro, node);
        return node;
    }

    @Override
    protected Element saveDataNode(IReportObject ro, Element node) {
        Element dataNode = super.saveDataNode(ro, node);
        CheckBoxObject checkbox = (CheckBoxObject)ro;
        if (checkbox.isBindData()) {
            if (!StringUtil.isEmptyString((String)checkbox.getToSelectedCompareValue())) {
                node.setAttribute("toSelectedCompareValue", checkbox.getToSelectedCompareValue());
            }
        } else {
            if (!StringUtil.isEmptyString((String)checkbox.getText())) {
                dataNode.setText(checkbox.getText());
            }
            if (checkbox.isSelected()) {
                node.setAttribute("selected", "true");
            }
        }
        return dataNode;
    }
}

