/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.form.designer.model.xmltrans;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.reportone.r1.common.R1Exception;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IReportObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.factory.IAnObjectFactory;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.element.DatePickerObject;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.model.xmltrans.AbstractR1FormXmlTrans;
import java.text.DateFormat;
import java.util.Date;
import org.apache.log4j.Logger;
import org.jdom2.Element;

public class DatePickerXmlTrans
extends AbstractR1FormXmlTrans {
    private static final Logger log = LogUtil.getLogger(DatePickerXmlTrans.class);

    public DatePickerXmlTrans(IAnObjectFactory factory) {
        super(factory);
    }

    @Override
    protected boolean isMatch(Element node) {
        return "DatePicker".equalsIgnoreCase(node.getName());
    }

    @Override
    protected IReportObject fromXml(Element node) throws R1Exception {
        DatePickerObject datePicker = (DatePickerObject)this.getFactory().create();
        this.loadObjectCommon(node, datePicker);
        String strDate = node.getAttributeValue("date");
        if (!StringUtil.isEmptyString((String)strDate)) {
            datePicker.setDate(this.getDate(strDate));
        }
        return datePicker;
    }

    private Date getDate(String dateStr) {
        try {
            DateFormat formater = DateFormat.getDateInstance();
            Date date = formater.parse(dateStr);
            return date;
        }
        catch (Exception e) {
            log.error((Object)"Date Convert Error!", (Throwable)e);
            return null;
        }
    }

    @Override
    protected boolean isMatch(IReportObject ro) {
        return ro instanceof DatePickerObject;
    }

    @Override
    protected Element toXml(IReportObject ro) {
        DatePickerObject datePicker = (DatePickerObject)ro;
        Element node = new Element("DatePicker");
        this.saveObjectCommon(ro, node);
        if (!datePicker.isBindData() && null != datePicker.getDate()) {
            DateFormat fomater = DateFormat.getDateInstance();
            String date = fomater.format(datePicker.getDate());
            node.setAttribute("date", date);
        }
        return node;
    }
}

