/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.form.designer.model.xmltrans;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.util.Base64;
import com.kingdee.bos.ctrl.reportone.r1.common.R1Exception;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IReportObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.factory.IAnObjectFactory;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.element.PictureObject;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.model.xmltrans.AbstractR1FormXmlTrans;
import org.jdom2.Element;

public class PictureXmlTrans
extends AbstractR1FormXmlTrans {
    public PictureXmlTrans(IAnObjectFactory factory) {
        super(factory);
    }

    @Override
    protected boolean isMatch(Element node) {
        return "Picture".equalsIgnoreCase(node.getName());
    }

    @Override
    protected IReportObject fromXml(Element node) throws R1Exception {
        PictureObject picObj = (PictureObject)this.getFactory().create();
        this.loadObjectCommon(node, picObj);
        if ("scale".equals(node.getAttributeValue("zoom"))) {
            picObj.setScale(2);
        } else {
            picObj.setScale(1);
        }
        return picObj;
    }

    @Override
    protected Element loadDataNode(Element nodeRo, IReportObject ro) {
        PictureObject pic = (PictureObject)ro;
        Element dataNode = super.loadDataNode(nodeRo, ro);
        if (!pic.isBindData() && dataNode != null) {
            String expr = dataNode.getAttributeValue("link");
            if (expr != null) {
                pic.setLinked(true);
                pic.setImageExpression(expr);
            } else {
                pic.setLinked(false);
                String content = dataNode.getTextTrim();
                if (!StringUtil.isEmptyString((String)content)) {
                    pic.setImageContent(Base64.decode((String)content));
                }
            }
        }
        return dataNode;
    }

    @Override
    protected boolean isMatch(IReportObject ro) {
        return ro instanceof PictureObject;
    }

    @Override
    protected Element toXml(IReportObject ro) {
        Element node = new Element("Picture");
        PictureObject picObj = (PictureObject)ro;
        this.saveObjectCommon(ro, node);
        if (picObj.getScale() == 2) {
            node.setAttribute("zoom", "scale");
        }
        return node;
    }

    @Override
    protected Element saveDataNode(IReportObject ro, Element node) {
        PictureObject pic = (PictureObject)ro;
        Element dataNode = super.saveDataNode(ro, node);
        if (!pic.isBindData()) {
            if (pic.isLinked()) {
                if (null != pic.getImageExpression()) {
                    dataNode.setAttribute("link", pic.getImageExpression());
                }
            } else if (pic.getImageContent() != null) {
                dataNode.setText(Base64.encodeBytes((byte[])pic.getImageContent()));
            }
        }
        return dataNode;
    }
}

