/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.form.engine.table;

import com.kingdee.bos.ctrl.common.CtrlUIEnv;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.table.ATableView;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.table.KDTableUtil;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.rs.CsvResultSet;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.formats.csv.CsvReader;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.util.XmlUtil;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;

public class ResultSetTable
extends ATableView
implements KDTDataRequestListener {
    private static final Logger log = LogUtil.getPackageLogger(ResultSetTable.class);
    private ResultSet rs;
    private int colCount;

    @Override
    public void setTable(KDTable table) {
        super.setTable(table);
        table.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
    }

    public ResultSet getResultSet() {
        return this.rs;
    }

    public void setResultSet(ResultSet model) {
        this.rs = model;
    }

    @Override
    public void updateView() throws Exception {
        KDTable kdt = this.getTable();
        this.colCount = KDTableUtil.initTable(kdt, this.rs, 20);
        kdt.refresh();
    }

    private void updateRow(IRow row) throws SQLException {
        for (int i = 0; i < this.colCount; ++i) {
            row.getCell(i).setValue(this.rs.getObject(i + 1));
        }
    }

    public void tableDataRequest(KDTDataRequestEvent e) {
        log.debug((Object)e);
        KDTable kdt = this.getTable();
        int start = e.getFirstRow();
        int last = e.getLastRow();
        try {
            for (int i = start; i <= last && this.rs.next(); ++i) {
                this.updateRow(kdt.addRow(i));
            }
        }
        catch (SQLException ex) {
            log.error((Object)"\u53d6\u6570\u5931\u8d25", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        CtrlUIEnv.setKingdeeLAF();
        InputStream in2 = null;
        InputStreamReader fileReader = null;
        try {
            in2 = ResultSetTable.class.getResourceAsStream("TestGrid.xml");
            Element xmlGrid = XmlUtil.readXmlStream(in2);
            InputStream in = ResultSetTable.class.getResourceAsStream("TestRS.csv");
            fileReader = new InputStreamReader(in);
            CsvReader csvReader = new CsvReader(fileReader);
            CsvResultSet csvResultSet = new CsvResultSet(csvReader);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (in2 != null) {
                try {
                    in2.close();
                }
                catch (Exception exception) {}
            }
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (Exception exception) {}
            }
        }
        System.exit(0);
    }
}

