/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.groupinggrid.pattern;

import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.SchemaException;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.NameIndex;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.groupinggrid.pattern.AGGNode;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.groupinggrid.pattern.GGCell;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.groupinggrid.pattern.GGCol;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.groupinggrid.pattern.GGRow;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.groupinggrid.pattern.GGRowType;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.groupinggrid.pattern.GroupingGrid;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.util.StringUtil;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.util.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GroupingGridXmlIO {
    private static final String T_GroupingGrid = "GroupingGrid";
    private static final String T_STYLE = "STYLE";
    private static final String T_GRID = "TABLE";
    private static final String T_COL = "COL";
    private static final String T_ROW = "TR";
    private static final String T_CELL = "TD";
    private static final String A_type = "type";
    private static final String A_hidden = "hidden";
    private static final String A_byCol = "byCol";
    private static final String A_dataCol = "dataCol";
    private static final String A_stat = "stat";

    public static GroupingGrid readGridRoot(Element xmlGroupRoot) throws SchemaException {
        Element xmlGrid;
        Element xmlStyle = XmlUtil.getFirstChild(xmlGroupRoot, T_STYLE);
        String style = null;
        if (xmlStyle != null) {
            style = XmlUtil.getNodeText(xmlStyle);
        }
        if ((xmlGrid = XmlUtil.getFirstChild(xmlGroupRoot, T_GRID)) != null) {
            GroupingGrid grid = GroupingGridXmlIO.readGrid(xmlGrid);
            grid.setStyle(style);
            return grid;
        }
        return null;
    }

    public static GroupingGrid readGrid(Element xmlGrid) throws SchemaException {
        int i;
        NodeList xmlCols = xmlGrid.getElementsByTagName(T_COL);
        int colCount = xmlCols.getLength();
        NodeList xmlRows = xmlGrid.getElementsByTagName(T_ROW);
        int rowCount = xmlRows.getLength();
        GroupingGrid grid = new GroupingGrid();
        GroupingGridXmlIO.readASchema(grid, xmlGrid);
        grid.setColCount(colCount);
        for (i = 0; i < colCount; ++i) {
            GGCol col = GroupingGridXmlIO.readCol((Element)xmlCols.item(i));
            grid.setCol(i, col);
        }
        for (i = 0; i < rowCount; ++i) {
            Element xmlRow = (Element)xmlRows.item(i);
            GGRow row = grid.addRow();
            GroupingGridXmlIO.readRow(xmlRow, row);
            NodeList xmlCells = xmlRow.getElementsByTagName(T_CELL);
            int z = xmlCells.getLength();
            if (z > colCount) {
                z = colCount;
            }
            for (int j = 0; j < z; ++j) {
                GGCell cell = GroupingGridXmlIO.readCell((Element)xmlCells.item(j));
                grid.setCell(i, j, cell);
            }
        }
        return grid;
    }

    public static GGCol readCol(Element xmlCol) throws SchemaException {
        GGCol col = new GGCol();
        GroupingGridXmlIO.readASchema(col, xmlCol);
        return col;
    }

    private static void readASchema(AGGNode obj, Element xml) {
        NamedNodeMap atts = xml.getAttributes();
        int z = atts.getLength();
        for (int i = 0; i < z; ++i) {
            Node att = atts.item(i);
            obj.setAttribte(att.getNodeName(), att.getNodeValue());
        }
    }

    public static void writeASchema(AGGNode obj, Element xml) {
        int z = obj.getAttributeCount();
        for (int i = 0; i < z; ++i) {
            xml.setAttribute((String)obj.getAttributeName(i), (String)obj.getAttributeValue(i));
        }
    }

    public static void readRow(Element xmlRow, GGRow row) throws SchemaException {
        GroupingGridXmlIO.readASchema(row, xmlRow);
        String attVal = xmlRow.getAttribute(A_type);
        if (attVal != null) {
            row.setType(GGRowType.fromName(attVal));
        }
        if ((attVal = xmlRow.getAttribute(A_byCol)) != null) {
            row.setGroupCol(NameIndex.valueOf(attVal));
        }
        if ((attVal = xmlRow.getAttribute(A_hidden)) != null) {
            row.setHidden("1".equals(attVal));
        }
    }

    public static GGCell readCell(Element xmlCell) throws SchemaException {
        GGCell cell = new GGCell();
        GroupingGridXmlIO.readASchema(cell, xmlCell);
        String avDataCol = xmlCell.getAttribute(A_dataCol);
        if (!StringUtil.isEmpty(avDataCol)) {
            cell.setDataCol(NameIndex.valueOf(avDataCol));
            String avStat = xmlCell.getAttribute(A_stat);
            if (!StringUtil.isEmpty(avStat)) {
                cell.setStatType(avStat);
            }
        }
        cell.setText(xmlCell.getNodeValue());
        return cell;
    }

    public static Element writeGridRoot(Document doc, GroupingGrid grid) throws SchemaException {
        Element xmlGroupRoot = doc.createElement(T_GroupingGrid);
        Element xmlStyle = doc.createElement(T_STYLE);
        XmlUtil.setNodeText(doc, xmlStyle, grid.getStyle());
        xmlGroupRoot.appendChild(xmlStyle);
        Element xmlGrid = GroupingGridXmlIO.writeGrid(doc, grid);
        xmlGroupRoot.appendChild(xmlGrid);
        return xmlGroupRoot;
    }

    public static Element writeGrid(Document doc, GroupingGrid grid) throws SchemaException {
        int i;
        Element xmlGrid = doc.createElement(T_GRID);
        GroupingGridXmlIO.writeASchema(grid, xmlGrid);
        int colCount = grid.getColCount();
        int rowCount = grid.getRowCount();
        for (i = 0; i < colCount; ++i) {
            Element xmlCol = GroupingGridXmlIO.writeCol(doc, grid.getCol(i));
            xmlGrid.appendChild(xmlCol);
        }
        for (i = 0; i < rowCount; ++i) {
            Element xmlRow = GroupingGridXmlIO.writeRow(doc, grid.getRow(i));
            for (int j = 0; j < colCount; ++j) {
                GGCell cell = grid.getCell(i, j);
                xmlRow.appendChild(GroupingGridXmlIO.writeCell(doc, cell));
            }
            xmlGrid.appendChild(xmlRow);
        }
        return xmlGrid;
    }

    public static Element writeCol(Document doc, GGCol col) throws SchemaException {
        Element xmlCol = doc.createElement(T_COL);
        if (col != null) {
            GroupingGridXmlIO.writeASchema(col, xmlCol);
            if (col.isHidden()) {
                xmlCol.setAttribute(A_hidden, "1");
            }
        }
        return xmlCol;
    }

    public static Element writeRow(Document doc, GGRow row) throws SchemaException {
        Element xmlRow = doc.createElement(T_ROW);
        if (row != null) {
            GroupingGridXmlIO.writeASchema(row, xmlRow);
            if (row.getType() != null) {
                xmlRow.setAttribute(A_type, row.getType().getName());
            }
            if (row.getGroupCol() != null) {
                xmlRow.setAttribute(A_byCol, row.getGroupCol().toString());
            }
            if (row.isHidden()) {
                xmlRow.setAttribute(A_hidden, "1");
            }
        }
        return xmlRow;
    }

    public static Element writeCell(Document doc, GGCell cell) throws SchemaException {
        Element xmlCell = doc.createElement(T_CELL);
        if (cell == null) {
            return xmlCell;
        }
        GroupingGridXmlIO.writeASchema(cell, xmlCell);
        if (cell.getDataCol() != null) {
            xmlCell.setAttribute(A_dataCol, cell.getDataCol().toString());
            if (cell.getStatType() != null) {
                xmlCell.setAttribute(A_stat, cell.getStatType());
            }
        }
        if (cell.getText() != null) {
            XmlUtil.setNodeText(doc, xmlCell, cell.getText());
        }
        return xmlCell;
    }
}

