/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.form.engine.x.mvc.swing;

import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.log.LogUtil;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.log.Logger;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.mvc.AModel;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.mvc.MvcEvent;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.mvc.model.ParametersModel;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.mvc.swing.ASwingView;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.util.ObjectUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JToggleButton;

public abstract class AToggleView
extends ASwingView {
    private static final Logger log = LogUtil.getLogger(AToggleView.class, 2);
    private Object selectValue;

    public AToggleView(JComponent mainComp) {
        super(mainComp);
    }

    @Override
    protected JComponent init(JComponent mainComp) {
        AbstractButton j = (AbstractButton)super.init(mainComp);
        j.addActionListener(new Ctrl());
        return j;
    }

    private JToggleButton getJToggleButton() {
        return (JToggleButton)this.getComponent();
    }

    public final String getText() {
        return this.getJToggleButton().getText();
    }

    public final void setText(String x) {
        this.getJToggleButton().setText(x);
    }

    public final boolean isSelected() {
        return this.getJToggleButton().isSelected();
    }

    public final void setSelected(boolean x) {
        this.getJToggleButton().setSelected(x);
    }

    public final Object getSelectValue() {
        return this.selectValue;
    }

    public final void setSelectValue(Object x) {
        this.selectValue = x;
    }

    @Override
    protected void update(MvcEvent mvc) {
        if (mvc.isMessage(1) || mvc.isMessage(2)) {
            AModel model = (AModel)mvc.getSource();
            ResultSet rows = (ResultSet)model.getResult();
            try {
                int rowIdx = mvc.getIndex();
                int colIdx = this.getBinding().getCol().locate(rows);
                rows.absolute(rowIdx);
                Object val = rows.getObject(colIdx);
                this.setSelected(ObjectUtil.equals(val, this.selectValue));
            }
            catch (SQLException ex) {
                log.error(ex, ex);
                this.setSelected(false);
            }
        }
    }

    protected class Ctrl
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            if (AToggleView.this.isUpdating()) {
                return;
            }
            AModel model = AToggleView.this.getModel();
            if (model instanceof ParametersModel) {
                if (AToggleView.this.getJToggleButton().isSelected()) {
                    ((ParametersModel)model).updateParameterValue(AToggleView.this.getBinding().getCol().getName(), AToggleView.this.selectValue);
                } else {
                    ((ParametersModel)model).clearParameterValue(AToggleView.this.getBinding().getCol().getName());
                }
            }
            AToggleView.this.fireValueChanged(1, AToggleView.this.getJToggleButton().isSelected());
        }
    }
}

