/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.barcode;

import com.kingdee.bos.ctrl.print.KDPrinter;
import com.kingdee.bos.ctrl.print.config.IXmlTranslate;
import com.kingdee.bos.ctrl.print.config.IXmlTranslate2;
import com.kingdee.bos.ctrl.print.ui.component.IPainter;
import com.kingdee.bos.ctrl.print.ui.component.PainterCell;
import com.kingdee.bos.ctrl.print.ui.io.Painter2Xml;
import com.kingdee.bos.ctrl.print.ui.io.Xml2Painter;
import com.kingdee.bos.ctrl.reportone.r1.print.barcode.BarcodeCellView;
import java.util.HashMap;
import java.util.Map;
import org.jdom2.Element;

public class BarCodeCell
extends PainterCell {
    private Map config;

    public Map getConfig() {
        return this.config;
    }

    public void setConfig(Map config) {
        this.config = config;
    }

    public void updateView() {
        this.setPainterView(BarcodeCellView.createPainterView());
    }

    public IXmlTranslate createXmlTrans() {
        XmlTranslate xmlTranslate = new XmlTranslate();
        if (KDPrinter.getPainterXmlTranslate((String)xmlTranslate.getName()) == null) {
            KDPrinter.registerPainterXmlTranslate((String)xmlTranslate.getName(), (IXmlTranslate)new XmlTranslate());
        }
        xmlTranslate.setExportCell(this);
        return xmlTranslate;
    }

    private static class XmlTranslate
    implements IXmlTranslate2 {
        private Painter2Xml painter2Xml;
        private Xml2Painter xml2Painter;
        BarCodeCell exportCell = null;
        private static final String BARCODE = "barcode";
        private static final String BARCODE_TYPE = "barcodeType";
        private static final String FONT_SIZE = "fontSize";
        private static final String HEIGHT = "height";
        private static final String WIDTH = "width";
        private static final String DPI = "dpi";
        private static final String MODEL_WIDTH = "modelWidth";
        private static final String BAR_HEIGHT = "barHeight";
        private static final String SHAPE = "shape";
        private static final String AUTO_MATCH = "autoMatch";
        private static final String BARCODE_HEIGHT = "barcodeHeight";
        private static final String BARCODE_WIDTH = "barcodeWidth";

        private XmlTranslate() {
        }

        public BarCodeCell getExportCell() {
            return this.exportCell;
        }

        public void setExportCell(BarCodeCell exportCell) {
            this.exportCell = exportCell;
        }

        public Element toXmlElement() {
            Element xml = new Element("BarCodeCell");
            this.painter2Xml.makeCommon((IPainter)this.exportCell, xml);
            Map config = this.exportCell.getConfig();
            String barcode = (String)config.get(BARCODE);
            String barcodeType = (String)config.get(BARCODE_TYPE);
            Integer fontSize = (Integer)config.get(FONT_SIZE);
            Double height = (Double)config.get(HEIGHT);
            Double width = (Double)config.get(WIDTH);
            Integer dpi = (Integer)config.get(DPI);
            Double modelWidth = (Double)config.get(MODEL_WIDTH);
            Double barHeight = (Double)config.get(BAR_HEIGHT);
            String shape = (String)config.get(SHAPE);
            Boolean autoMatch = (Boolean)config.get(AUTO_MATCH);
            xml.setAttribute(BARCODE, this.convertToString(barcode));
            xml.setAttribute(BARCODE_TYPE, this.convertToString(barcodeType));
            xml.setAttribute(FONT_SIZE, this.convertToString(fontSize));
            xml.setAttribute(BARCODE_HEIGHT, this.convertToString(height));
            xml.setAttribute(BARCODE_WIDTH, this.convertToString(width));
            xml.setAttribute(DPI, this.convertToString(dpi));
            xml.setAttribute(MODEL_WIDTH, this.convertToString(modelWidth));
            xml.setAttribute(BAR_HEIGHT, this.convertToString(barHeight));
            xml.setAttribute(SHAPE, this.convertToString(shape));
            xml.setAttribute(AUTO_MATCH, this.convertToString(autoMatch));
            return xml;
        }

        private String convertToString(Object obj) {
            if (obj == null) {
                return "";
            }
            return obj.toString();
        }

        public Object fromXmlElement(Element xml) {
            BarCodeCell barcodeCell = new BarCodeCell();
            this.xml2Painter.parseCommon((IPainter)barcodeCell, xml);
            String barcode = xml.getAttributeValue(BARCODE);
            String barcodeType = xml.getAttributeValue(BARCODE_TYPE);
            String fontSize = xml.getAttributeValue(FONT_SIZE);
            String height = xml.getAttributeValue(BARCODE_HEIGHT);
            String width = xml.getAttributeValue(BARCODE_WIDTH);
            String dpi = xml.getAttributeValue(DPI);
            String modelWidth = xml.getAttributeValue(MODEL_WIDTH);
            String barHeight = xml.getAttributeValue(BAR_HEIGHT);
            String shape = xml.getAttributeValue(SHAPE);
            String autoMatch = xml.getAttributeValue(AUTO_MATCH);
            HashMap<String, Object> config = new HashMap<String, Object>();
            if (!this.isNullOrEmpty(barcode)) {
                config.put(BARCODE, barcode);
            }
            if (!this.isNullOrEmpty(barcodeType)) {
                config.put(BARCODE_TYPE, barcodeType);
            }
            if (!this.isNullOrEmpty(fontSize)) {
                config.put(FONT_SIZE, Integer.parseInt(fontSize));
            }
            if (!this.isNullOrEmpty(height)) {
                config.put(HEIGHT, Double.parseDouble(height));
            }
            if (!this.isNullOrEmpty(width)) {
                config.put(WIDTH, Double.parseDouble(width));
            }
            if (!this.isNullOrEmpty(dpi)) {
                config.put(DPI, Integer.parseInt(dpi));
            }
            if (!this.isNullOrEmpty(modelWidth)) {
                config.put(MODEL_WIDTH, Double.parseDouble(modelWidth));
            }
            if (!this.isNullOrEmpty(barHeight)) {
                config.put(BAR_HEIGHT, Double.parseDouble(barHeight));
            }
            if (!this.isNullOrEmpty(shape)) {
                config.put(SHAPE, shape);
            }
            if (!this.isNullOrEmpty(autoMatch)) {
                config.put(AUTO_MATCH, Boolean.parseBoolean(autoMatch));
            }
            barcodeCell.setConfig(config);
            return barcodeCell;
        }

        private boolean isNullOrEmpty(String str) {
            return str == null || str.isEmpty();
        }

        public String getName() {
            return "BarCodeCell";
        }

        public void setPainter2Xml(Painter2Xml handle) {
            this.painter2Xml = handle;
        }

        public void setXml2Painter(Xml2Painter handle) {
            this.xml2Painter = handle;
        }
    }
}

