/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.barcode;

import com.kingdee.bos.ctrl.reportone.r1.common.R1Exception;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IReportObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.factory.IAnObjectFactory;
import com.kingdee.bos.ctrl.reportone.r1.print.barcode.BarcodeObject;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.model.xmltrans.AbstractR1PrintXmlTrans;
import org.jdom2.Element;

public class BarcodeXmlTrans
extends AbstractR1PrintXmlTrans {
    public BarcodeXmlTrans(IAnObjectFactory factory) {
        super(factory);
    }

    @Override
    protected boolean isMatch(Element node) {
        return "Barcode".equalsIgnoreCase(node.getName());
    }

    @Override
    protected IReportObject fromXml(Element node) throws R1Exception {
        BarcodeObject picObj = (BarcodeObject)this.getFactory().create();
        this.loadObjectCommon(node, picObj);
        if ("scale".equals(node.getAttributeValue("zoom"))) {
            picObj.setScale(3);
        } else {
            picObj.setScale(0);
        }
        return picObj;
    }

    @Override
    protected Element loadDataNode(Element nodeRo, IReportObject ro) {
        BarcodeObject bo = (BarcodeObject)ro;
        Element nodeData = super.loadDataNode(nodeRo, ro);
        if (nodeData != null) {
            String fontSize;
            String showSample;
            String sampleTxt;
            String symbolShape;
            String barcodeType;
            String fields = nodeData.getAttributeValue("fields");
            if (fields != null) {
                bo.StringToList(fields);
            }
            if ((barcodeType = nodeData.getAttributeValue("barcodeType")) != null) {
                bo.setBarcodeType(barcodeType);
            }
            String dpiStr = nodeData.getAttributeValue("dpi");
            String modelWidthStr = nodeData.getAttributeValue("modelWidth");
            String barHeightStr = nodeData.getAttributeValue("barHeight");
            if (dpiStr != null) {
                try {
                    bo.setDpi(Integer.parseInt(dpiStr));
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
            if (modelWidthStr != null) {
                try {
                    bo.setModelWidth(Double.parseDouble(modelWidthStr));
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
            if (barHeightStr != null) {
                try {
                    bo.setBarHeight(Double.parseDouble(barHeightStr));
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
            if ((symbolShape = nodeData.getAttributeValue("symbolShape")) != null) {
                bo.setShape(symbolShape);
            }
            if ((sampleTxt = nodeData.getAttributeValue("sampleTxt")) != null && !"".equals(sampleTxt)) {
                bo.setSampleTxt(sampleTxt);
            }
            if ((showSample = nodeData.getAttributeValue("showSample")) != null) {
                try {
                    bo.setShowSample(new Boolean(showSample));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((fontSize = nodeData.getAttributeValue("fontSize")) != null) {
                try {
                    bo.setFontSize(Integer.parseInt(fontSize));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return nodeData;
    }

    @Override
    protected boolean isMatch(IReportObject ro) {
        return ro instanceof BarcodeObject;
    }

    @Override
    protected Element toXml(IReportObject ro) {
        Element node = new Element("Barcode");
        BarcodeObject picObj = (BarcodeObject)ro;
        this.saveObjectCommon(ro, node);
        if (picObj.getScale() == 3) {
            node.setAttribute("zoom", "scale");
        }
        return node;
    }

    @Override
    protected Element saveDataNode(IReportObject ro, Element node) {
        BarcodeObject bo = (BarcodeObject)ro;
        Element nodeData = super.saveDataNode(ro, node);
        nodeData.setAttribute("barcodeType", bo.getBarcodeType());
        nodeData.setAttribute("fields", bo.fieldsToString());
        nodeData.setAttribute("dpi", bo.getDpi() + "");
        nodeData.setAttribute("modelWidth", bo.getModelWidth() + "");
        nodeData.setAttribute("barHeight", bo.getBarHeight() + "");
        if (bo.getShape() != null) {
            nodeData.setAttribute("symbolShape", bo.getShape());
        }
        if (bo.getSampleTxt() != null) {
            nodeData.setAttribute("sampleTxt", bo.getSampleTxt());
        }
        nodeData.setAttribute("showSample", bo.isShowSample() + "");
        nodeData.setAttribute("fontSize", bo.getFontSize() + "");
        return nodeData;
    }
}

