/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.barcode;

import com.google.zxing.BarcodeFormat;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.reportone.r1.print.barcode.BarCodeGeneraterUtil;
import com.kingdee.bos.ctrl.reportone.r1.print.barcode.BarcodeBindSource;
import com.kingdee.bos.ctrl.reportone.r1.print.barcode.BarcodeObject;
import com.kingdee.bos.ctrl.reportone.r1.print.barcode.EAN128Util;
import com.kingdee.bos.ctrl.reportone.r1.print.barcode.QRCodeUtils;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.IWidgetExecuteHelper;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.exception.R1PrintException;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.AbstractPrintWidget;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.IAdjustHeightSupport;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.IDatasourceSupport;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.IPrintWidget;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.io.ByteArrayOutputStream;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PWBarcode
extends AbstractPrintWidget
implements IAdjustHeightSupport,
IDatasourceSupport {
    private String _ds;
    private Variant _outputValue;
    private boolean _isAdjustHeight;
    private int _maxHeightToAdjust;
    public static final SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private BarcodeObject barcodeObject;
    public static final String BARGENFACADE_CLASSNAME = "com.kingdee.eas.barcode.scm.BarcodeGenerateFacodeFactory";
    public static final String NUMBERIC_FORMAT = "0000.00";
    private static String formulaValue = null;
    private static String barcode = "";

    public BarcodeObject getBarcodeObject() {
        return this.barcodeObject;
    }

    public void setBarcodeObject(BarcodeObject barcodeObject) {
        this.barcodeObject = barcodeObject;
    }

    @Override
    public void setDatasource(String ds) {
        this._ds = ds;
    }

    @Override
    public String getDatasource() {
        return this._ds;
    }

    public void setOutputValue(Variant value) {
        this._outputValue = value;
    }

    public Variant getOutputValue() {
        return this._outputValue;
    }

    @Override
    public IPrintWidget copy() {
        IPrintWidget widget = super.copy();
        PWBarcode wp = (PWBarcode)widget;
        wp.setBarcodeObject(this.getBarcodeObject());
        return widget;
    }

    @Override
    protected void executing(IWidgetExecuteHelper helper, IPrintWidget outputWidget) throws R1PrintException {
        boolean isQr;
        PWBarcode output = (PWBarcode)outputWidget;
        List<BarcodeBindSource> fields = this.barcodeObject.getFields();
        boolean bl = isQr = "qr".equals(this.barcodeObject.getBarcodeType()) || "datamatrix".equals(this.barcodeObject.getBarcodeType()) || "pdf417".equals(this.barcodeObject.getBarcodeType());
        if (fields != null) {
            for (int i = 0; i < fields.size(); ++i) {
                BarcodeBindSource bbs = fields.get(i);
                if ("Text".equals(bbs.getType())) {
                    barcode = barcode + bbs.getText();
                    if (!isQr || !this.containsNonAsciiChar(barcode)) continue;
                    barcode = barcode + "\n";
                    continue;
                }
                String tds = bbs.getBindDs().getDs();
                String tval = bbs.getBindField().getField().getName();
                Variant temp = this.getDataHelper(helper, tds).getFieldValue(tds, tval);
                if (temp == null || temp.getValue() == null) continue;
                Object value = temp.getValue();
                String tempBar = "";
                if (value instanceof Date) {
                    tempBar = SIMPLE_DATE_FORMAT.format(value);
                    tempBar = tempBar.replaceAll("-", "");
                } else {
                    tempBar = value instanceof BigDecimal || value instanceof Integer ? this.tranNumericToStr(value, bbs.getFormat()) : value.toString();
                }
                if (bbs.getDictId() != null) {
                    tempBar = this.getBarcodeByDict(bbs.getDictId(), value);
                }
                if (tempBar == null || "".equals(tempBar.trim())) continue;
                barcode = barcode + tempBar;
                if (!isQr || !this.containsNonAsciiChar(barcode)) continue;
                barcode = barcode + "\n";
            }
        }
        Map config = this.generateConfig(barcode);
        Variant outputValue = new Variant((Object)config);
        output.setOutputValue(outputValue);
    }

    private boolean containsNonAsciiChar(String code) {
        for (int i = 0; i < code.length(); ++i) {
            char c = code.charAt(i);
            if (c <= '\u0080') continue;
            return true;
        }
        return false;
    }

    public String tranNumericToStr(Object value, String format) {
        if (value == null) {
            return "";
        }
        if (format == null || "".equals(format)) {
            format = NUMBERIC_FORMAT;
        }
        String result = "";
        try {
            format = format.replaceAll("\\d", "0");
            int pointBeforeLength = format.length();
            int pointAfterLength = 0;
            if (format.lastIndexOf(".") > -1) {
                int pointIndex = format.lastIndexOf(".");
                pointAfterLength = format.length() - pointIndex - 1;
                pointBeforeLength = format.length() - pointAfterLength - 1;
            }
            result = value.toString();
            result.replaceAll(",", "");
            String pointStr = ".";
            if (result.lastIndexOf(".") > -1) {
                int point = result.indexOf(".");
                String str1 = result.substring(0, point);
                String str2 = result.substring(point + 1, result.length());
                result = this.subStrByLength(str1, pointBeforeLength, true) + pointStr + this.subStrByLength(str2, pointAfterLength, false);
            } else {
                result = this.subStrByLength(result, pointBeforeLength, true) + pointStr + this.subStrByLength("", pointAfterLength, false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
        return result;
    }

    public String subStrByLength(String str, int length, boolean isBefore) {
        while (str.length() < length) {
            if (isBefore) {
                str = "0" + str;
                continue;
            }
            str = str + "0";
        }
        while (str.length() > length) {
            if (isBefore) {
                str = str.substring(1);
                continue;
            }
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    private Map generateConfig(String code) {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("barcode", code);
        double height = (double)this.barcodeObject.getHeight() * 0.1;
        double width = (double)this.barcodeObject.getWidth() * 0.1;
        config.put("height", height);
        config.put("width", width);
        config.put("dpi", this.barcodeObject.getDpi());
        config.put("modelWidth", this.barcodeObject.getModelWidth());
        config.put("barHeight", this.barcodeObject.getBarHeight());
        config.put("shape", this.barcodeObject.getShape());
        if (this.barcodeObject.getScale() == 3) {
            config.put("autoMatch", true);
        } else {
            config.put("autoMatch", false);
        }
        config.put("barcodeType", this.barcodeObject.getBarcodeType());
        config.put("fontSize", this.barcodeObject.getFontSize());
        return config;
    }

    public byte[] generateBarcode(String code) throws R1PrintException {
        byte[] bb = null;
        try {
            String barcodeType;
            double height = (double)this.barcodeObject.getHeight() * 0.1;
            double width = (double)this.barcodeObject.getWidth() * 0.1;
            HashMap<String, Object> config = new HashMap<String, Object>();
            config.put("dpi", this.barcodeObject.getDpi());
            config.put("modelWidth", this.barcodeObject.getModelWidth());
            config.put("barHeight", this.barcodeObject.getBarHeight());
            config.put("height", height);
            config.put("width", width);
            config.put("shape", this.barcodeObject.getShape());
            if (this.barcodeObject.getScale() == 3) {
                config.put("autoMatch", true);
            }
            if ("datamatrix".equals(barcodeType = this.barcodeObject.getBarcodeType()) || "pdf417".equals(barcodeType)) {
                Class<?> facadeFactory = Class.forName(BARGENFACADE_CLASSNAME);
                Method m = facadeFactory.getMethod("getRemoteInstance", new Class[0]);
                Object ibc = m.invoke(facadeFactory, new Object[0]);
                Method tm = ibc.getClass().getMethod("generateBarcodePicture", String.class, String.class, Map.class);
                bb = (byte[])tm.invoke(ibc, code, this.barcodeObject.getBarcodeType(), config);
            } else if ("qr".equals(barcodeType)) {
                config.put("barcode", code);
                config.put("suffix", "jpg");
                config.put("height", this.barcodeObject.getHeight());
                config.put("width", this.barcodeObject.getWidth());
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                QRCodeUtils.generateBarcodePicture(os, BarcodeFormat.QR_CODE, config);
                bb = os.toByteArray();
            } else if ("ean-128".equals(barcodeType)) {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                bb = EAN128Util.generate(code, barcodeType, config);
            } else {
                bb = BarCodeGeneraterUtil.generateBarcodePicture(code, this.barcodeObject.getBarcodeType(), config);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Exception t1 = e;
            throw new R1PrintException("[" + code + "]\u751f\u6210\u5931\u8d25\uff0c\u53ef\u80fd\u662f\u7801\u5236\u4e0d\u652f\u6301\u5bfc\u81f4\uff01" + t1.getMessage());
        }
        return bb;
    }

    private String getBarcodeByDict(String dictId, Object value) {
        String result = null;
        try {
            CoreBaseCollection col = BarcodeBindSource.getDictEntryInterface().getCollection("where number='" + value.toString() + "' and parent.id='" + dictId + "' and parent.status=1");
            CoreBaseInfo iov = col.get(0);
            if (iov != null) {
                result = iov.getString("barcode");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public void setAdjustHeight(boolean isAdjustHeight) {
        this._isAdjustHeight = isAdjustHeight;
    }

    @Override
    public boolean isAdjustHeight() {
        return this._isAdjustHeight;
    }

    @Override
    public void setMaxHeightToAdjust(int maxHeight) {
        this._maxHeightToAdjust = maxHeight;
    }

    @Override
    public int getMaxHeightToAdjust() {
        return this._maxHeightToAdjust;
    }

    @Override
    public void setRemainContent(boolean isRemain) {
    }

    @Override
    public boolean isRemainContent() {
        return false;
    }

    @Override
    public Object getFieldValue(String field) {
        return this.getFieldValue(this.getDatasource(), field);
    }

    @Override
    public void setValue(Object value) {
        formulaValue = value != null ? value.toString() : null;
    }

    @Override
    protected void doAfterExecuteChildren(IPrintWidget outputWidget) {
        PWBarcode output = (PWBarcode)outputWidget;
        if (formulaValue != null) {
            Map config = this.generateConfig(formulaValue);
            Variant outputValue = new Variant((Object)config);
            output.setOutputValue(outputValue);
        }
        formulaValue = null;
        barcode = "";
    }

    @Override
    public Object getValue() {
        return barcode;
    }
}

