/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.barcode.painter;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbarcode.encode.BarSet;
import org.krysalis.barcode4j.BarGroup;
import org.krysalis.barcode4j.ChecksumMode;
import org.krysalis.barcode4j.ClassicBarcodeLogicHandler;
import org.krysalis.barcode4j.impl.code128.Code128LogicImpl;
import org.krysalis.barcode4j.impl.code128.EAN128LogicImpl;

public class EAN128Utils {
    private static Map<Integer, List<List<Integer>>> specificFormats = new HashMap<Integer, List<List<Integer>>>();

    public static String getEAN128HumanReadableCode(String code) {
        code = code.trim();
        try {
            return EAN128Utils.innerGetEAN128HumanReadableCode(code);
        }
        catch (Exception e) {
            String result = EAN128Utils.tryGetEAN128HumanReadableCode(code);
            if (result != null) {
                return result;
            }
            return code;
        }
    }

    private static String tryGetEAN128HumanReadableCode(String code) {
        int length = code.length();
        List<List<Integer>> formats = specificFormats.get(length);
        if (formats == null) {
            return null;
        }
        for (List<Integer> format : formats) {
            try {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < code.length(); ++i) {
                    sb.append(code.charAt(i));
                    if (!format.contains(i)) continue;
                    sb.append("F");
                }
                String fixedCode = sb.toString();
                return EAN128Utils.innerGetEAN128HumanReadableCode(fixedCode);
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    private static String innerGetEAN128HumanReadableCode(String code) {
        code = code.trim();
        InternalEAN128LogicImpl impl = new InternalEAN128LogicImpl();
        impl.setMessage(code);
        return impl.getHumanReadableMsg();
    }

    public static BarSet[] encode(String code) {
        try {
            code = code.trim();
            return EAN128Utils.innerEncode(code);
        }
        catch (Exception e) {
            BarSet[] barSets = EAN128Utils.tryEncode(code);
            if (barSets != null) {
                return barSets;
            }
            throw new RuntimeException(e);
        }
    }

    private static BarSet[] tryEncode(String code) {
        int length = code.length();
        List<List<Integer>> formats = specificFormats.get(length);
        if (formats == null) {
            return null;
        }
        for (List<Integer> format : formats) {
            try {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < code.length(); ++i) {
                    sb.append(code.charAt(i));
                    if (!format.contains(i)) continue;
                    sb.append("F");
                }
                String fixedCode = sb.toString();
                return EAN128Utils.innerEncode(fixedCode);
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    private static BarSet[] innerEncode(String code) {
        InternalEAN128LogicImpl impl = new InternalEAN128LogicImpl();
        InternalClassicBarcodeLogicHandler logic = new InternalClassicBarcodeLogicHandler();
        impl.generateBarcodeLogic(logic, code);
        List<BarSet> barSets = logic.getBarSets();
        return barSets.toArray(new BarSet[barSets.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        InputStream is = null;
        try {
            String line;
            is = EAN128Utils.class.getResourceAsStream("format.txt");
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((line = br.readLine()) != null) {
                if (line.trim().isEmpty() || line.startsWith("#")) continue;
                String[] keyValue = line.split("\\:");
                Integer length = Integer.parseInt(keyValue[0]);
                String value = keyValue[1];
                ArrayList formats = new ArrayList();
                for (String formatStr : value.split("\\;")) {
                    ArrayList<Integer> format = new ArrayList<Integer>();
                    for (String posStr : formatStr.trim().split("\\,")) {
                        int pos = Integer.parseInt(posStr.trim());
                        format.add(pos);
                    }
                    formats.add(format);
                }
                specificFormats.put(length, formats);
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static class InternalClassicBarcodeLogicHandler
    implements ClassicBarcodeLogicHandler {
        private List<BarSet> barSets = new ArrayList<BarSet>();
        private StringBuilder sb = new StringBuilder();

        private InternalClassicBarcodeLogicHandler() {
        }

        public List<BarSet> getBarSets() {
            return this.barSets;
        }

        public void startBarcode(String msg, String formattedMsg) {
        }

        public void endBarcode() {
        }

        public void startBarGroup(BarGroup type, String submsg) {
        }

        public void addBar(boolean black, int weight) {
            if (black) {
                for (int i = 0; i < weight; ++i) {
                    this.sb.append("1");
                }
            } else {
                for (int i = 0; i < weight; ++i) {
                    this.sb.append("0");
                }
            }
        }

        public void endBarGroup() {
            BarSet barSet = new BarSet(this.sb.toString());
            this.barSets.add(barSet);
            this.sb = new StringBuilder();
        }
    }

    private static class InternalCode128LogicImpl
    extends Code128LogicImpl {
        private InternalCode128LogicImpl() {
        }

        public void encodeChar(ClassicBarcodeLogicHandler logic, int index) {
            super.encodeChar(logic, index);
        }

        protected void encodeStop(ClassicBarcodeLogicHandler logic) {
            super.encodeStop(logic);
        }
    }

    private static class InternalEAN128LogicImpl
    extends EAN128LogicImpl {
        private static final char DEFAULT_GROUP_SEPARATOR = 'F';
        private static ChecksumMode checksumMode = ChecksumMode.CP_AUTO;
        private static String template = null;
        private static char groupSeparator = (char)70;

        public InternalEAN128LogicImpl() {
            super(checksumMode, null, groupSeparator);
        }

        public void setMessage(String msg) {
            super.setMessage(msg);
        }

        public void generateBarcodeLogic(ClassicBarcodeLogicHandler logic, String msg) {
            int[] encodedMsg = this.getEncodedMessage(msg);
            InternalCode128LogicImpl c128 = new InternalCode128LogicImpl();
            logic.startBarcode(msg, this.getHumanReadableMsg());
            for (int i = 0; i < encodedMsg.length; ++i) {
                c128.encodeChar(logic, encodedMsg[i]);
            }
            int checksum = encodedMsg[0];
            for (int i = 1; i < encodedMsg.length; ++i) {
                checksum += i * encodedMsg[i];
            }
            c128.encodeChar(logic, checksum %= 103);
            c128.encodeStop(logic);
            logic.endBarcode();
        }
    }
}

