/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.barcode.painter;

import com.kingdee.bos.ctrl.reportone.r1.print.barcode.painter.BarcodeContext;
import com.kingdee.bos.ctrl.reportone.r1.print.barcode.painter.BaseBarPainter;
import com.kingdee.bos.ctrl.reportone.r1.print.barcode.painter.GraphicsForBarcode;
import com.kingdee.bos.ctrl.reportone.r1.print.barcode.painter.MathUtils;
import java.awt.Color;
import org.jbarcode.encode.BarSet;

public class WideRatioPainter
extends BaseBarPainter {
    @Override
    public void doPaint(BarcodeContext barcodeContext) {
        BarSet[] barSets = barcodeContext.getBarSets();
        double width = barcodeContext.getWidth();
        double height = barcodeContext.getHeight();
        double totalBars = 20.0;
        double trueBar = 2.0;
        double falseBar = 1.0;
        for (int i = 0; i < barSets.length; ++i) {
            BarSet barSet = barSets[i];
            for (int j = 0; j < barSet.length(); ++j) {
                if (barSet.get(j)) {
                    totalBars += trueBar;
                    continue;
                }
                totalBars += falseBar;
            }
        }
        double unitBarWidth = width / totalBars;
        if (!barcodeContext.isScale()) {
            unitBarWidth = MathUtils.floor(unitBarWidth);
        }
        barcodeContext.setBarWidth(unitBarWidth);
        double barZoneWidth = unitBarWidth * totalBars;
        barcodeContext.setBarZoneWidth(barZoneWidth);
        double barZoneHeight = height;
        barcodeContext.setBarZoneHeight(barZoneHeight);
        double barZoneStartX = (width - barZoneWidth) / 2.0;
        barcodeContext.setBarZoneStartX(barZoneStartX);
        double barPadding = 10.0 * unitBarWidth;
        barcodeContext.setBarPaddingX(barPadding);
        double trueBarWidth = unitBarWidth * trueBar;
        double falseBarWidth = unitBarWidth * falseBar;
        GraphicsForBarcode g = barcodeContext.getGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0.0, 0.0, width, height);
        double x = barZoneStartX + 10.0 * unitBarWidth;
        Color color = Color.BLACK;
        g.setColor(color);
        for (int i = 0; i < barSets.length; ++i) {
            BarSet barSet = barSets[i];
            for (int j = 0; j < barSet.length(); ++j) {
                double barWidth = barSet.get(j) ? trueBarWidth : falseBarWidth;
                g.fillRect((double)WideRatioPainter.round(x), 2.0, (double)WideRatioPainter.round(barWidth), height - 4.0);
                color = Color.WHITE.equals(color) ? Color.BLACK : Color.WHITE;
                g.setColor(color);
                x += barWidth;
            }
        }
    }

    private static int round(double d) {
        return (int)Math.round(d);
    }
}

