/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.designer.actions.operate.grid;

import com.kingdee.bos.ctrl.common.layout.table.Cell;
import com.kingdee.bos.ctrl.common.layout.table.Table;
import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.common.ui.NormalSelector;
import com.kingdee.bos.ctrl.common.ui.SimpleDialog;
import com.kingdee.bos.ctrl.common.ui.TypicalDialog;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.meta.MetaField;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.actions.operate.grid.AbstractGroupManageOperate;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.group.R1DataGridGroup;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.icon.R1DesignerIcons;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.datagrid.DataGrid;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.datagrid.R1PrintGroup;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.gui.util.CustomMetaField;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class GroupManageOperate
extends AbstractGroupManageOperate {
    @Override
    public boolean isValid() {
        Object objSelected = this.getSelected().getRootPathComponent();
        return objSelected instanceof DataGrid;
    }

    @Override
    protected AbstractGroupManageOperate.IManageDialog createManageDialog() {
        return (AbstractGroupManageOperate.IManageDialog)WindowUtil.createWindow(GroupManageDialog.class, (Component)this.getParentCtrl());
    }

    public static class GroupManageDialog
    extends TypicalDialog
    implements AbstractGroupManageOperate.IManageDialog {
        private Selector _selector;
        private KDTree _supplyTree;
        private MetaClass _dataSource;

        public GroupManageDialog() {
        }

        public GroupManageDialog(Dialog owner) {
            super(owner);
        }

        public GroupManageDialog(Frame owner) {
            super(owner);
        }

        protected void todoInit() {
            this.setSize(640, 480);
            this.setTitle(MultiLanguageUtil.getMLS("grid.GroupManageOperate.groupManage", ""));
            KDLabel remindLabel = new KDLabel("\u6ce8\u610f\uff1a\u8981\u540c\u65f6\u4e24\u8fb9\u90fd\u9009\u4e2d\u5b57\u6bb5\u540e\uff0c\u3010\u66ff\u6362\u3011\u6309\u94ae\u624d\u53ef\u7528\u3002", 2);
            remindLabel.setForeground(Color.gray);
            this.getExtPanel().setLayout((LayoutManager)new BorderLayout());
            this.getExtPanel().add((Component)remindLabel, (Object)"West");
            this._supplyTree = new KDTree();
            this._selector = new Selector();
            this._selector.setSupplyTitle(MultiLanguageUtil.getMLS("grid.GroupManageOperate.spareField", ""));
            this._selector.setSelectedTitle(MultiLanguageUtil.getMLS("grid.GroupManageOperate.addGroup", ""));
            this._selector.setSupplyCtrl(this._supplyTree);
        }

        protected void todoAddControls(Container parent, Cell thisCell) {
            parent.add((Component)((Object)this._selector), thisCell);
        }

        @Override
        public void setSupplyData(MetaClass mc) {
            this._dataSource = mc;
            DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)mc);
            for (MetaField mf : mc.getFields()) {
                DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode((Object)new CustomMetaField(mf));
                root.add((MutableTreeNode)node);
            }
            this._supplyTree.setModel((TreeModel)new KingdeeTreeModel((TreeNode)root));
        }

        @Override
        public void setGroups(R1DataGridGroup[] groups) {
            this._selector.getSelectedList().removeAllElements();
            for (int i = 0; i < groups.length; ++i) {
                GroupView groupView = new GroupView(groups[i], this._dataSource);
                this._selector.getSelectedList().addElement((Object)groupView);
            }
        }

        @Override
        public R1DataGridGroup[] getGroups() {
            KDList listCtrl = this._selector.getSelectedList();
            int size = listCtrl.getElementCount();
            R1DataGridGroup[] result = new R1PrintGroup[size];
            for (int i = 0; i < size; ++i) {
                GroupView groupView = (GroupView)listCtrl.getElement(i);
                groupView.updateField();
                result[i] = groupView.getGroup();
            }
            return result;
        }

        private static class GroupPropertyAction
        extends AbstractAction {
            private Selector selector;

            public GroupPropertyAction(Selector s) {
                this.selector = s;
                this.putValue("Name", MultiLanguageUtil.getMLS("grid.GroupManageOperate.highLevel", ""));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                GroupView gv = (GroupView)this.selector.getSelectedList().getSelectedValue();
                if (gv == null) {
                    return;
                }
                R1PrintGroup group = gv.getGroup();
                SettingPanel panel = new SettingPanel();
                panel.setField(gv.toString());
                panel.setDividePage(group.isDividePageWhenDifferGroup());
                panel.setDividePageWhenEconomicPrint(group.isDividePageWhenEconomicPrint());
                SimpleDialog dlg = SimpleDialog.create((Component)((Object)this.selector));
                dlg.setSize(240, 160);
                dlg.setTitle(MultiLanguageUtil.getMLS("grid.GroupManageOperate.setGroupLevel", ""));
                dlg.setComponent((Component)((Object)panel));
                if (dlg.showDialog()) {
                    group.setDividePageWhenDifferGroup(panel.isDividePage());
                    group.setDividePageWhenEconomicPrint(panel.isDividePageWhenEconomicPrint());
                }
            }

            private static class SettingPanel
            extends KDPanel {
                private KDLabel labFieldName;
                private KDCheckBox chkDividePage;
                private KDCheckBox chkDividePageWhenEconomicPrint;

                public SettingPanel() {
                    this.init();
                }

                private void init() {
                    this.labFieldName = new KDLabel();
                    this.chkDividePage = new KDCheckBox(MultiLanguageUtil.getMLS("grid.GroupManageOperate.newPageByGroup", ""));
                    this.chkDividePageWhenEconomicPrint = new KDCheckBox(MultiLanguageUtil.getMLS("grid.GroupManageOperate.newPageByGroupWhenEconomicPrint", ""));
                    TableLayout tl = TableLayout.split((int)4, (int)1);
                    tl.rowStyle(0).setHeight(20);
                    tl.rowStyle(1).setHeight(20);
                    tl.rowStyle(2).setHeight(20);
                    tl.rowStyle(3).setPriY(1);
                    Table row0 = tl.cell(0).splitCol(2);
                    row0.colStyle(0).setWidth(80);
                    row0.colStyle(1).setPriX(1);
                    this.setLayout((LayoutManager)tl);
                    this.add((Component)new KDLabel(MultiLanguageUtil.getMLS("grid.GroupManageOperate.groupField", "")), row0.cell(0));
                    this.add((Component)this.labFieldName, row0.cell(1));
                    this.add((Component)this.chkDividePage, tl.cell(1));
                    this.add((Component)this.chkDividePageWhenEconomicPrint, tl.cell(2));
                }

                public void setField(String fieldAlias) {
                    this.labFieldName.setText(fieldAlias);
                }

                public void setDividePage(boolean b) {
                    this.chkDividePage.setSelected(b);
                }

                public boolean isDividePage() {
                    return this.chkDividePage.isSelected();
                }

                public void setDividePageWhenEconomicPrint(boolean b) {
                    this.chkDividePageWhenEconomicPrint.setSelected(b);
                }

                public boolean isDividePageWhenEconomicPrint() {
                    return this.chkDividePageWhenEconomicPrint.isSelected();
                }
            }
        }

        private static class Selector
        extends NormalSelector {
            private KDTree supplyTree;

            public Selector() {
                this.getSelected().addButton((Action)new GroupPropertyAction(this), "");
                this.btnSelectAll.setToolTipText(MultiLanguageUtil.getMLS("grid.GroupManageOperate.toolTips", ""));
                this.btnSelectAll.setIcon((Icon)R1DesignerIcons.createIcon("tbtn/tbtn_replace.gif"));
                this.installJListListener((JList)this.lvSelected.getList());
                this.btnSelectAll.setEnabled(false);
                this.syncListViewButton();
            }

            public void setSupplyCtrl(KDTree supply) {
                this.supplyTree = supply;
                this.supplyTree.addTreeSelectionListener(new TreeSelectionListener(){

                    @Override
                    public void valueChanged(TreeSelectionEvent e) {
                        this.setSelectAllbtn();
                    }
                });
                super.setSupplyCtrl((JComponent)supply);
            }

            protected void onSelect() {
                int selCnt = this.supplyTree.getSelectionCount();
                if (selCnt != 1) {
                    return;
                }
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.supplyTree.getSelectionPath().getLastPathComponent();
                Object meta = node.getUserObject();
                if (meta instanceof MetaField) {
                    MetaField mf = (MetaField)meta;
                    R1PrintGroup newGroup = new R1PrintGroup(mf.getName());
                    GroupView groupView = new GroupView((R1DataGridGroup)newGroup, mf);
                    if (this.getSelectedList().getIndexOfElement((Object)groupView) >= 0) {
                        WindowUtil.msgboxWarning((Object)MultiLanguageUtil.getMLS("grid.GroupManageOperate.hasTheField", ""), (String)MultiLanguageUtil.getMLS("grid.GroupManageOperate.cueInfo", ""), (Component)((Object)this));
                    } else {
                        this.getSelectedList().addElement((Object)groupView);
                    }
                }
            }

            protected boolean onDelete() {
                int[] idxs = this.getSelectedList().getSelectedIndices();
                if (idxs.length == 0) {
                    return false;
                }
                if (!WindowUtil.msgboxYesNo((Component)((Object)this), (Object)MultiLanguageUtil.getMLS("grid.GroupManageOperate.info", ""), (String)MultiLanguageUtil.getMLS("grid.GroupManageOperate.cueInfo", ""))) {
                    return false;
                }
                for (int i = idxs.length - 1; i >= 0; --i) {
                    this.getSelectedList().removeElementAt(idxs[i]);
                }
                if (idxs[0] < this.getSelectedList().getElementCount()) {
                    this.getSelectedList().setSelectedIndex(idxs[0]);
                } else {
                    this.getSelectedList().setSelectedIndex(this.getSelectedList().getElementCount() - 1);
                }
                return true;
            }

            protected void onSelectAll() {
                int selCnt = this.supplyTree.getSelectionCount();
                if (selCnt != 1) {
                    return;
                }
                int[] selList = this.getSelectedList().getSelectedIndices();
                if (selList.length != 1) {
                    return;
                }
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.supplyTree.getSelectionPath().getLastPathComponent();
                Object meta = node.getUserObject();
                if (meta instanceof MetaField) {
                    MetaField mf = (MetaField)meta;
                    R1PrintGroup newGroup = new R1PrintGroup(mf.getName());
                    GroupView groupView = new GroupView((R1DataGridGroup)newGroup, mf);
                    if (this.getSelectedList().getIndexOfElement((Object)groupView) >= 0) {
                        WindowUtil.msgboxWarning((Object)MultiLanguageUtil.getMLS("grid.GroupManageOperate.hasTheField", ""), (String)MultiLanguageUtil.getMLS("grid.GroupManageOperate.cueInfo", ""), (Component)((Object)this));
                    } else {
                        groupView = (GroupView)this.getSelectedList().getElement(selList[0]);
                        groupView.syncText(mf);
                        groupView.setCurrentFiled(mf);
                        this.getSelectedList().setSelectedIndex(selList[0]);
                        this.repaint();
                    }
                }
            }

            protected void syncListViewButton() {
                if (this.lvSelected.getList().getSelectedIndex() == -1) {
                    this.btnDelete.setEnabled(false);
                } else {
                    this.btnDelete.setEnabled(true);
                }
                if (this.lvSelected.getList().getElementCount() > 0) {
                    this.btnDeleteAll.setEnabled(true);
                } else {
                    this.btnDeleteAll.setEnabled(false);
                }
            }

            private void installJListListener(JList list) {
                list.addListSelectionListener(new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent e) {
                        this.setSelectAllbtn();
                    }
                });
            }

            private void setSelectAllbtn() {
                if (this.supplyTree == null || this.supplyTree.getSelectionCount() != 1) {
                    this.btnSelectAll.setEnabled(false);
                } else {
                    DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.supplyTree.getSelectionPath().getLastPathComponent();
                    Object meta = node.getUserObject();
                    if (meta instanceof MetaField && this.getSelectedList().getSelectedIndices().length == 1) {
                        this.btnSelectAll.setEnabled(true);
                    } else {
                        this.btnSelectAll.setEnabled(false);
                    }
                }
            }
        }

        private static class GroupView {
            private String text;
            private String currentField;
            private R1PrintGroup group;

            public GroupView(R1DataGridGroup g, MetaClass mc) {
                this.group = (R1PrintGroup)g;
                if (mc != null && this.group.getAccordingType() == 1) {
                    String field = this.group.getAccording();
                    MetaField mf = mc.getField(field);
                    this.syncText(mf);
                    this.setCurrentFiled(mf);
                } else {
                    this.text = this.group.getAccording();
                    this.currentField = this.group.getAccording();
                }
            }

            public GroupView(R1DataGridGroup g, MetaField mf) {
                this.group = (R1PrintGroup)g;
                this.syncText(mf);
                this.setCurrentFiled(mf);
            }

            private void syncText(MetaField mf) {
                this.text = mf != null ? new CustomMetaField(mf).toString() : this.group.getAccording();
            }

            private void setCurrentFiled(MetaField mf) {
                this.currentField = mf != null ? mf.getName() : this.group.getAccording();
            }

            public String getCurrentFiled() {
                return this.currentField;
            }

            public R1PrintGroup getGroup() {
                return this.group;
            }

            public String toString() {
                return this.text;
            }

            public boolean equals(Object obj) {
                if (obj instanceof GroupView) {
                    GroupView another = (GroupView)obj;
                    return this.currentField.equals(another.getCurrentFiled());
                }
                return false;
            }

            public int hashCode() {
                return this.group.hashCode();
            }

            public void updateField() {
                if (!this.currentField.equals(this.group.getAccording())) {
                    this.group.setAccording(this.currentField);
                }
            }
        }
    }
}

