/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.designer.gui.clipboard;

import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ElementPath;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IReportObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractCell;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractGrid;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.clipboard.R1Clipboard;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.ICellValueSupported;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.datagrid.DataGrid;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.datagrid.DataGridCell;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.layoutgrid.LayoutGridCell;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.loop.LoopArea;
import java.awt.Component;
import java.awt.Point;

public class R1PrintClipboard
extends R1Clipboard {
    private static final int T_Object = 16;
    private static final int T_Content_DataGridCell = 33;
    private static final int T_Content_LayoutGridCell = 34;
    private int _operateType = 0;

    private boolean isAllCell() {
        Object e;
        ElementPath[] paths = this._core.getSelectionModel().getAll();
        int cellCount = 0;
        for (int i = 0; i < paths.length && (e = paths[i].getLastPathComponent()) instanceof AbstractCell; ++i) {
            ++cellCount;
        }
        return cellCount == paths.length;
    }

    @Override
    public boolean isCanCopy() {
        if (this.isAllCell()) {
            return true;
        }
        return super.isCanCopy();
    }

    @Override
    public boolean copy() {
        if (this.isAllCell()) {
            ElementPath ep = this._core.getSelectionModel().getCurrent();
            Object ele = ep.getLastPathComponent();
            if (ele instanceof DataGridCell) {
                this._operateType = 33;
            } else if (ele instanceof LayoutGridCell) {
                this._operateType = 34;
            }
        } else {
            this._operateType = 16;
        }
        return super.copy();
    }

    @Override
    public boolean paste() {
        Point idx;
        AbstractCell cell;
        AbstractGrid grid;
        int i;
        if (this._operateType == 16) {
            return super.paste();
        }
        ElementPath currentSelected = this._core.getSelectionModel().getCurrent();
        Object currentEle = currentSelected.getLastPathComponent();
        if (!(currentEle instanceof AbstractCell)) {
            return false;
        }
        if (this._operateType == 34 && currentEle instanceof DataGridCell || this._operateType == 33 && currentEle instanceof LayoutGridCell) {
            return false;
        }
        AbstractCell currentCell = (AbstractCell)currentEle;
        AbstractGrid currentGrid = (AbstractGrid)currentSelected.getRootPathComponent();
        Point currentIndex = currentGrid.getIndexOfCell(currentCell);
        int oriMinRowIdx = Integer.MAX_VALUE;
        int oriMinColIdx = Integer.MAX_VALUE;
        int oriMaxRowIdx = Integer.MIN_VALUE;
        int oriMaxColIdx = Integer.MIN_VALUE;
        ElementPath[] eps = this.cloneModel(this._targets).getAll();
        for (i = 0; i < eps.length; ++i) {
            grid = (AbstractGrid)eps[i].getRootPathComponent();
            cell = (AbstractCell)eps[i].getLastPathComponent();
            idx = grid.getIndexOfCell(cell);
            if (idx.x < oriMinRowIdx) {
                oriMinRowIdx = idx.x;
            }
            if (idx.x > oriMaxRowIdx) {
                oriMaxRowIdx = idx.x;
            }
            if (idx.y < oriMinColIdx) {
                oriMinColIdx = idx.y;
            }
            if (idx.y <= oriMaxColIdx) continue;
            oriMaxColIdx = idx.y;
        }
        if (currentIndex.y + (oriMaxColIdx - oriMinColIdx) >= currentGrid.getColumnsCount() || currentIndex.x + (oriMaxRowIdx - oriMinRowIdx) >= currentGrid.getRowsCount()) {
            WindowUtil.msgboxInfo((Object)MultiLanguageUtil.getMLS("clipboard.R1PrintClipboard.info", ""), (String)this._core.getPromptTitle(), (Component)this._core.getPanel());
            return false;
        }
        for (i = 0; i < eps.length; ++i) {
            grid = (AbstractGrid)eps[i].getRootPathComponent();
            cell = (AbstractCell)eps[i].getLastPathComponent();
            idx = grid.getIndexOfCell(cell);
            int rowIdx = currentIndex.x + idx.x - oriMinRowIdx;
            int colIdx = currentIndex.y + idx.y - oriMinColIdx;
            ICellValueSupported aimCell = (ICellValueSupported)((Object)currentGrid.getCell(rowIdx, colIdx));
            aimCell.setValue(((ICellValueSupported)((Object)cell)).getValue());
        }
        this._core.getModel().updateFieldInfo();
        this._core.getPageContainer().repaint();
        return true;
    }

    @Override
    public String checkCanAddChild(ElementPath parent, IReportObject child, Point mousePoint) {
        if (child instanceof DataGrid) {
            IReportObject parentObj;
            ElementPath ep = parent;
            do {
                if ((parentObj = (IReportObject)ep.getRootPathComponent()) instanceof DataGrid) {
                    return "";
                }
                if (!(parentObj instanceof LoopArea)) continue;
                return "";
            } while ((ep = parentObj.getParent()) != null);
        } else if (child instanceof LoopArea) {
            IReportObject parentObj;
            ElementPath ep = parent;
            do {
                if (!((parentObj = (IReportObject)ep.getRootPathComponent()) instanceof LoopArea)) continue;
                return "";
            } while ((ep = parentObj.getParent()) != null);
        }
        return super.checkCanAddChild(parent, child, mousePoint);
    }
}

