/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.designer.gui.property;

import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.meta.MetaField;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.DataExtend;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.Field;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.IBind;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.IR1DataManager;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ElementPath;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core.ComboPanel;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.property.AbstractPropertyPanel;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.AbstractTextObject;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;

public class PanelTextData
extends AbstractPropertyPanel {
    private IR1DataManager dm;
    private KDRadioButton radBind;
    private KDRadioButton radCustom;
    private KDComboBox cmbBindDs;
    private KDComboBox cmbBindField;
    private JTextComponent txtCustom;
    private boolean isTxtCustomUnsure = false;
    private boolean isTxtCustomEdited = false;

    public PanelTextData() {
        this.init();
        this.installListener();
    }

    protected void init() {
        this.txtCustom = this.createCustomContentCtrl();
        this.radBind = new KDRadioButton(MultiLanguageUtil.getMLS("property.PanelTextData.bind", ""));
        this.radCustom = new KDRadioButton(MultiLanguageUtil.getMLS("property.PanelTextData.selfDefine", ""));
        ButtonGroup bg = new ButtonGroup();
        bg.add((AbstractButton)this.radBind);
        bg.add((AbstractButton)this.radCustom);
        this.cmbBindDs = new KDComboBox();
        this.cmbBindField = new KDComboBox();
        KDLabelContainer lbcBindData = CtrlSwingUtilities.createLabelContainer((JComponent)this.cmbBindDs, (String)MultiLanguageUtil.getMLS("property.PanelTextData.dataSource", ""), (int)100);
        KDLabelContainer lbcBindFiled = CtrlSwingUtilities.createLabelContainer((JComponent)this.cmbBindField, (String)MultiLanguageUtil.getMLS("property.PanelTextData.field", ""), (int)100);
        TableLayout tl = TableLayout.split((int)6, (int)1);
        tl.rowStyle(0).setHeight(19);
        tl.rowStyle(0).setMarginBottom(6);
        tl.rowStyle(1).setHeight(19);
        tl.rowStyle(1).setMarginLeft(20);
        tl.rowStyle(1).setMarginBottom(3);
        tl.rowStyle(2).setHeight(19);
        tl.rowStyle(2).setMarginLeft(20);
        tl.rowStyle(2).setMarginBottom(10);
        tl.rowStyle(3).setHeight(19);
        tl.rowStyle(3).setMarginBottom(6);
        tl.rowStyle(4).setMarginLeft(20);
        tl.rowStyle(5).setPriY(1);
        KDPanel panOwner = new KDPanel((LayoutManager)tl);
        panOwner.add((Component)this.radBind, (Object)tl.cell(0));
        panOwner.add((Component)lbcBindData, (Object)tl.cell(1));
        panOwner.add((Component)lbcBindFiled, (Object)tl.cell(2));
        panOwner.add((Component)this.radCustom, (Object)tl.cell(3));
        panOwner.add((Component)this.createCustomContentCtrlWrapper(this.txtCustom), (Object)tl.cell(4));
        this.setLayout(new BorderLayout());
        this.add((Component)panOwner, "Center");
    }

    private void installListener() {
        this.radBind.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelTextData.this.syncCtrlEnabled();
            }
        });
        this.radCustom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelTextData.this.syncCtrlEnabled();
            }
        });
        this.cmbBindDs.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Object item = PanelTextData.this.cmbBindDs.getSelectedItem();
                String dsName = null;
                if (item instanceof DataExtend) {
                    dsName = ((DataExtend)((Object)item)).getName();
                }
                PanelTextData.this.prepareFieldSupplyValue(dsName);
            }
        });
        this.txtCustom.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                PanelTextData.this.isTxtCustomEdited = true;
            }
        });
    }

    private void syncCtrlEnabled() {
        this.cmbBindDs.setEnabled(this.radBind.isSelected());
        this.cmbBindField.setEnabled(this.radBind.isSelected());
        this.txtCustom.setEnabled(this.radCustom.isSelected());
    }

    @Override
    protected void updateElementValue(ElementPath elePath) {
        AbstractTextObject ro = (AbstractTextObject)elePath.getLastPathComponent();
        if (this.radBind.isSelected()) {
            if (this.cmbBindDs.getSelectedIndex() >= 0) {
                DataExtend ext = (DataExtend)((Object)this.cmbBindDs.getSelectedItem());
                ro.getDataSource().setDs(ext.getName());
                ro.setText(null);
            }
            if (this.cmbBindField.getSelectedIndex() >= 0) {
                ro.getBindField().setField((Field)this.cmbBindField.getSelectedItem());
            }
        }
        if (this.radCustom.isSelected() && (!this.isTxtCustomUnsure || this.isTxtCustomEdited)) {
            ro.setText(this.txtCustom.getText());
            ro.getDataSource().setDs(null);
            ro.getBindField().setField(null);
        }
    }

    @Override
    public String getTitle() {
        return MultiLanguageUtil.getMLS("property.PanelTextData.data", "");
    }

    @Override
    public void prepareCtrlValue(ElementPath[] eles) {
        AbstractTextObject ro = (AbstractTextObject)eles[0].getLastPathComponent();
        boolean isBindData = ro.isBindData();
        String dsName = ro.getDataSource().getDs();
        Field field = ro.getBindField().getField();
        String text = ro.getText();
        boolean isBindDataUnsure = false;
        boolean isDsUnsure = false;
        boolean isFieldUnsure = false;
        boolean isTextUnsure = false;
        for (int i = 1; i < eles.length; ++i) {
            ro = (AbstractTextObject)eles[i].getLastPathComponent();
            if (!isBindDataUnsure && isBindData != ro.isBindData()) {
                isBindDataUnsure = true;
            }
            if (!isDsUnsure && !StringUtil.equals((String)dsName, (String)ro.getDataSource().getDs())) {
                isDsUnsure = true;
            }
            if (!isFieldUnsure && !Field.equals(field, ro.getBindField().getField())) {
                isFieldUnsure = true;
            }
            if (isTextUnsure || StringUtil.equals((String)text, (String)ro.getText())) continue;
            isTextUnsure = true;
        }
        this.isTxtCustomUnsure = isTextUnsure;
        if (isBindDataUnsure) {
            this.radBind.setSelected(false);
            this.radCustom.setSelected(false);
            this.cmbBindDs.setSelectedIndex(-1);
            this.cmbBindField.setSelectedIndex(-1);
            this.txtCustom.setText(null);
        } else {
            this.radBind.setSelected(isBindData);
            this.radCustom.setSelected(!isBindData);
            if (isDsUnsure) {
                this.cmbBindDs.setSelectedIndex(-1);
                this.cmbBindField.setSelectedIndex(-1);
            } else {
                this.cmbBindDs.setSelectedItem((Object)this.dm.getDataExtend(dsName));
                this.prepareFieldSupplyValue(dsName);
                if (isFieldUnsure) {
                    this.cmbBindField.setSelectedIndex(-1);
                } else {
                    this.cmbBindField.setSelectedItem((Object)field);
                }
            }
            if (isTextUnsure) {
                this.txtCustom.setText(null);
            } else {
                this.txtCustom.setText(text);
            }
        }
        this.syncCtrlEnabled();
    }

    @Override
    public void prepareSupplyValue(ComboPanel core, ElementPath[] eles) {
        this.dm = core.getModel().getDataManager();
        AbstractTextObject ro = (AbstractTextObject)eles[0].getLastPathComponent();
        IBind.IBindDataSource bindDS = ro.getDataSource();
        this.cmbBindDs.removeAllItems();
        DataExtend[] exts = this.dm.getAllDataExtends(new String[]{"param.context"});
        for (int i = 0; i < exts.length; ++i) {
            DataExtend ext = exts[i];
            MetaClass mc = (MetaClass)this.dm.getObject(ext.getName());
            if (mc == null || !bindDS.isTypeSupproted(mc.getType())) continue;
            this.cmbBindDs.addItem((Object)ext);
        }
        this.cmbBindDs.setSelectedIndex(-1);
    }

    private void prepareFieldSupplyValue(String dsName) {
        Object objDs = this.dm.getObject(dsName);
        this.cmbBindField.removeAllItems();
        if (objDs instanceof MetaClass) {
            for (MetaField mf : ((MetaClass)objDs).getFields()) {
                Field field = Field.fromMetaField(mf);
                this.cmbBindField.addItem((Object)field);
            }
        }
        this.cmbBindField.setSelectedIndex(-1);
    }

    protected JTextComponent createCustomContentCtrl() {
        return new KDTextArea();
    }

    protected JComponent createCustomContentCtrlWrapper(JTextComponent ctrl) {
        KDScrollPane scp = new KDScrollPane((Component)ctrl);
        scp.setPreferredSize(new Dimension(100, 180));
        return scp;
    }
}

