/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.designer.gui.property.loop;

import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.common.ui.NormalSelector;
import com.kingdee.bos.ctrl.common.ui.SimpleDialog;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.meta.MetaField;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.Field;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.IR1DataManager;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.loop.TransposeDataModel;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDPanel;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;

class TransposeSetting {
    private KDPanel _panAll;
    private LeftRightSelector _selector;
    private KDCheckBox _chkExceptZero;

    public TransposeSetting(IR1DataManager dm, String ds, TransposeDataModel model) {
        MetaClass mc = (MetaClass)dm.getObject(ds);
        this._selector = new LeftRightSelector(mc, model);
        this._chkExceptZero = new KDCheckBox(MultiLanguageUtil.getMLS("loop.TransposeSetting.cleanZero", ""));
        this._chkExceptZero.setSelected(model.isExceptZero());
        TableLayout tl = TableLayout.splitRow((int)2);
        tl.rowStyle(0).setPriY(1);
        tl.rowStyle(0).setMarginBottom(6);
        tl.rowStyle(1).setHeight(20);
        this._panAll = new KDPanel((LayoutManager)tl);
        this._panAll.add((Component)((Object)this._selector), (Object)tl.cell(0));
        this._panAll.add((Component)this._chkExceptZero, (Object)tl.cell(1));
    }

    public SimpleDialog createDialog(JComponent parentCtrl) {
        SimpleDialog dlg = SimpleDialog.create((Component)parentCtrl);
        dlg.setTitle(MultiLanguageUtil.getMLS("loop.TransposeSetting.dataSourceTran", ""));
        dlg.setComponent((Component)this._panAll);
        return dlg;
    }

    public TransposeDataModel getModifiedModel() {
        TransposeDataModel model = new TransposeDataModel();
        KDList list = this._selector.getSelectedList();
        int count = list.getElementCount();
        if (count > 0) {
            Field[] fields = new Field[count];
            for (int i = 0; i < count; ++i) {
                fields[i] = (Field)list.getElement(i);
            }
            model.setTransposeFields(fields);
        }
        model.setExceptZero(this._chkExceptZero.isSelected());
        return model;
    }

    private static class LeftRightSelector
    extends NormalSelector {
        private KDList supplyCtrl = new KDList();

        public LeftRightSelector(MetaClass mc, TransposeDataModel model) {
            Field[] fields;
            if (mc != null) {
                for (MetaField mf : mc.getFields()) {
                    Field field = Field.fromMetaField(mf);
                    this.supplyCtrl.addElement((Object)field);
                }
            }
            if ((fields = model.getTransposeFields()) != null) {
                for (int i = 0; i < fields.length; ++i) {
                    this.getSelectedList().addElement((Object)fields[i]);
                }
            }
            this.setSupplyCtrl((JComponent)this.supplyCtrl);
            this.setSupplyTitle(MultiLanguageUtil.getMLS("loop.TransposeSetting.allField", ""));
            this.setSelectedTitle(MultiLanguageUtil.getMLS("loop.TransposeSetting.selectField", ""));
            this.enableSelectAll(false);
        }

        protected void onSelect() {
            Object[] selecteds = this.supplyCtrl.getSelectedValues();
            if (selecteds.length == 0) {
                return;
            }
            if (selecteds.length == 1) {
                this.addOneSelected(selecteds[0], true);
            } else {
                for (int i = 0; i < selecteds.length; ++i) {
                    this.addOneSelected(selecteds[i], false);
                }
            }
        }

        private void addOneSelected(Object field, boolean isPrompt) {
            if (this.getSelectedList().getIndexOfElement(field) >= 0) {
                if (isPrompt) {
                    WindowUtil.msgboxWarning((Object)MultiLanguageUtil.getMLS("loop.TransposeSetting.notRepeat", ""), (String)MultiLanguageUtil.getMLS("loop.TransposeSetting.dataSourceTran", ""), (Component)((Object)this));
                }
            } else {
                this.getSelectedList().addElement(field);
            }
        }
    }
}

