/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.designer.gui.wizard.datagrid;

import com.kingdee.bos.ctrl.common.DataType;
import com.kingdee.bos.ctrl.common.ui.ListView;
import com.kingdee.bos.ctrl.common.ui.NormalSelector;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.ui.stepwizard.IWizardStep;
import com.kingdee.bos.ctrl.common.ui.stepwizard.WizardDialog;
import com.kingdee.bos.ctrl.data.meta.MetaField;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.Field;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.gui.wizard.datagrid.AbstractGridCreatorStep;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.gui.wizard.datagrid.GroupObject;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.gui.wizard.datagrid.ListGroupStatRenderer;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.gui.wizard.datagrid.MultiColorField;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.gui.wizard.datagrid.MultiColorRenderer;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.gui.wizard.datagrid.StatObject;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.gui.wizard.datagrid.StatPropertyDialog;
import com.kingdee.bos.ctrl.res.Resource;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;

class StepSelectStat
extends AbstractGridCreatorStep {
    private StatSelector _selector;

    StepSelectStat() {
    }

    private StatSelector getSelector() {
        if (this._selector == null) {
            this._selector = new StatSelector();
        }
        return this._selector;
    }

    @Override
    protected JComponent getRealContent() {
        return this.getSelector();
    }

    @Override
    protected String getPromptText() {
        return MultiLanguageUtil.getMLS("datagrid.StepSelectStat.promptText", "");
    }

    public void intoThisStep(IWizardStep prevStep, boolean isOppose) {
        if (!isOppose) {
            this.prepareSupply();
            this.getSelector().setGroups(this.getModel().getGroups());
        }
    }

    public IWizardStep outThisStep(boolean isOppose) {
        this.getModel().setGroups(this.getResult());
        return null;
    }

    public boolean isReturnable() {
        return true;
    }

    public void initStep(WizardDialog.StepsManager manager) {
    }

    private void prepareSupply() {
        KDList list = this.getSelector().getSupplyCtrl();
        list.setCellRenderer((ListCellRenderer)((Object)new MultiColorRenderer()));
        list.removeAllElements();
        Iterator it = this.getModel().getSelectedDataSource().getFields().iterator();
        int insertIndex = 0;
        while (it.hasNext()) {
            MetaField mf = (MetaField)it.next();
            MultiColorField field = MultiColorField.create(mf);
            if (this.getModel().isFieldSelected(field)) {
                list.insertElement((Object)field, insertIndex++);
                field.setForeground(Color.BLUE);
                continue;
            }
            list.addElement((Object)field);
        }
        this.getSelector().getSupplyCtrl().setSelectedIndex(0);
        this.getSelector().syncButton();
    }

    public void destroy(boolean isFinished) {
    }

    private GroupObject[] getResult() {
        ArrayList<GroupObject> result = new ArrayList<GroupObject>();
        KDList lst = this.getSelector().getSelectedList();
        GroupObject tempGroup = null;
        int c = lst.getElementCount();
        for (int i = 0; i < c; ++i) {
            Object object = lst.getElement(i);
            if (object instanceof GroupObject) {
                GroupObject go = (GroupObject)object;
                go.clearStatObject();
                result.add(go);
                tempGroup = go;
                continue;
            }
            if (!(object instanceof StatObject)) continue;
            tempGroup.addStatObject((StatObject)object);
        }
        return result.toArray(new GroupObject[0]);
    }

    class PropertyAction
    extends AbstractAction {
        public PropertyAction() {
            this.putValue("SmallIcon", Resource.ICON_EDIT);
            this.putValue("ShortDescription", MultiLanguageUtil.getMLS("datagrid.StepSelectStat.attr", ""));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object obj = StepSelectStat.this.getSelector().getSelectedList().getSelectedValue();
            if (obj instanceof StatObject) {
                StatObject stat = (StatObject)obj;
                StatPropertyDialog dlg = (StatPropertyDialog)((Object)WindowUtil.createWindow(StatPropertyDialog.class, (Component)((Object)StepSelectStat.this._selector)));
                dlg.setAtHeader(stat.isAtHeader());
                dlg.setStatType(stat.getStatField().getType());
                if (dlg.showDialog()) {
                    stat.setAtHeader(dlg.isAtHeader());
                    stat.getStatField().setType(dlg.getStatType());
                }
                StepSelectStat.this.getSelector().getSelected().repaint();
            }
        }
    }

    class StatSelector
    extends NormalSelector {
        private KDList lstSupply;
        private final String BUTTON_PROPERTY = "Property";

        public StatSelector() {
            this.init();
        }

        private void init() {
            this.lstSupply = new KDList();
            this.lstSupply.setSelectionMode(0);
            this.setSupplyCtrl((JComponent)this.lstSupply);
            this.setSupplyTitle(MultiLanguageUtil.getMLS("datagrid.StepSelectStat.backField", ""));
            this.setSelectedTitle(MultiLanguageUtil.getMLS("datagrid.StepSelectStat.hasField", ""));
            this.enableSelectAll(true);
            this.enableSelect(true);
            this.getSelectedList().setCellRenderer((ListCellRenderer)new ListGroupStatRenderer());
            this.getSelected().addButton((Action)new PropertyAction(), "Property");
        }

        public KDList getSupplyCtrl() {
            return this.lstSupply;
        }

        public void syncButton() {
            this.syncListViewButton();
        }

        protected void syncListViewButton() {
            this.btnDeleteAll.setEnabled(false);
            Object[] objs = this.getSelectedList().getSelectedValues();
            boolean isContainsGroup = this.containsGroup(objs);
            this.btnDelete.setEnabled(!isContainsGroup);
            KDWorkButton btnUp = this.getSelected().getButton(ListView.BUTTON_MOVE_UP);
            KDWorkButton btnDown = this.getSelected().getButton(ListView.BUTTON_MOVE_DOWN);
            if (objs.length == 0 || isContainsGroup) {
                btnUp.setEnabled(false);
                btnDown.setEnabled(false);
            } else {
                int idx = this.getSelectedList().getSelectedIndex();
                Object objBefore = this.getSelectedList().getElement(idx - 1);
                Object objAfter = null;
                if (idx + 1 < this.getSelectedList().getElementCount()) {
                    objAfter = this.getSelectedList().getElement(idx + 1);
                }
                btnUp.setEnabled(!(objBefore instanceof GroupObject));
                btnDown.setEnabled(objAfter != null && !(objAfter instanceof GroupObject));
            }
            Object selectedObj = this.getSelectedList().getSelectedValue();
            this.getSelected().getButton("Property").setEnabled(objs.length == 1 && selectedObj instanceof StatObject);
        }

        private boolean containsGroup(Object[] objs) {
            int c = objs.length;
            for (int i = 0; i < c; ++i) {
                if (!(objs[i] instanceof GroupObject)) continue;
                return true;
            }
            return false;
        }

        protected void onSelectAll() {
            Object objToSelect = this.getSupplyCtrl().getSelectedValue();
            if (objToSelect != null) {
                for (int i = 0; i < this.getSelectedList().getElementCount(); ++i) {
                    Object obj = this.getSelectedList().getElement(i);
                    if (!(obj instanceof GroupObject)) continue;
                    Field fieldToSelect = (Field)objToSelect;
                    int statType = 5;
                    if (DataType.isNumberType((DataType)fieldToSelect.getDataType())) {
                        statType = 1;
                    }
                    StatObject statObject = StatObject.create(fieldToSelect, statType);
                    this.getSelectedList().insertElement((Object)statObject, i + 1);
                }
            }
        }

        protected void onSelect() {
            Object objToSelect = this.getSupplyCtrl().getSelectedValue();
            if (objToSelect != null) {
                int currectIdx = this.getSelectedList().getSelectedIndex();
                Field fieldToSelect = (Field)objToSelect;
                int statType = 5;
                if (DataType.isNumberType((DataType)fieldToSelect.getDataType())) {
                    statType = 1;
                }
                StatObject statObject = StatObject.create(fieldToSelect, statType);
                this.getSelectedList().insertElement((Object)statObject, currectIdx + 1);
                this.getSelectedList().setSelectedValue((Object)statObject, true);
            }
        }

        private void setGroups(GroupObject[] objs) {
            GroupObject[] oriGroups = StepSelectStat.this.getResult();
            this.getSelectedList().removeAllElements();
            GroupObject newRoot = new GroupObject(null, MultiLanguageUtil.getMLS("datagrid.StepSelectStat.totaliz", ""));
            this.getSelectedList().addElement((Object)newRoot);
            StatObject[] stats = this.getOriStat(oriGroups, newRoot);
            this.listAddStatElement(this.getSelectedList(), stats);
            for (int i = 0; i < objs.length; ++i) {
                GroupObject go = objs[i];
                this.getSelectedList().addElement((Object)go);
                stats = this.getOriStat(oriGroups, go);
                this.listAddStatElement(this.getSelectedList(), stats);
            }
            this.getSelectedList().setSelectedIndex(0);
        }

        private void listAddStatElement(KDList list, StatObject[] stats) {
            if (stats != null) {
                for (int i = 0; i < stats.length; ++i) {
                    list.addElement((Object)stats[i]);
                }
            }
        }

        private StatObject[] getOriStat(GroupObject[] oriGroups, GroupObject newGroup) {
            for (int i = 0; i < oriGroups.length; ++i) {
                GroupObject oriGroup = oriGroups[i];
                if (!oriGroup.getGroup().equals(newGroup)) continue;
                return oriGroup.getStatObjects();
            }
            return null;
        }
    }
}

