/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.designer.model.xmltrans;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.util.render.r1print.DivideModel;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.reportone.r1.common.R1Exception;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.Field;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.IBind;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IReportObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.factory.IAnObjectFactory;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.currency.CurrencyObject;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.currency.CurrencyProperty;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.gui.util.Language;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.model.xmltrans.AbstractR1PrintXmlTrans;
import java.util.Locale;
import org.jdom2.CDATA;
import org.jdom2.Content;
import org.jdom2.Element;

public class CurrencyXmlTrans
extends AbstractR1PrintXmlTrans {
    public CurrencyXmlTrans(IAnObjectFactory factory) {
        super(factory);
    }

    @Override
    protected boolean isMatch(Element node) {
        return "Currency".equalsIgnoreCase(node.getName());
    }

    @Override
    protected IReportObject fromXml(Element node) throws R1Exception {
        CurrencyObject currency = (CurrencyObject)this.getFactory().create();
        this.loadObjectCommon(node, currency);
        CurrencyProperty cp = currency.getCurrencyProperty();
        if (StringUtil.equals((String)"lower", (String)node.getAttributeValue("formatStyle"))) {
            cp.setUpperLower(0);
        } else {
            cp.setUpperLower(1);
            String locale = node.getAttributeValue("readLanguage");
            if (locale != null) {
                cp.setLanguage(Language.getLanguage(new Locale(locale)));
            }
        }
        if (!StringUtil.isEmptyString((String)node.getAttributeValue("divideChar"))) {
            currency.setDivideCharNums(Integer.parseInt(node.getAttributeValue("divideChar")));
        }
        if (!StringUtil.isEmptyString((String)node.getAttributeValue("showDivideLine"))) {
            DivideModel model = new DivideModel();
            model.setShowLine(Boolean.valueOf(node.getAttributeValue("showDivideLine")).booleanValue());
            if (!StringUtil.isEmptyString((String)node.getAttributeValue("divideLineId"))) {
                StyleAttributes ssa = this._styleCache.getStyle(node.getAttributeValue("divideLineId"));
                model.upDataDivideLine(ssa);
            }
            currency.setDivideModel(model);
        }
        cp.setAddPrefix("true".equals(node.getAttributeValue("useSymbol")));
        cp.setNoteType("true".equals(node.getAttributeValue("noteType")));
        Element nodeCode = node.getChild("Code");
        if (!StringUtil.isEmptyString((String)nodeCode.getText())) {
            cp.setCodeConstant(nodeCode.getText());
        } else {
            String ds = nodeCode.getAttributeValue("dataSource");
            cp.getCodeDataSource().setDs(ds);
            String bf = nodeCode.getAttributeValue("bindField");
            if (!StringUtil.isEmptyString((String)bf)) {
                cp.getCodeBindField().setField(Field.valueOf(bf, null));
            }
        }
        return currency;
    }

    @Override
    protected Element loadDataNode(Element nodeRo, IReportObject ro) {
        String text;
        CurrencyObject currency = (CurrencyObject)ro;
        Element nodeData = super.loadDataNode(nodeRo, ro);
        if (nodeData != null && !StringUtil.isEmptyString((String)(text = nodeData.getText()))) {
            currency.setText(text);
        }
        return nodeData;
    }

    @Override
    protected boolean isMatch(IReportObject ro) {
        return ro instanceof CurrencyObject;
    }

    @Override
    protected Element toXml(IReportObject ro) {
        CurrencyObject currency = (CurrencyObject)ro;
        Element node = new Element("Currency");
        this.saveObjectCommon(ro, node);
        CurrencyProperty cp = currency.getCurrencyProperty();
        if (cp.isAddPrefix()) {
            node.setAttribute("useSymbol", "true");
        }
        node.setAttribute("formatStyle", cp.getUpperLower() == 1 ? "upper" : "lower");
        if (cp.getUpperLower() == 1) {
            if (cp.isNoteType()) {
                node.setAttribute("noteType", "true");
            }
            node.setAttribute("readLanguage", cp.getLanguage().getLocale().toString());
        }
        if (currency.getDivideCharNums() > 0) {
            node.setAttribute("divideChar", Integer.toString(currency.getDivideCharNums()));
            if (currency.getDivideModel().isShowLine()) {
                node.setAttribute("showDivideLine", Boolean.toString(currency.getDivideModel().isShowLine()));
                String linesStyleId = this._styleCache.cacheStyle(currency.getDivideModel().getSSA());
                node.setAttribute("divideLineId", linesStyleId);
            }
        }
        Element nodeCode = new Element("Code");
        node.addContent((Content)nodeCode);
        if (cp.isCodeBindDs()) {
            IBind.IBindField bindField;
            IBind.IBindDataSource bindDs = cp.getCodeDataSource();
            if (!StringUtil.isEmptyString((String)bindDs.getDs())) {
                nodeCode.setAttribute("dataSource", bindDs.getDs());
            }
            if ((bindField = cp.getCodeBindField()).getField() != null && !StringUtil.isEmptyString((String)bindField.getField().getName())) {
                nodeCode.setAttribute("bindField", bindField.getField().getName());
            }
        } else {
            nodeCode.setText(cp.getCodeConstant());
        }
        return node;
    }

    @Override
    protected Element saveDataNode(IReportObject ro, Element node) {
        CurrencyObject currency = (CurrencyObject)ro;
        Element nodeData = super.saveDataNode(ro, node);
        String text = currency.getText();
        if (StringUtil.isEmptyString((String)currency.getDataSource().getDs()) && !StringUtil.isEmptyString((String)text)) {
            CDATA cd = new CDATA(text);
            nodeData.addContent((Content)cd);
        }
        return nodeData;
    }
}

