/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.designer.model.xmltrans;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.util.render.r1print.DivideModel;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.reportone.r1.common.R1Exception;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IReportObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.factory.IAnObjectFactory;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.TextObject;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.model.xmltrans.AbstractR1PrintXmlTrans;
import org.jdom2.CDATA;
import org.jdom2.Content;
import org.jdom2.Element;

public class TextXmlTrans
extends AbstractR1PrintXmlTrans {
    public TextXmlTrans(IAnObjectFactory factory) {
        super(factory);
    }

    @Override
    protected boolean isMatch(Element node) {
        return "Text".equalsIgnoreCase(node.getName());
    }

    @Override
    protected IReportObject fromXml(Element node) throws R1Exception {
        TextObject textObj = (TextObject)this.getFactory().create();
        this.loadObjectCommon(node, textObj);
        if (!StringUtil.isEmptyString((String)node.getAttributeValue("divideChar"))) {
            textObj.setDivideCharNums(Integer.parseInt(node.getAttributeValue("divideChar")));
        }
        if (!StringUtil.isEmptyString((String)node.getAttributeValue("showDivideLine"))) {
            DivideModel model = new DivideModel();
            model.setShowLine(Boolean.valueOf(node.getAttributeValue("showDivideLine")).booleanValue());
            if (!StringUtil.isEmptyString((String)node.getAttributeValue("divideLineId"))) {
                StyleAttributes ssa = this._styleCache.getStyle(node.getAttributeValue("divideLineId"));
                model.upDataDivideLine(ssa);
            }
            textObj.setDivideModel(model);
        }
        return textObj;
    }

    @Override
    protected Element loadDataNode(Element nodeRo, IReportObject ro) {
        String text;
        TextObject textObj = (TextObject)ro;
        Element nodeData = super.loadDataNode(nodeRo, ro);
        if (nodeData != null && !StringUtil.isEmptyString((String)(text = nodeData.getText()))) {
            textObj.setText(text);
        }
        return nodeData;
    }

    @Override
    protected boolean isMatch(IReportObject ro) {
        return ro instanceof TextObject;
    }

    @Override
    protected Element toXml(IReportObject ro) {
        TextObject textObj = (TextObject)ro;
        Element node = new Element("Text");
        this.saveObjectCommon(ro, node);
        if (textObj.getDivideCharNums() > 0) {
            node.setAttribute("divideChar", Integer.toString(textObj.getDivideCharNums()));
            if (textObj.getDivideModel().isShowLine()) {
                node.setAttribute("showDivideLine", Boolean.toString(textObj.getDivideModel().isShowLine()));
                String linesStyleId = this._styleCache.cacheStyle(textObj.getDivideModel().getSSA());
                node.setAttribute("divideLineId", linesStyleId);
            }
        }
        return node;
    }

    @Override
    protected Element saveDataNode(IReportObject ro, Element node) {
        TextObject textObj = (TextObject)ro;
        Element nodeData = super.saveDataNode(ro, node);
        String text = textObj.getText();
        if (StringUtil.isEmptyString((String)textObj.getDataSource().getDs()) && !StringUtil.isEmptyString((String)text)) {
            CDATA cd = new CDATA(text);
            nodeData.addContent((Content)cd);
        }
        return nodeData;
    }
}

