/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.designer.model.xmltrans.grid;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.util.render.r1print.DivideModel;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.reportone.r1.common.R1Exception;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IReportObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.factory.IAnObjectFactory;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractColumn;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractGrid;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractRow;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.layoutgrid.LayoutGrid;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.layoutgrid.LayoutGridCell;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.model.xmltrans.AbstractR1PrintXmlTrans;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.model.xmltrans.grid.GridXmlTransUtil;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;

public class PrintLayoutGridXmlTrans
extends AbstractR1PrintXmlTrans {
    public PrintLayoutGridXmlTrans(IAnObjectFactory factory) {
        super(factory);
    }

    @Override
    protected boolean isMatch(Element node) {
        return StringUtil.equals((String)"PrintLayoutGrid", (String)node.getName());
    }

    @Override
    protected IReportObject fromXml(Element node) throws R1Exception {
        LayoutGrid grid = new LayoutGrid();
        this.loadObjectCommon(node, grid);
        List listCol = node.getChildren("Col");
        for (Element nodeCol : listCol) {
            this.loadColumn(nodeCol, grid);
        }
        List listRow = node.getChildren("TR");
        for (Element nodeRow : listRow) {
            this.loadRow(nodeRow, grid, node);
        }
        GridXmlTransUtil.MergeBlocksLoader.loadMergeBlock(node, grid);
        return grid;
    }

    @Override
    protected void loadObjectLocation(Element nodeRo, IReportObject ro) {
        ro.setXLom(Integer.parseInt(nodeRo.getAttributeValue("x")));
        ro.setYLom(Integer.parseInt(nodeRo.getAttributeValue("y")));
    }

    private void loadColumn(Element nodeCol, AbstractGrid grid) {
        AbstractColumn column = grid.addColumn();
        this.loadElementCommon(nodeCol, column);
        column.setWidthLom(PrintLayoutGridXmlTrans.getIntAttr(nodeCol, "width"));
    }

    private void loadRow(Element nodeRow, LayoutGrid grid, Element nodeGrid) throws R1Exception {
        AbstractRow row = grid.addRow(1);
        this.loadElementCommon(nodeRow, row);
        row.setHeightLom(PrintLayoutGridXmlTrans.getIntAttr(nodeRow, "height"));
        if (StringUtil.equals((String)"true", (String)nodeRow.getAttributeValue("autoAdjustHeight"))) {
            row.setFixedHeight(false);
        }
        List listCell = nodeRow.getChildren("TD");
        int c = listCell.size();
        for (int i = 0; i < c; ++i) {
            Element nodeCell = (Element)listCell.get(i);
            LayoutGridCell cell = (LayoutGridCell)row.getCell(i);
            this.loadCell(nodeCell, grid, cell);
        }
    }

    private void loadCell(Element nodeCell, LayoutGrid grid, LayoutGridCell cell) throws R1Exception {
        this.loadElementCommon(nodeCell, cell);
        GridXmlTransUtil.loadCellValue(nodeCell, cell);
        if (!StringUtil.isEmptyString((String)nodeCell.getAttributeValue("divideChar"))) {
            cell.setDivideCharNums(Integer.parseInt(nodeCell.getAttributeValue("divideChar")));
        }
        if (!StringUtil.isEmptyString((String)nodeCell.getAttributeValue("showDivideLine"))) {
            DivideModel model = new DivideModel();
            model.setShowLine(Boolean.valueOf(nodeCell.getAttributeValue("showDivideLine")).booleanValue());
            if (!StringUtil.isEmptyString((String)nodeCell.getAttributeValue("divideLineId"))) {
                StyleAttributes ssa = this._styleCache.getStyle(nodeCell.getAttributeValue("divideLineId"));
                model.upDataDivideLine(ssa);
            }
            cell.setDivideModel(model);
        }
        this._r1Reader.loadContainer(this._r1Reader, nodeCell, grid, cell);
    }

    @Override
    protected boolean isMatch(IReportObject ro) {
        return ro instanceof LayoutGrid;
    }

    @Override
    protected Element toXml(IReportObject ro) {
        Element nodeGrid = new Element("PrintLayoutGrid");
        this.saveObjectCommon(ro, nodeGrid);
        LayoutGrid grid = (LayoutGrid)ro;
        int c = grid.getColumnsCount();
        for (int j = 0; j < c; ++j) {
            nodeGrid.addContent((Content)this.saveColumn(grid.getColumn(j)));
        }
        GridXmlTransUtil.MergeBlocksSaver mergeBlocksSaver = new GridXmlTransUtil.MergeBlocksSaver();
        int c2 = grid.getRowsCount();
        for (int i = 0; i < c2; ++i) {
            nodeGrid.addContent((Content)this.saveRow(grid.getRow(i), grid, mergeBlocksSaver, nodeGrid));
        }
        mergeBlocksSaver.saveMergeBlocks(nodeGrid);
        return nodeGrid;
    }

    @Override
    protected void saveObjectLocation(IReportObject ro, Element node) {
        PrintLayoutGridXmlTrans.setIntAttr(node, "x", ro.getXLom());
        PrintLayoutGridXmlTrans.setIntAttr(node, "y", ro.getYLom());
    }

    private Element saveColumn(AbstractColumn column) {
        Element nodeColumn = new Element("Col");
        PrintLayoutGridXmlTrans.setIntAttr(nodeColumn, "width", column.getWidthLom());
        this.saveElementCommon(column, nodeColumn);
        return nodeColumn;
    }

    private Element saveRow(AbstractRow row, LayoutGrid grid, GridXmlTransUtil.MergeBlocksSaver mergeBlocksSaver, Element nodeGrid) {
        Element nodeRow = new Element("TR");
        PrintLayoutGridXmlTrans.setIntAttr(nodeRow, "height", row.getHeightLom());
        this.saveElementCommon(row, nodeRow);
        if (!row.isFixedHeight()) {
            nodeRow.setAttribute("autoAdjustHeight", "true");
        }
        int c = row.getCellCount();
        for (int i = 0; i < c; ++i) {
            LayoutGridCell cell = (LayoutGridCell)row.getCell(i);
            nodeRow.addContent((Content)this.saveCell(cell, grid));
            mergeBlocksSaver.storeMergeBlock(grid, cell);
        }
        return nodeRow;
    }

    private Element saveCell(LayoutGridCell cell, LayoutGrid grid) {
        Element nodeCell = new Element("TD");
        this.saveElementCommon(cell, nodeCell);
        GridXmlTransUtil.saveCellValue(cell, nodeCell);
        if (cell.getDivideCharNums() > 0) {
            nodeCell.setAttribute("divideChar", Integer.toString(cell.getDivideCharNums()));
            if (cell.getDivideModel().isShowLine()) {
                nodeCell.setAttribute("showDivideLine", Boolean.toString(cell.getDivideModel().isShowLine()));
                String linesStyleId = this._styleCache.cacheStyle(cell.getDivideModel().getSSA());
                nodeCell.setAttribute("divideLineId", linesStyleId);
            }
        }
        if (cell.getChildrenCount() > 0) {
            this._r1Writer.saveContainer(this._r1Writer, cell, nodeCell);
        }
        return nodeCell;
    }
}

