/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.designer.renderer;

import com.kingdee.bos.ctrl.kdf.util.style.LineStyle;
import com.kingdee.bos.ctrl.kdf.util.style.PenStyle;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.AbstractTextObject;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;

class RendererUtil {
    static String ErrorResult = MultiLanguageUtil.getMLS("renderer.RendererUtil.unBindField", "");

    RendererUtil() {
    }

    static String getDrawingText(AbstractTextObject obj) {
        if (obj.isBindData()) {
            if (obj.getBindField().getField() != null) {
                return obj.getBindField().getField().toDrawString();
            }
            return ErrorResult;
        }
        return obj.getText();
    }

    static void drawDashBorder(Graphics g, Rectangle rect) {
        int offsetY;
        int offsetX;
        Color oldColor = g.getColor();
        g.setColor(Color.GRAY);
        if (rect.width < rect.height) {
            offsetX = 4;
            offsetY = 6;
        } else {
            offsetX = 6;
            offsetY = 4;
        }
        int x1 = rect.x;
        int y1 = rect.y;
        int x2 = rect.x + rect.width - 1;
        int y2 = rect.y + rect.height - 1;
        g.drawLine(x1, y1, x1 + offsetX, y1);
        g.drawLine(x1, y1, x1, y1 + offsetY);
        g.drawLine(x2, y1, x2 - offsetX, y1);
        g.drawLine(x2, y1, x2, y1 + offsetY);
        g.drawLine(x1, y2, x1, y2 - offsetY);
        g.drawLine(x1, y2, x1 + offsetX, y2);
        g.drawLine(x2, y2, x2 - offsetX, y2);
        g.drawLine(x2, y2, x2, y2 - offsetY);
        int x3 = x1 + (rect.width - offsetX - 1) / 2;
        int y3 = y1 + (rect.height - offsetY - 1) / 2;
        g.drawLine(x3, y1, x3 + offsetX, y1);
        g.drawLine(x3, y2, x3 + offsetX, y2);
        g.drawLine(x1, y3, x1, y3 + offsetY);
        g.drawLine(x2, y3, x2, y3 + offsetY);
        g.setColor(oldColor);
    }

    static void initBorder(StyleAttributes sa, Styles.Position pos, LineStyle lineStyle, PenStyle penStyle, Color color) {
        sa.setBorderLineStyle(pos, lineStyle);
        sa.setBorderPenStyle(pos, penStyle);
        sa.setBorderColor(pos, color);
    }

    static void initBorder(StyleAttributes sa, LineStyle lineStyle, PenStyle penStyle, Color color) {
        RendererUtil.initBorder(sa, Styles.Position.LEFT, lineStyle, penStyle, color);
        RendererUtil.initBorder(sa, Styles.Position.RIGHT, lineStyle, penStyle, color);
        RendererUtil.initBorder(sa, Styles.Position.TOP, lineStyle, penStyle, color);
        RendererUtil.initBorder(sa, Styles.Position.BOTTOM, lineStyle, penStyle, color);
    }
}

