/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.reportimpl.cubemodel;

import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModelUtil;
import com.kingdee.bos.ctrl.common.FullPath;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import com.kingdee.bos.ctrl.data.modal.Parameter;
import com.kingdee.bos.ctrl.kdf.expr.Parser;
import com.kingdee.bos.ctrl.kdf.expr.ParserHelperListener;
import com.kingdee.bos.ctrl.kdf.expr.Variant;
import com.kingdee.bos.ctrl.reportone.data.engine.KsqlTextVariantsSolver;
import com.kingdee.bos.ctrl.reportone.data.framework.bos.BosUtil;
import com.kingdee.bos.ctrl.reportone.data.invoke.AbstractLocalDataExecutor;
import com.kingdee.bos.ctrl.reportone.data.invoke.FormulaParserHelperListener;
import com.kingdee.bos.ctrl.reportone.data.invoke.IDataExecutor;
import com.kingdee.bos.ctrl.reportone.data.modal.Import;
import com.kingdee.bos.ctrl.reportone.data.modal.ParamUtil;
import com.kingdee.bos.ctrl.reportone.reportframework.ReportException;
import com.kingdee.bos.ctrl.reportone.reportimpl.cubemodel.KdrsCubeModel;
import com.kingdee.bos.olap.Connection;
import com.kingdee.bos.olap.Driver;
import com.kingdee.bos.olap.Rules;
import com.kingdee.bos.olap.dbsource.SqlWithParamTableDef;
import com.kingdee.bos.olap.def.ParameterDef;
import com.kingdee.bos.olap.def.SchemaDef;
import com.kingdee.bos.olap.util.SqlWithParam;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jdom2.Element;

public class CubeModelExecutor
extends AbstractLocalDataExecutor {
    public static final Logger log = LogUtil.getPackageLogger(CubeModelExecutor.class);

    @Override
    public Object execute(String category, Object object, HashMap args, IDataExecutor env) throws Exception {
        if ("kdrs-cubemodel".equals(category) || object instanceof CubeModel) {
            try {
                if (object instanceof byte[]) {
                    KdrsCubeModel model = new KdrsCubeModel();
                    Element e = XmlUtil.loadXmlBytes((byte[])((byte[])object));
                    if (log.isDebugEnabled()) {
                        XmlUtil.printElement((Element)e);
                    }
                    model.loadXML(e);
                    return this.execute(category, (Object)model, args, env);
                }
                if (object instanceof KdrsCubeModel) {
                    return this.executeCube((KdrsCubeModel)((Object)object), args, env);
                }
                throw new UnsupportedOperationException("TODO");
            }
            catch (Exception ex) {
                throw ReportException.makeException(null, ex);
            }
        }
        if (env != null) {
            return env.execute(category, object, args, env);
        }
        throw new ReportException("Unsupport [" + category + "], object," + object);
    }

    Connection executeCube(KdrsCubeModel cubeModel, HashMap nsArgs, IDataExecutor env) throws Exception {
        Parser parser = new Parser(null, null);
        parser.addParserHelperListener((ParserHelperListener)new FormulaParserHelperListener(nsArgs, this.getEnvProvider(), null));
        if (log.isDebugEnabled()) {
            log.debug((Object)":| Convert CubeModel ... [1/3]");
        }
        SchemaDef schemaDef = CubeModelUtil.convertSchema((CubeModel)cubeModel);
        ParameterDef[] pds = schemaDef.parameters;
        if (log.isDebugEnabled()) {
            log.debug((Object)":| Prepare imports data ... [2/3]");
        }
        nsArgs.put("executeMode", "SQL");
        HashMap<String, Object> olapArgs = new HashMap<String, Object>();
        olapArgs.put("JdbcConnection", BosUtil.getDBConnection());
        for (int i = 0; i < pds.length; ++i) {
            String pdt = pds[i].type;
            String importName = pds[i].name;
            if ("Table".equals(pdt)) {
                Import importObject = cubeModel.getImports().get(importName);
                if (importObject == null) {
                    throw new UnsupportedOperationException("Couldn't find object:" + importName);
                }
                HashMap initArgs = (HashMap)nsArgs.clone();
                Object importVal = this.executeImport(importObject, initArgs, nsArgs, parser, env);
                if (importVal instanceof String) {
                    SqlWithParam swp = new SqlWithParam();
                    swp.setSql((String)importVal);
                    importVal = new SqlWithParamTableDef(importName, swp);
                }
                olapArgs.put(importName, importVal);
                continue;
            }
            if (!"ParentMemberRule".equals(pdt)) continue;
            olapArgs.put(importName, Rules.getParentMemberRule((String)importName));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)":| Build cube ... [3/3]");
        }
        Connection con = Driver.openConnection((SchemaDef)schemaDef, olapArgs);
        if (log.isDebugEnabled()) {
            log.debug((Object)":) Build cube OK.");
        }
        return con;
    }

    Object executeImport(Import importObj, HashMap initArgs, HashMap cubeArgs, Parser parser, IDataExecutor env) throws Exception {
        Map rawArgs = importObj.getArgs();
        if (rawArgs != null) {
            Iterator keys = rawArgs.keySet().iterator();
            Iterator vals = rawArgs.values().iterator();
            while (keys.hasNext()) {
                Parameter p = (Parameter)keys.next();
                Object val = vals.next();
                if (val == null) continue;
                if (val instanceof Parameter) {
                    initArgs.put(p.getName(), cubeArgs.get(((Parameter)val).getName()));
                    continue;
                }
                if (val instanceof String) {
                    String strVal = (String)val;
                    if (ParamUtil.isDataViewParam(p)) {
                        if (strVal.length() > 1) {
                            strVal = strVal.substring(1, strVal.length() - 1);
                        }
                        String dataView = KsqlTextVariantsSolver.solve(strVal, cubeArgs, true);
                        initArgs.put(p.getName(), dataView);
                        continue;
                    }
                    strVal = StringUtil.replace((String)strVal, (String)"\"", (String)"\\\"", (boolean)false, (boolean)true);
                    parser.prepare(null, strVal);
                    Variant var = parser.parse();
                    if (var.getVt() != 16) {
                        initArgs.put(p.getName(), var.getValue());
                        continue;
                    }
                    throw new Exception("Expresssion error. expr=" + strVal);
                }
                throw new UnsupportedOperationException("val=" + val + ",val.class" + val.getClass());
            }
        }
        return env.execute(null, FullPath.parse((String)importObj.getExpr()), initArgs, env);
    }
}

