/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.reportimpl.r1print;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import com.kingdee.bos.ctrl.print.KDPrinter;
import com.kingdee.bos.ctrl.reportone.data.modal.ParamUtil;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core.ToolboxLoader;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.ReportModel;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.io.DataXmlTrans;
import com.kingdee.bos.ctrl.reportone.r1.print.browser.R1PrintBrowser;
import com.kingdee.bos.ctrl.reportone.r1.print.config.R1PrintConfigReader;
import com.kingdee.bos.ctrl.reportone.r1.print.data.AbstractPrintDataProvider;
import com.kingdee.bos.ctrl.reportone.r1.print.data.IPrintVariantListener;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.model.io.R1PrintXmlReader;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.RuntimeModel;
import com.kingdee.bos.ctrl.reportone.reportframework.IContext;
import com.kingdee.bos.ctrl.reportone.reportframework.ReportException;
import com.kingdee.bos.ctrl.reportone.reportframework.browse.AReportBrowser;
import com.kingdee.bos.ctrl.reportone.reportimpl.ImplResource;
import com.kingdee.bos.ctrl.reportone.reportimpl.r1print.R1PrintRptExecutor;
import java.awt.Component;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.jdom2.Element;

public class R1PrintRptBrowser
extends AReportBrowser {
    private static final Logger log = LogUtil.getPackageLogger(R1PrintRptBrowser.class);
    public static final String ARG_DataProvider = ParamUtil.makeArgName("ARG_DataProvider", R1PrintRptBrowser.class);

    public R1PrintRptBrowser(Component owner) {
        super(owner);
    }

    @Override
    public void browse(HashMap args) throws ReportException {
        ByteArrayInputStream tpl;
        log.debug((Object)"Load R1Print template ...");
        try {
            tpl = new ByteArrayInputStream(((R1PrintRptExecutor)this.getReportExecutor()).readTemplate());
        }
        catch (ReportException ex) {
            throw ReportException.makeException(ex);
        }
        log.debug((Object)"Create R1Print model ...");
        ReportModel mo = R1PrintRptBrowser.loadModel(tpl);
        RuntimeModel runtimeModel = new RuntimeModel(mo);
        log.debug((Object)"Get data provider ...");
        AbstractPrintDataProvider dataProvider = (AbstractPrintDataProvider)args.remove(ARG_DataProvider);
        runtimeModel.hookDataProvider(dataProvider);
        log.debug((Object)"Wrap variant listener ...");
        IContext pubEnv = this.getReportEnv().getContext();
        VarListener varListener = new VarListener(pubEnv);
        log.debug((Object)"Executing and Browsing ...");
        R1PrintBrowser browser = new R1PrintBrowser();
        browser.setPrinterCtrl(new KDPrinter());
        browser.setVariantListener(varListener);
        browser.print(runtimeModel, true, true, this.owner, ImplResource.getString("res_51"));
    }

    @Override
    public void print() throws ReportException {
    }

    @Override
    public void printPreview() throws ReportException {
    }

    static ReportModel loadModel(InputStream in) throws ReportException {
        InputStream input = null;
        try {
            ReportModel rm;
            Element xml = XmlUtil.loadXmlStream((InputStream)in);
            R1PrintXmlReader rd = new R1PrintXmlReader();
            input = R1PrintConfigReader.getNodes();
            ArrayList xmlTransChain = ToolboxLoader.createXmlTransChain(input);
            rd.setXmlTransChain(xmlTransChain);
            ReportModel reportModel = rm = rd.fromXml(xml, new DataXmlTrans());
            return reportModel;
        }
        catch (Exception ex) {
            throw ReportException.makeException(ex);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    static class VarListener
    implements IPrintVariantListener {
        private IContext context;

        public VarListener(IContext ctx) {
            this.context = ctx;
        }

        @Override
        public String requestVar(String type, String varName) {
            Object var;
            if (this.context != null && (var = this.context.getValue(varName)) != null) {
                return var.toString();
            }
            return "";
        }
    }
}

