/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing;

import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.swing.DecimalFormatEx;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDComponentDialog;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDOptionPane;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDSplitPane;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDTimePicker;
import com.kingdee.bos.ctrl.swing.KDToggleButton;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.event.TreePopupMenuEvent;
import com.kingdee.bos.ctrl.swing.event.TreePopupMenuListener;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.DateFormatter;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class KDDebugPane
extends KDDialog {
    private static final Logger logger = CommonLogger.getLogger(KDDebugPane.class);
    private Window targetWindow;
    private Component glassPane;
    private MyGlassPane myGlassPane;
    private KDDebugPane selfPane = this;
    private KDTextArea infoArea;
    private KDTextArea resultArea;
    private KDToggleButton oneTouch;
    private ComponentsTree compTree;
    private Hashtable componentsTable;
    private Component selectedComp;
    private SearchDialog findDialog;
    private KDTextField expField;
    private KDPanel kdPnl;
    private KDDatePicker datepicker;
    private KDTimePicker timepicker;
    private KDFormattedTextField formattedTextfield;
    private JFormattedTextField dateFormatText;
    private JFormattedTextField numberFormatText;
    private JTextField dateTimePatternLabel;
    private JTextField numberPatternLabel;
    private Locale currentLocale = Locale.getDefault();
    private TimeZone currentTimezone = TimeZone.getDefault();
    private SimpleDateFormat currentDateTimeFormat = null;
    private DecimalFormatEx currentNumberEditFormat = null;
    private DecimalFormatEx currentNumberDisplayFormat = null;
    private DateFormatSymbols currentDateFormatSymbols = null;
    private DecimalFormatSymbols currentDecimalFormatSymbols = null;

    public static void register(Window target, KeyStroke keyStroke) {
        if (target == null || keyStroke == null || target instanceof KDDebugPane) {
            return;
        }
        JRootPane rootPane = null;
        if (target instanceof JFrame) {
            rootPane = ((JFrame)target).getRootPane();
        } else if (target instanceof JDialog) {
            rootPane = ((JDialog)target).getRootPane();
        } else {
            return;
        }
        InputMap inputMap = rootPane.getInputMap(2);
        ActionMap actionMap = rootPane.getActionMap();
        Object tmpObj = inputMap.get(keyStroke);
        if (tmpObj != null && !"showDebugPane".equals(tmpObj.toString())) {
            System.err.println("KDDebugPane Operation Abort: KeyStroke \"" + keyStroke + "\" has been used, try another one!");
            return;
        }
        tmpObj = actionMap.get("showDebugPane");
        if (tmpObj != null) {
            if (tmpObj instanceof DebugAction) {
                inputMap.put(keyStroke, "showDebugPane");
                actionMap.put("showDebugPane", (DebugAction)tmpObj);
                return;
            }
            System.err.println("KDDebugPane Operation Abort: This method tries to put an Action into the ActionMap of the rootPane in the target Window, with key \"showDebugPane\" which is already in use");
            return;
        }
        inputMap.put(keyStroke, "showDebugPane");
        actionMap.put("showDebugPane", new DebugAction(target));
    }

    public static void unRegister(Window target) {
        if (target == null) {
            return;
        }
        JRootPane rootPane = null;
        if (target instanceof JFrame) {
            rootPane = ((JFrame)target).getRootPane();
        } else if (target instanceof JDialog) {
            rootPane = ((JDialog)target).getRootPane();
        } else {
            return;
        }
        ActionMap actionMap = rootPane.getActionMap();
        actionMap.remove("showDebugPane");
    }

    public static KeyStroke getRegisteredKeyStroke(Window target) {
        JRootPane rootPane = null;
        if (target != null) {
            if (target instanceof JFrame) {
                rootPane = ((JFrame)target).getRootPane();
            } else if (target instanceof JDialog) {
                rootPane = ((JDialog)target).getRootPane();
            } else {
                return null;
            }
            ActionMap actionMap = rootPane.getActionMap();
            Action tmpObj = actionMap.get("showDebugPane");
            if (tmpObj != null && tmpObj instanceof DebugAction) {
                if (!((DebugAction)tmpObj).target(target)) {
                    return null;
                }
                InputMap inputMap = rootPane.getInputMap(2);
                KeyStroke[] keyStrokes = inputMap.keys();
                for (int i = 0; i < keyStrokes.length; ++i) {
                    Object value = inputMap.get(keyStrokes[i]);
                    if (!"showDebugPane".equals(value)) continue;
                    return keyStrokes[i];
                }
            }
        }
        return null;
    }

    public static boolean isRegistered(Window target) {
        return KDDebugPane.getRegisteredKeyStroke(target) != null;
    }

    KDDebugPane(JFrame target) {
        super(target);
        this.targetWindow = target;
        this.glassPane = target.getGlassPane();
        this.myGlassPane = new MyGlassPane(target.getLayeredPane());
        this.init();
    }

    KDDebugPane(JDialog target) {
        super(target);
        if (target.isModal()) {
            this.setModal(true);
        }
        this.targetWindow = target;
        this.glassPane = target.getGlassPane();
        this.myGlassPane = new MyGlassPane(target.getLayeredPane());
        this.init();
    }

    private void init() {
        this.setTitle("Kingdee Debug Panel");
        this.setDefaultCloseOperation(1);
        KDPanel debugPane = new KDPanel(new BorderLayout());
        KDSplitPane contentPanel = this.createContentPanel();
        KDPanel scriptPanel = this.createScriptPanel();
        debugPane.add((Component)scriptPanel, "South");
        debugPane.add((Component)contentPanel, "Center");
        KDPanel i18nPane = this.createI18nPane();
        this.addComponentToPane(this.getContentPane(), debugPane, i18nPane);
        this.setSize(800, 600);
        InputMap inputmap = this.getRootPane().getInputMap(1);
        inputmap.put(KeyStroke.getKeyStroke(70, 128), "findNext");
        ActionMap actionmap = this.getRootPane().getActionMap();
        actionmap.put("findNext", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KDDebugPane.this.showFindNextDialog();
            }
        });
    }

    private void addComponentToPane(Container pane, JPanel debugPane, JPanel i18nPane) {
        final KDPanel cards = new KDPanel(new CardLayout());
        cards.add((Component)debugPane, "Debug Pane");
        cards.add((Component)i18nPane, "I18n Pane");
        KDPanel comboBoxPane = new KDPanel(new BorderLayout());
        Object[] comboBoxItems = new String[]{"Debug Pane", "I18n Pane"};
        KDComboBox cb = new KDComboBox(comboBoxItems);
        cb.setEditable(false);
        cb.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                CardLayout cl = (CardLayout)cards.getLayout();
                cl.show(cards, (String)evt.getItem());
            }
        });
        comboBoxPane.add((Component)cb, "East");
        comboBoxPane.add((Component)new KDLabel("\u8bf7\u9009\u62e9\u4e0b\u62c9\u6846\u5207\u6362\u9762\u677f-->"), "West");
        pane.add((Component)comboBoxPane, "First");
        pane.add((Component)cards, "Center");
    }

    private KDPanel createI18nPane() {
        KDPanel pnl = new KDPanel(new BorderLayout());
        KDSplitPane controlsPnl = new KDSplitPane(0);
        JPanel jPnl = new JPanel(new FlowLayout(3));
        jPnl.setBorder(new TitledBorder("Standard Swing Components"));
        this.dateFormatText = new JFormattedTextField();
        this.dateFormatText.setColumns(15);
        this.dateFormatText.setValue(new Date());
        this.dateTimePatternLabel = new JTextField("Date&Time Pattern: ");
        this.dateTimePatternLabel.setEditable(false);
        this.numberFormatText = new JFormattedTextField();
        this.numberFormatText.setColumns(10);
        this.numberFormatText.setValue(new BigDecimal(1234.56));
        this.numberPatternLabel = new JTextField("Number Pattern: ");
        this.numberPatternLabel.setEditable(false);
        jPnl.add(new KDLabelContainer("Date&Time: ", this.dateFormatText));
        jPnl.add(new KDLabelContainer("Number: ", this.numberFormatText));
        jPnl.add(this.dateTimePatternLabel);
        jPnl.add(this.numberPatternLabel);
        this.kdPnl = new KDPanel(new FlowLayout(3));
        this.kdPnl.setBorder(new TitledBorder("Kingdee Swing Components"));
        this.createKDComponents();
        this.kdPnl.add(this.datepicker);
        this.kdPnl.add(this.timepicker);
        this.kdPnl.add(this.formattedTextfield);
        controlsPnl.setLeftComponent(jPnl);
        controlsPnl.setRightComponent(this.kdPnl);
        controlsPnl.setDividerLocation(150);
        controlsPnl.setOneTouchExpandable(true);
        controlsPnl.setContinuousLayout(true);
        JPanel wPnl = new JPanel();
        wPnl.setLayout(new BoxLayout(wPnl, 1));
        Locale[] locales = Locale.getAvailableLocales();
        int lanCount = locales.length;
        JRadioButton[] localeRadios = new JRadioButton[lanCount];
        ButtonGroup nGroup = new ButtonGroup();
        for (int i = 0; i < lanCount; ++i) {
            localeRadios[i] = new JRadioButton(new LocaleAction(locales[i]));
            wPnl.add(localeRadios[i]);
            nGroup.add(localeRadios[i]);
        }
        JPanel ePnl = new JPanel();
        ePnl.setLayout(new BoxLayout(ePnl, 1));
        String[] timezones = TimeZone.getAvailableIDs();
        int timezoneCount = timezones.length;
        JRadioButton[] timezoneRadios = new JRadioButton[timezoneCount];
        ButtonGroup mGroup = new ButtonGroup();
        for (int i = 0; i < timezoneCount; ++i) {
            TimeZone timezone = null;
            try {
                timezone = TimeZone.getTimeZone(timezones[i]);
            }
            catch (Throwable e) {
                e.printStackTrace();
                timezone = TimeZone.getDefault();
            }
            timezoneRadios[i] = new JRadioButton(new TimeZoneAction(timezone));
            ePnl.add(timezoneRadios[i]);
            mGroup.add(timezoneRadios[i]);
        }
        pnl.add((Component)new KDScrollPane(wPnl), "West");
        pnl.add((Component)new JScrollPane(ePnl), "East");
        pnl.add((Component)controlsPnl, "Center");
        return pnl;
    }

    private void createKDComponents() {
        this.datepicker = new KDDatePicker();
        this.datepicker.setTimeEnabled(true);
        this.timepicker = new KDTimePicker();
        this.formattedTextfield = new KDFormattedTextField(1);
        this.formattedTextfield.setValue(new BigDecimal(1234.56));
        this.formattedTextfield.setPrecision(3);
    }

    private KDSplitPane createContentPanel() {
        this.infoArea = new KDTextArea("\u8bf7\u70b9\u9009\u5de6\u4fa7\u63a7\u4ef6\u6811\u8282\u70b9\u67e5\u770b\u76f8\u5e94\u63a7\u4ef6\u7684\u4fe1\u606f");
        this.infoArea.setEditable(false);
        this.infoArea.setSelectAllOnFocus(false);
        this.compTree = new ComponentsTree();
        KDSplitPane cp = new KDSplitPane();
        cp.setDividerLocation(255);
        KDScrollPane treePane = new KDScrollPane(this.compTree);
        KDScrollPane contentPane = new KDScrollPane(this.infoArea);
        contentPane.setFocusable(false);
        cp.setBorder(new TitledBorder("\u76ee\u6807\u7a97\u4f53\u63a7\u4ef6\u4fe1\u606f"));
        cp.setLeftComponent(treePane);
        cp.setRightComponent(contentPane);
        return cp;
    }

    private KDPanel createScriptPanel() {
        KDPanel sp = new KDPanel();
        sp.setLayout(new BorderLayout());
        this.resultArea = new KDTextArea("\u5728\u4e0b\u9762\u6587\u672c\u6846\u5185\u8f93\u5165\u201cgetText()\u201d\u4e4b\u7c7b\u7684\u8868\u8fbe\u5f0f\uff0c\u8ba1\u7b97\u7ed3\u679c\u5c06\u663e\u793a\u5728\u8fd9\u91cc\u2026\u2026");
        this.resultArea.setRows(4);
        this.resultArea.setEditable(false);
        this.resultArea.setSelectAllOnFocus(false);
        KDPanel inputPanel = new KDPanel();
        inputPanel.setName("inputPanel");
        inputPanel.setLayout(new BorderLayout());
        inputPanel.setBackground(Color.decode("#5C85B3"));
        this.expField = new KDTextField();
        this.expField.setColumns(20);
        CtrlSwingUtilities.removeManagingFocusForwardTraversalKeys(this.expField, KeyStroke.getKeyStroke(10, 0));
        KDButton eval = new KDButton("\u6267\u884c");
        eval.setFocusable(false);
        ActionListener l = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String expression = KDDebugPane.this.expField.getText();
                        KDDebugPane.this.expEval(expression);
                    }
                });
            }
        };
        eval.addActionListener(l);
        this.expField.addActionListener(l);
        KDLabel runScript = new KDLabel("\u8bf7\u8f93\u5165\u5bf9\u9009\u4e2d\u6811\u8282\u70b9\u53ef\u7528\u7684\u65b9\u6cd5\u8c03\u7528:");
        runScript.setForeground(Color.white);
        runScript.setToolTipText("\u672a\u9009\u4e2d\u6811\u8282\u70b9\u65f6\uff0c\u53ef\u8fdb\u884c\u7c7b\u7684\u9759\u6001\u65b9\u6cd5\u8c03\u7528\uff0c\u9700\u5199\u51fa\u7c7b\u7684\u5168\u540d");
        this.oneTouch = new KDToggleButton(" \u25e4 ");
        this.oneTouch.setFactType(0);
        this.oneTouch.setOpaque(false);
        this.oneTouch.setFocusable(false);
        this.oneTouch.setToolTipText("\u6309\u4e0b\u5219\u53ef\u5728\u76ee\u6807\u7a97\u4f53\u70b9\u9009\u63a7\u4ef6");
        this.oneTouch.addItemListener(this.myGlassPane);
        if (this.isModal()) {
            this.oneTouch.setEnabled(false);
            this.oneTouch.setToolTipText(this.oneTouch.getToolTipText() + " [\u6a21\u6001\u65f6\u4e0d\u53ef\u7528]");
        }
        KDWorkButton refresh = new KDWorkButton("\u5237\u65b0");
        refresh.setToolTipText("\u5237\u65b0\u63a7\u4ef6\u6811\u4ee5\u540c\u6b65\u76ee\u6807\u7a97\u4f53");
        refresh.setFactType(0);
        refresh.setFocusable(false);
        refresh.setOpaque(false);
        refresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KDDebugPane.this.refresh();
            }
        });
        KDPanel innerPanel1 = new KDPanel();
        innerPanel1.setLayout(new BorderLayout());
        innerPanel1.setOpaque(false);
        innerPanel1.add((Component)this.oneTouch, "West");
        innerPanel1.add((Component)refresh, "East");
        KDPanel innerPanel2 = new KDPanel();
        innerPanel2.setOpaque(false);
        innerPanel2.add(runScript);
        innerPanel2.add(this.expField);
        innerPanel2.add(eval);
        inputPanel.add((Component)innerPanel1, "West");
        inputPanel.add((Component)innerPanel2, "Center");
        sp.add((Component)new KDScrollPane(this.resultArea), "Center");
        sp.add((Component)inputPanel, "South");
        return sp;
    }

    private String processComponentInfo(Component c) {
        if (c == null) {
            return "\u672a\u9009\u4e2d\u4efb\u4f55\u7ed3\u70b9";
        }
        String info = c.toString();
        if (c.getParent() instanceof KDTabbedPane) {
            info = info + "\n" + (c.isVisible() ? "Visible" : "Hide");
        }
        return info;
    }

    private void expEval(String exp) {
        if (exp == null || exp.length() == 0) {
            return;
        }
        String str = exp.toLowerCase();
        if ((str.indexOf("update") >= 0 || str.indexOf("insert") >= 0 || str.indexOf("delete") >= 0) && str.indexOf("t_") >= 0) {
            return;
        }
        String result = null;
        String version = System.getProperty("java.version");
        float v = Float.parseFloat(version = version.substring(0, 3));
        if (v >= 1.6f) {
            try {
                ClassLoader loader = ClassLoader.getSystemClassLoader();
                Class<?> scriptEngineManager = loader.loadClass("javax.script.ScriptEngineManager");
                Class<?> scriptEngine = loader.loadClass("javax.script.ScriptEngine");
                Object manager = scriptEngineManager.newInstance();
                Method getJS = scriptEngineManager.getDeclaredMethod("getEngineByName", String.class);
                Object js = getJS.invoke(manager, "javascript");
                Method put = scriptEngine.getDeclaredMethod("put", String.class, Object.class);
                put.invoke(js, "comp", this.selectedComp);
                put.invoke(js, "expression", exp);
                Method eval = scriptEngine.getDeclaredMethod("eval", String.class);
                try {
                    Object o = null;
                    o = this.selectedComp != null ? eval.invoke(js, "comp." + exp + ";") : eval.invoke(js, exp + ";");
                    if (o == null) {
                        o = "void";
                    }
                    result = o.toString();
                    System.out.println("Kingdee Debug Panel excute:" + exp);
                    logger.debug((Object)("Kingdee Debug Panel excute:" + exp));
                }
                catch (Exception es) {
                    result = "\u8868\u8fbe\u5f0f\u9519\u8bef\uff0c\u65b9\u6cd5\u672a\u6267\u884c\uff01";
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                result = "\u8be5\u529f\u80fd\u9700JRE1.6\u4ee5\u4e0a\u652f\u6301";
            }
        } else {
            result = "\u8be5\u529f\u80fd\u9700JRE1.6\u4ee5\u4e0a\u652f\u6301";
        }
        this.resultArea.setText(result);
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.refresh();
        } else {
            if (this.oneTouch != null) {
                this.oneTouch.setSelected(false);
            }
            if (this.targetWindow != null) {
                this.targetWindow.repaint();
            }
        }
        super.setVisible(b);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                KDDebugPane.this.expField.requestFocus();
            }
        });
    }

    private void refresh() {
        this.componentsTable.clear();
        this.compTree.removeAllChildrenFromParent((MutableTreeNode)this.compTree.getModel().getRoot());
        this.compTree.configTreeWithComponents(this.targetWindow, (DefaultTreeModel)this.compTree.getModel());
        this.compTree.expandAllNodes(false, (TreeNode)this.compTree.getModel().getRoot());
        this.selectedComp = null;
    }

    private void showFindNextDialog() {
        DefaultTreeModel newTreeModel;
        if (this.compTree != null && (newTreeModel = (DefaultTreeModel)this.compTree.getModel()) != null && newTreeModel.getRoot() != null) {
            if (this.findDialog == null) {
                this.findDialog = new SearchDialog(this);
            }
            this.findDialog.config(this.compTree);
            this.findDialog.setLocationRelativeTo(this);
            this.findDialog.setVisible(true);
        }
    }

    private void reNewKDComponents() {
        this.kdPnl.remove(this.datepicker);
        this.kdPnl.remove(this.timepicker);
        this.kdPnl.remove(this.formattedTextfield);
        DateFormat originalDateTimeFormat = CtrlFormatUtilities.getDateTimeFormat();
        DateFormatSymbols originalDateSymbols = CtrlFormatUtilities.getDateFormatSymbols();
        DecimalFormatEx originalNumberDisplayFormat = CtrlFormatUtilities.getDisplayNumberFormat();
        DecimalFormatEx originalNumberEditFormat = CtrlFormatUtilities.getEditNumberFormat();
        DecimalFormatSymbols originalDecimalFormatSymbols = CtrlFormatUtilities.getDecimalFormatSymbols();
        if (this.currentDateTimeFormat != null) {
            CtrlFormatUtilities.setFormat("dateTimeFormat", this.currentDateTimeFormat);
        }
        if (this.currentNumberDisplayFormat != null && this.currentNumberEditFormat != null) {
            CtrlFormatUtilities.setEdtDisNumberFormat(this.currentNumberEditFormat, this.currentNumberDisplayFormat);
        }
        if (this.currentDateFormatSymbols != null) {
            CtrlFormatUtilities.setDateFormatSymbols((DateFormatSymbols)this.currentDateFormatSymbols);
        }
        if (this.currentDecimalFormatSymbols != null) {
            CtrlFormatUtilities.setDecimalFormatSymbols((DecimalFormatSymbols)this.currentDecimalFormatSymbols);
        }
        this.createKDComponents();
        this.kdPnl.add(this.datepicker);
        this.kdPnl.add(this.timepicker);
        this.kdPnl.add(this.formattedTextfield);
        this.kdPnl.revalidate();
        CtrlFormatUtilities.setFormat("dateTimeFormat", originalDateTimeFormat);
        CtrlFormatUtilities.setEdtDisNumberFormat(originalNumberEditFormat, originalNumberDisplayFormat);
        CtrlFormatUtilities.setDateFormatSymbols((DateFormatSymbols)originalDateSymbols);
        CtrlFormatUtilities.setDecimalFormatSymbols((DecimalFormatSymbols)originalDecimalFormatSymbols);
    }

    private void resetDefaultFormatterFactory(JFormattedTextField comp) {
        Object value = comp.getValue();
        DefaultFormatterFactory factory = null;
        if (value instanceof Date) {
            DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2, this.currentLocale);
            dateFormat.setTimeZone(this.currentTimezone);
            factory = new DefaultFormatterFactory(new DateFormatter(dateFormat));
            this.currentDateTimeFormat = (SimpleDateFormat)dateFormat;
            this.currentDateFormatSymbols = ((SimpleDateFormat)dateFormat).getDateFormatSymbols();
            this.dateTimePatternLabel.setText("Date&Time Pattern: " + this.currentDateTimeFormat.toPattern());
        } else if (value instanceof Number) {
            DecimalFormatEx disFormat;
            DecimalFormat numberFormat = (DecimalFormat)NumberFormat.getNumberInstance(this.currentLocale);
            NumberFormatter displayFormatter = new NumberFormatter(numberFormat);
            displayFormatter.setValueClass(value.getClass());
            NumberFormatter editFormatter = new NumberFormatter(new DecimalFormat("#.#"));
            editFormatter.setValueClass(value.getClass());
            factory = new DefaultFormatterFactory(displayFormatter, displayFormatter, editFormatter);
            this.currentNumberDisplayFormat = disFormat = new DecimalFormatEx(numberFormat.toPattern(), numberFormat.getDecimalFormatSymbols());
            this.currentNumberEditFormat = new DecimalFormatEx("#.#");
            this.currentDecimalFormatSymbols = numberFormat.getDecimalFormatSymbols();
            this.numberPatternLabel.setText("Number Pattern: " + this.currentNumberDisplayFormat.toPattern());
        } else {
            factory = new DefaultFormatterFactory(new DefaultFormatter());
        }
        comp.setFormatterFactory(factory);
    }

    private class TimeZoneAction
    extends AbstractAction {
        private TimeZone timezone = null;

        public TimeZoneAction(TimeZone zone) {
            this.timezone = zone;
            this.putValue("Name", zone.getDisplayName());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            KDDebugPane.this.currentTimezone = this.timezone;
            KDDebugPane.this.resetDefaultFormatterFactory(KDDebugPane.this.dateFormatText);
            KDDebugPane.this.resetDefaultFormatterFactory(KDDebugPane.this.numberFormatText);
            KDDebugPane.this.reNewKDComponents();
        }
    }

    private class LocaleAction
    extends AbstractAction {
        private Locale locale = null;

        LocaleAction(Locale locale) {
            this.locale = locale;
            this.putValue("Name", locale.getDisplayLanguage() + "_" + locale.getDisplayCountry());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            KDDebugPane.this.currentLocale = this.locale;
            KDDebugPane.this.resetDefaultFormatterFactory(KDDebugPane.this.dateFormatText);
            KDDebugPane.this.resetDefaultFormatterFactory(KDDebugPane.this.numberFormatText);
            KDDebugPane.this.reNewKDComponents();
        }
    }

    private static class DebugAction
    extends AbstractAction {
        private KDDebugPane debugPane;
        private Window targetWindow;
        private static final String OWNER = "Owner";

        private DebugAction(Window target) {
            this.targetWindow = target;
        }

        public boolean target(Window target) {
            return this.targetWindow == target;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.debugPane == null) {
                if (this.targetWindow instanceof JFrame) {
                    this.debugPane = new KDDebugPane((JFrame)this.targetWindow);
                } else if (this.targetWindow instanceof JDialog) {
                    this.debugPane = new KDDebugPane((JDialog)this.targetWindow);
                }
            }
            if (this.debugPane != null) {
                this.debugPane.setLocationRelativeTo(this.targetWindow);
                this.debugPane.setVisible(true);
            }
        }

        private boolean checkPermission() {
            HashMap<String, KDDebugPane> uiContext = new HashMap<String, KDDebugPane>();
            uiContext.put(OWNER, this.debugPane);
            try {
                Object[] args = new Object[]{"com.kingdee.eas.fm.common.client.FMIsqlUI", uiContext, null, null};
                Class<?> UIFactoryHelper = Class.forName("com.kingdee.eas.base.uiframe.client.UIFactoryHelper");
                Method initUIObject = UIFactoryHelper.getMethod("initUIObject", String.class, Map.class, Map.class, String.class);
                Object invoke = initUIObject.invoke(null, args);
                if (invoke != null) {
                    return true;
                }
            }
            catch (Exception e) {
                return false;
            }
            return false;
        }
    }

    private class CBListener
    extends MouseInputAdapter {
        MyGlassPane glassPane;
        Container layeredPane;
        private Component selectedComponent;

        public CBListener(MyGlassPane glassPane, Container layeredPane) {
            this.glassPane = glassPane;
            this.layeredPane = layeredPane;
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.redispatchMouseEvent(e, false);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.redispatchMouseEvent(e, false);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.redispatchMouseEvent(e, false);
            if (this.selectedComponent != null) {
                KDDebugPane.this.compTree.setSelectionNode((DefaultKingdeeTreeNode)KDDebugPane.this.componentsTable.get(this.selectedComponent));
                KDDebugPane.this.compTree.scrollPathToVisible(KDDebugPane.this.compTree.getSelectionPath());
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.redispatchMouseEvent(e, false);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.redispatchMouseEvent(e, false);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.redispatchMouseEvent(e, false);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.redispatchMouseEvent(e, true);
        }

        private void redispatchMouseEvent(MouseEvent e, boolean repaint) {
            Point glassPanePoint = e.getPoint();
            Point containerPoint = SwingUtilities.convertPoint(this.glassPane, glassPanePoint, this.layeredPane);
            this.selectedComponent = this.layeredPane.findComponentAt(containerPoint);
            if (repaint) {
                this.glassPane.setComponent(this.selectedComponent);
                this.glassPane.repaint();
            }
        }
    }

    private class MyGlassPane
    extends JComponent
    implements ItemListener {
        Component selectedComp;

        @Override
        public void itemStateChanged(ItemEvent e) {
            boolean doIt;
            boolean bl = doIt = e.getStateChange() == 1;
            if (KDDebugPane.this.targetWindow instanceof JFrame) {
                JFrame targetFrame = (JFrame)KDDebugPane.this.targetWindow;
                targetFrame.setGlassPane(doIt ? this : KDDebugPane.this.glassPane);
                targetFrame.getGlassPane().setVisible(doIt);
            } else if (KDDebugPane.this.targetWindow instanceof JDialog) {
                JDialog targetDialog = (JDialog)KDDebugPane.this.targetWindow;
                targetDialog.setGlassPane(doIt ? this : KDDebugPane.this.glassPane);
                targetDialog.getGlassPane().setVisible(doIt);
            }
            KDDebugPane.this.targetWindow.repaint();
            if (KDDebugPane.this.compTree.lastSelectedComp != null) {
                KDDebugPane.this.compTree.lastSelectedComp.repaint();
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            if (this.selectedComp != null && this.selectedComp.isShowing()) {
                Point compLocation = this.selectedComp.getLocationOnScreen();
                Point glassLocation = this.getLocationOnScreen();
                g.setColor(Color.red);
                g.translate(0 - glassLocation.x, 0 - glassLocation.y);
                g.drawRect(compLocation.x, compLocation.y, this.selectedComp.getWidth() - 1, this.selectedComp.getHeight() - 1);
                g.translate(glassLocation.x, glassLocation.y);
            }
        }

        public void setComponent(Component comp) {
            this.selectedComp = comp;
        }

        public MyGlassPane(Container layeredPane) {
            CBListener listener = new CBListener(this, layeredPane);
            this.addMouseListener(listener);
            this.addMouseMotionListener(listener);
        }
    }

    private class ComponentsTree
    extends KDTree {
        private Component lastSelectedComp;

        public ComponentsTree() {
            if (KDDebugPane.this.componentsTable == null) {
                KDDebugPane.this.componentsTable = new Hashtable();
            }
            ((DefaultTreeModel)this.getModel()).setRoot(new DefaultKingdeeTreeNode("\u5f85\u6784\u9020\u7684\u63a7\u4ef6\u6811"));
            this.setToolTipText(null);
            this.addTreePopupMenu(new TreePopupMenuListener(){

                @Override
                public boolean popMenu(TreePopupMenuEvent event) {
                    return true;
                }
            });
            this.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    TreePath path = e.getPath();
                    Object nodeObject = ((DefaultKingdeeTreeNode)path.getLastPathComponent()).getUserObject();
                    if (!(nodeObject instanceof Component)) {
                        KDDebugPane.this.infoArea.setText("\u6784\u9020\u7684\u63a7\u4ef6\u6811\u4e0d\u5408\u6cd5\uff01");
                        return;
                    }
                    KDDebugPane.this.selectedComp = (Component)nodeObject;
                    KDDebugPane.this.infoArea.setText(null);
                    String info = KDDebugPane.this.processComponentInfo(KDDebugPane.this.selectedComp);
                    KDDebugPane.this.infoArea.setText(info);
                    if (KDDebugPane.this.selectedComp != null && KDDebugPane.this.selectedComp.isShowing()) {
                        if (ComponentsTree.this.lastSelectedComp != null) {
                            ComponentsTree.this.lastSelectedComp.repaint();
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (KDDebugPane.this.selectedComp != null) {
                                    Point compLocation = KDDebugPane.this.selectedComp.getLocationOnScreen();
                                    Point windowLocation = KDDebugPane.this.targetWindow.getLocationOnScreen();
                                    Graphics2D g = (Graphics2D)KDDebugPane.this.targetWindow.getGraphics();
                                    Paint oldPaint = g.getPaint();
                                    g.setPaint(Color.red);
                                    g.translate(0 - windowLocation.x, 0 - windowLocation.y);
                                    g.drawRect(compLocation.x, compLocation.y, KDDebugPane.this.selectedComp.getWidth() - 1, KDDebugPane.this.selectedComp.getHeight() - 1);
                                    g.translate(windowLocation.x, windowLocation.y);
                                    g.setPaint(oldPaint);
                                }
                            }
                        });
                        ComponentsTree.this.lastSelectedComp = KDDebugPane.this.selectedComp;
                    }
                }
            });
        }

        private void configTreeWithComponents(Component c, DefaultTreeModel model) {
            if (c == KDDebugPane.this.selfPane || c == null) {
                return;
            }
            DefaultKingdeeTreeNode node = this.createComponentNode(c);
            Component[] children = null;
            if (c instanceof JMenu) {
                JPopupMenu popMenu = ((JMenu)c).getPopupMenu();
                DefaultKingdeeTreeNode extraNode = this.createComponentNode(popMenu);
                node.add(extraNode);
                ((DefaultKingdeeTreeNode)KDDebugPane.this.componentsTable.get(c.getParent())).add(node);
                children = ((JMenu)c).getMenuComponents();
            } else if (c instanceof Container) {
                Container parent = c.getParent();
                if (parent != null) {
                    if (KDDebugPane.this.componentsTable.get(parent) != null) {
                        ((DefaultKingdeeTreeNode)KDDebugPane.this.componentsTable.get(parent)).add(node);
                    } else {
                        model.setRoot(node);
                    }
                } else {
                    model.setRoot(node);
                }
                children = ((Container)c).getComponents();
            }
            if (children != null) {
                for (int i = 0; i < children.length; ++i) {
                    this.configTreeWithComponents(children[i], model);
                }
            }
        }

        private DefaultKingdeeTreeNode createComponentNode(Component c) {
            DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode(c);
            String name = c.getClass().getName();
            name = name.substring(name.lastIndexOf(".") + 1);
            if (c.getName() != null && c.getName().length() > 0) {
                name = name + "(" + c.getName() + ")";
            }
            node.setText(name);
            node.setCheckBoxVisible(false);
            KDDebugPane.this.componentsTable.put(c, node);
            return node;
        }
    }

    private static class SearchDialog
    extends KDComponentDialog {
        private List nodeList;
        private KDTree tree;
        private KDTextField findNextTxt;
        private String textToFound = "";
        private int foundIndex = -1;
        private int currentIndex = 0;
        private boolean finishSearch = false;

        public SearchDialog(Dialog dlg) {
            super(dlg);
            this.init();
        }

        private void init() {
            this.setLFStyle(2);
            this.setTitle("\u67e5\u627e\u8282\u70b9");
            KDButton findNextBtn = new KDButton("\u67e5\u627e\u4e0b\u4e00\u4e2a");
            findNextBtn.setLimitedSize(false);
            findNextBtn.setFocusable(false);
            findNextBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.findNode();
                }
            });
            KDButton closeBtn = new KDButton("\u5173\u95ed");
            closeBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.dispose();
                }
            });
            KDLabelContainer findNextLabel = new KDLabelContainer();
            this.findNextTxt = new KDTextField();
            CtrlSwingUtilities.removeManagingFocusForwardTraversalKeys(this.findNextTxt, KeyStroke.getKeyStroke(10, 0));
            findNextLabel.setBoundLabelText("\u63a7\u4ef6\u7c7b\u540d     ");
            findNextLabel.setBoundEditor(this.findNextTxt);
            findNextLabel.setPreferredSize(new Dimension(270, 21));
            findNextLabel.setBoundLabelUnderline(true);
            this.addButton(findNextBtn);
            this.addButton(closeBtn);
            this.setDialogComponent(findNextLabel);
            this.getRootPane().setDefaultButton(findNextBtn);
            this.setSize(290, 118);
            this.setResizable(false);
        }

        public void config(KDTree targetTree) {
            if (targetTree == null) {
                throw new IllegalArgumentException("Can't construct a SearchDialog with a null JTree!");
            }
            this.tree = targetTree;
            DefaultTreeModel newTreeModel = (DefaultTreeModel)this.tree.getModel();
            if (newTreeModel != null && newTreeModel.getRoot() != null) {
                this.nodeList = new ArrayList();
                DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)newTreeModel.getRoot();
                Enumeration<TreeNode> e = root.preorderEnumeration();
                while (e.hasMoreElements()) {
                    this.nodeList.add(e.nextElement());
                }
            }
        }

        private void findNode() {
            String nodeText = "";
            int size = this.nodeList.size();
            String input = this.findNextTxt.getText().toLowerCase().trim();
            if (input != null && input.length() > 0) {
                DefaultKingdeeTreeNode currentNode;
                if (!this.textToFound.equalsIgnoreCase(input)) {
                    this.finishSearch = false;
                    this.textToFound = input;
                    currentNode = null;
                    this.foundIndex = -1;
                    this.currentIndex = 0;
                }
                this.currentIndex = this.foundIndex + 1;
                if (this.currentIndex < size) {
                    int i;
                    for (i = this.currentIndex; i < size; ++i) {
                        Object node = this.nodeList.get(i);
                        if (!(node instanceof DefaultKingdeeTreeNode) || (nodeText = (currentNode = (DefaultKingdeeTreeNode)this.nodeList.get(i)).getText().toLowerCase()) == null || nodeText.indexOf(this.textToFound) == -1) continue;
                        this.tree.setSelectionNode(currentNode);
                        this.tree.scrollPathToVisible(this.tree.getSelectionPath());
                        this.foundIndex = i;
                        if (i != this.nodeList.size() - 1) break;
                        ++i;
                        break;
                    }
                    if (i == size) {
                        this.finishSearch = true;
                    }
                }
                if (this.foundIndex == -1) {
                    KDOptionPane.showMessageDialog(this, "\u5df2\u5b8c\u6210\u641c\u7d22\uff0c\u6ca1\u6709\u627e\u5230\u641c\u7d22\u9879");
                } else if (this.finishSearch) {
                    this.textToFound = "";
                    KDOptionPane.showMessageDialog(this, "\u5df2\u7ecf\u5b8c\u6210\u641c\u7d22");
                }
            }
        }
    }
}

