/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing;

import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.BasicNumberTextField;
import com.kingdee.bos.ctrl.swing.CtrlPlainDocument;
import com.kingdee.bos.ctrl.swing.DecimalFormatEx;
import com.kingdee.bos.ctrl.swing.DefaultHandleKDComponentException;
import com.kingdee.bos.ctrl.swing.IAllowedMouseProcess;
import com.kingdee.bos.ctrl.swing.IBoundLabelControl;
import com.kingdee.bos.ctrl.swing.ICtrTextDocumentFilter;
import com.kingdee.bos.ctrl.swing.IHandleKDComponentException;
import com.kingdee.bos.ctrl.swing.IKDComponent;
import com.kingdee.bos.ctrl.swing.IKDTextComponent;
import com.kingdee.bos.ctrl.swing.ITempFormattedConstant;
import com.kingdee.bos.ctrl.swing.KDInvalidArgumentException;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.NumberFeatureMode;
import com.kingdee.bos.ctrl.swing.NumberFormatterEx;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import java.awt.Color;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.Document;
import javax.swing.text.NumberFormatter;
import javax.swing.undo.UndoManager;

public class KDFormattedTextField
extends BasicFormattedTextField
implements IKDComponent,
IBoundLabelControl,
ITempFormattedConstant,
IAllowedMouseProcess,
IKDTextComponent {
    private static final long serialVersionUID = -6833765901139244498L;
    public static final int INTEGER = 0;
    public static final int DECIMAL = 1;
    public static final int BYTE_TYPE = 6;
    public static final int SHORT_TYPE = 2;
    public static final int INTEGER_TYPE = 0;
    public static final int LONG_TYPE = 7;
    public static final int FLOAT_TYPE = 4;
    public static final int DOUBLE_TYPE = 5;
    public static final int BIGINTEGER_TYPE = 10;
    public static final int BIGDECIMAL_TYPE = 1;
    public static final int STRING_TYPE = 9;
    public static final int FOCUS_VERIFIER = 11;
    public static final int NO_VERIFIER = -1;
    public static final int INPUTING_VERIFIER = 12;
    private static final int INPUTING_VERIFY = 12;
    public static final int OUTSIDE_VERIFY_REVERT = -1;
    public static final int OUTSIDE_VERIFY_EXCEPTION = 11;
    private int dataVerifierType = -1;
    private int dataType = -1;
    private int roundingMode = 4;
    private Color negativeColor = Color.RED;
    private Object userObject = null;
    private boolean negatived = true;
    private static final int DEFAULT_PRECISION = 10;
    private int precision = 10;
    protected KDLabelContainer kdLabelContainer;
    private PropertyChangeListener dataChangePropertyHandler = null;
    IHandleKDComponentException defaultHandleKDComponentException = null;
    private static final IHandleKDComponentException HandleKDComponentnException = new DefaultHandleKDComponentException();
    private NumberFeatureMode numberFeatureMode = null;
    private Number maximumNumber = null;
    private Number minimumNumber = null;
    private boolean isImmediatelyValidate = true;
    private InnerPropertyChangeListener innerPropertyListener = null;
    private boolean isCommitsOnValidEdit = false;
    private boolean isSupportedEmpty = false;
    private JComponent[] allowedProcessMouseComps = null;
    public static final String undoAction = "undo-formattextfield";
    public static final String redoAction = "redo-formattextfield";
    public UndoManager manager = null;
    FocusListener additionalFocusListener;
    private boolean decimalSeparatorAlwaysShown = false;
    private Insets customInsets;
    private boolean superPrecision = true;

    public KDFormattedTextField() {
        this(0);
    }

    public KDFormattedTextField(JFormattedTextField.AbstractFormatterFactory factory) {
        super(factory);
        this.init(-1);
    }

    public KDFormattedTextField(Object value) {
        int tempDataType = this.objectToIntType(value);
        this.init(tempDataType);
        this.setValue(value);
    }

    @Override
    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this.enableInputMethods(false);
    }

    public KDFormattedTextField(int pDataType) {
        this.init(pDataType);
    }

    @Override
    protected void processFocusEvent(FocusEvent e) {
        Document document = this.getDocument();
        if (document != null && document instanceof CtrlPlainDocument) {
            if (e.getID() == 1005) {
                ((CtrlPlainDocument)document).setFocusing(false);
            } else {
                ((CtrlPlainDocument)document).setFocusing(true);
            }
        }
        super.processFocusEvent(e);
        if (e.getID() == 1004 && this.additionalFocusListener != null) {
            this.additionalFocusListener.focusGained(e);
        }
    }

    public void setAdditionalFocusListener(FocusListener listener) {
        this.additionalFocusListener = listener;
    }

    private int objectToIntType(Object value) {
        if (value != null) {
            if (value instanceof Byte) {
                return 6;
            }
            if (value instanceof Short) {
                return 2;
            }
            if (value instanceof Integer) {
                return 0;
            }
            if (value instanceof Float) {
                return 4;
            }
            if (value instanceof Double) {
                return 5;
            }
            if (value instanceof Long) {
                return 7;
            }
            if (value instanceof BigInteger) {
                return 10;
            }
            if (value instanceof BigDecimal) {
                return 1;
            }
        }
        return 0;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int newValue) {
        int old = this.precision;
        if (old == newValue || newValue < 0) {
            return;
        }
        if (this.dataType == 1 && newValue > 10) {
            this.superPrecision(newValue);
            return;
        }
        switch (this.dataType) {
            case 0: 
            case 2: 
            case 6: 
            case 7: 
            case 10: {
                break;
            }
            case 4: {
                if (newValue <= 6 && newValue >= 0) break;
                newValue = 6;
                break;
            }
            case 5: {
                if (newValue <= 10 && newValue >= 0) break;
                newValue = 10;
                break;
            }
            case 1: {
                break;
            }
            default: {
                return;
            }
        }
        this.precision = newValue;
        if (old != newValue && this.isImmediatelyValidate()) {
            this.createDisEdiFormatterAgain(52);
        }
    }

    public boolean isPercentDisplay() {
        return this.getNumberFeatureMode().isDisPercentingUsed();
    }

    public void setPercentDisplay(boolean newValue) {
        this.getNumberFeatureMode().setDisPercentingUsed(newValue);
    }

    public void setMultiplier(int newValue) {
        this.getNumberFeatureMode().setMultiplier(newValue);
    }

    public int getMultiplier() {
        return this.getNumberFeatureMode().getMultiplier();
    }

    public void setRoundingMode(int newValue) {
        switch (newValue) {
            case 2: {
                break;
            }
            case 1: {
                break;
            }
            case 3: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 4: {
                break;
            }
            case 7: {
                break;
            }
            case 0: {
                break;
            }
            default: {
                newValue = 4;
            }
        }
        int old = this.roundingMode;
        if (old != newValue) {
            this.roundingMode = newValue;
            if (this.isImmediatelyValidate()) {
                this.createDisEdiFormatterAgain(53);
            }
        }
    }

    public int getRoundingMode() {
        return this.roundingMode;
    }

    public Color getNegativeColor() {
        return this.negativeColor;
    }

    public void setNegativeColor(Color clr) {
        this.negativeColor = clr;
    }

    @Override
    public Object getValue() {
        return super.getValue();
    }

    public Object getValue(Class c) {
        return this.getNumberValue(c);
    }

    @Override
    public void setValue(Object value) {
        if (value != null) {
            if (!(value instanceof Number)) {
                throw new KDInvalidArgumentException("the value'type must be java.lang.Number or null,in method setValue(value)");
            }
            if (!this.isNegatived() && ((Number)value).doubleValue() < 0.0) {
                return;
            }
            if (this.getFormatterFactory() == null) {
                int tempDataType = this.objectToIntType(value);
                this.initByDataType(tempDataType);
                this.createFormatterFactoryByDataType(tempDataType);
            }
            if (this.maximumNumber != null && this.minimumNumber != null) {
                if (((Number)value).doubleValue() > this.maximumNumber.doubleValue()) {
                    value = this.maximumNumber;
                }
                if (((Number)value).doubleValue() < this.minimumNumber.doubleValue()) {
                    value = this.minimumNumber;
                }
            }
        }
        super.setValue(value);
    }

    @Override
    public void setValue(Object value, boolean fireListener) {
        if (value != null) {
            if (!(value instanceof Number)) {
                throw new KDInvalidArgumentException("the value'type must be java.lang.Number or null,in method setValue(value)");
            }
            if (!this.isNegatived() && ((Number)value).doubleValue() < 0.0) {
                return;
            }
            if (this.getFormatterFactory() == null) {
                int tempDataType = this.objectToIntType(value);
                this.initByDataType(tempDataType);
                this.createFormatterFactoryByDataType(tempDataType);
            }
            if (this.maximumNumber != null && this.minimumNumber != null) {
                if (((Number)value).doubleValue() > this.maximumNumber.doubleValue()) {
                    value = this.maximumNumber;
                }
                if (((Number)value).doubleValue() < this.minimumNumber.doubleValue()) {
                    value = this.minimumNumber;
                }
            }
        }
        super.setValue(value, fireListener);
    }

    public void setDataType(int newValue) {
        if (this.isValidateDateType(newValue)) {
            int old = this.dataType;
            if (old != newValue) {
                this.dataType = newValue;
                this.initByDataType(newValue);
                switch (newValue) {
                    case 2: 
                    case 6: {
                        this.setMaximumValue(new Short(Short.MAX_VALUE));
                        this.setMinimumValue(new Short(Short.MIN_VALUE));
                        break;
                    }
                    case 0: {
                        this.setMaximumValue(new Integer(Integer.MAX_VALUE));
                        this.setMinimumValue(new Integer(-2147483647));
                        break;
                    }
                    case 7: 
                    case 10: {
                        this.setMaximumValue(new Long("9999999999999"));
                        this.setMinimumValue(new Long("-9999999999999"));
                        break;
                    }
                    case 9: {
                        this.precision = 0;
                        break;
                    }
                    case 4: {
                        if (CtrlFormatUtilities.getDisplayNumberFormat() == null && (this.precision <= 0 || this.precision > 6)) {
                            this.precision = 6;
                        }
                        this.setMaximumValue(new Float("9999999999999.99"));
                        this.setMinimumValue(new Float("-9999999999999.99"));
                        break;
                    }
                    case 5: {
                        if (CtrlFormatUtilities.getDisplayNumberFormat() == null && (this.precision <= 0 || this.precision > 10)) {
                            this.precision = 10;
                        }
                        this.setMaximumValue(new Double("9999999999999.99"));
                        this.setMinimumValue(new Double("-9999999999999.99"));
                        break;
                    }
                    case 1: {
                        this.setMaximumValue(new BigDecimal("9999999999999.99"));
                        this.setMinimumValue(new BigDecimal("-9999999999999.99"));
                        break;
                    }
                }
                if (this.isImmediatelyValidate()) {
                    this.createDisEdiFormatterAgain(51);
                }
            }
        } else {
            throw new IllegalArgumentException("setDataType is illegal,please see BasicNumberTextField's constant .");
        }
    }

    public void setDataType(Class c) {
        if (c != null) {
            int newDataType = 0;
            try {
                newDataType = this.classToIntType(c);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.setDataType(newDataType);
        }
    }

    private int classToIntType(Class classValue) {
        String cName = classValue.getName();
        if (cName.equals("java.lang.Byte")) {
            return 6;
        }
        if (cName.equals("java.lang.Short")) {
            return 2;
        }
        if (cName.equals("java.lang.Integer")) {
            return 0;
        }
        if (cName.equals("java.lang.Float")) {
            return 4;
        }
        if (cName.equals("java.lang.Double")) {
            return 5;
        }
        if (cName.equals("java.lang.Long")) {
            return 7;
        }
        if (cName.equals("java.math.BigDecimal")) {
            return 1;
        }
        if (cName.equals("java.math.BigInteger")) {
            return 10;
        }
        throw new IllegalArgumentException("classToIntType(Class), the parameter " + classValue + " is not supported!");
    }

    public void setDataVerifierType(int newValue) {
        switch (newValue) {
            case 12: {
                break;
            }
            case -1: {
                this.setFocusLostBehavior(1);
                break;
            }
            default: {
                this.setFocusLostBehavior(0);
                newValue = 11;
            }
        }
        int old = this.dataVerifierType;
        if (old != newValue) {
            this.dataVerifierType = newValue;
            if (this.isImmediatelyValidate()) {
                this.createDisEdiFormatterAgain(54);
            }
        }
    }

    public int getDataVerifierType() {
        return this.dataVerifierType;
    }

    public void setAllowsInvalid(boolean newValue) {
    }

    public void setOverwriteMode(boolean newValue) {
    }

    public boolean getAllowsInvalid() {
        return false;
    }

    public boolean getOverwriteMode() {
        return false;
    }

    public int getDataType() {
        return this.dataType;
    }

    public void setRemoveingZeroInDispaly(boolean newValue) {
        this.getNumberFeatureMode().setRemoveingZeroInDispaly(newValue);
    }

    public boolean isRemoveingZeroInDispaly() {
        return this.getNumberFeatureMode().isRemoveingZeroInDispaly();
    }

    public void setRemoveingZeroInEdit(boolean newValue) {
        this.getNumberFeatureMode().setRemoveingZeroInEdit(newValue);
    }

    public boolean isRemoveingZeroInEdit() {
        return this.getNumberFeatureMode().isRemoveingZeroInEdit();
    }

    public boolean isImmediatelyValidate() {
        return this.isImmediatelyValidate;
    }

    public void setImmediatelyValidate(boolean newValue) {
        this.isImmediatelyValidate = newValue;
    }

    public Number getNumberValue() {
        Number obj = this.GETNumberValue();
        return KDFormattedTextField.getValueByType(obj, this.dataType);
    }

    public static Number getValueByType(Number obj, int dataType) {
        if (obj == null) {
            return obj;
        }
        switch (dataType) {
            case 6: {
                return new Byte(obj.byteValue());
            }
            case 2: {
                return new Short(obj.shortValue());
            }
            case 0: {
                return new Integer(obj.intValue());
            }
            case 7: {
                return new Long(obj.longValue());
            }
            case 4: {
                return new Float(obj.floatValue());
            }
            case 5: {
                return new Double(obj.doubleValue());
            }
            case 1: {
                return new BigDecimal(obj.toString());
            }
            case 10: {
                return new BigInteger(obj.toString());
            }
        }
        return obj;
    }

    public void setNumberValue(Number newValue) {
        this.setValue(newValue);
    }

    public void setNumberValue(Number newValue, boolean fireListener) {
        this.setValue(newValue, fireListener);
    }

    public Number getNumberValue(Class valueClass) {
        if (valueClass == null) {
            throw new NullPointerException("valueClass is null in getNumberValue(Class)");
        }
        int newDataType = this.classToIntType(valueClass);
        switch (newDataType) {
            case 6: {
                return this.getByteValue();
            }
            case 2: {
                return this.getShortValue();
            }
            case 0: {
                return this.getIntegerValue();
            }
            case 7: {
                return this.getLongValue();
            }
            case 4: {
                return this.getFloatValue();
            }
            case 5: {
                return this.getDoubleValue();
            }
            case 10: {
                return this.getBigIntegerValue();
            }
            case 1: {
                return this.getBigDecimalValue();
            }
        }
        return this.getIntegerValue();
    }

    private Number GETNumberValue() {
        Object obj = this.getValue();
        return (Number)obj;
    }

    public void CommitEditSilently() {
        block2: {
            try {
                this.commitEdit();
            }
            catch (ParseException ex) {
                if (this.getDataVerifierType() != -1) break block2;
                this.setValue(this.getValue());
            }
        }
    }

    public BigDecimal getBigDecimalValue() {
        Number number = this.GETNumberValue();
        if (number != null) {
            return new BigDecimal(number.toString());
        }
        return null;
    }

    public BigInteger getBigIntegerValue() {
        Number number = this.GETNumberValue();
        if (number != null) {
            return new BigInteger(String.valueOf(number.intValue()));
        }
        return null;
    }

    public Short getShortValue() {
        Number number = this.GETNumberValue();
        if (number != null) {
            return new Short(number.shortValue());
        }
        return null;
    }

    public Byte getByteValue() {
        Number number = this.GETNumberValue();
        if (number != null) {
            return new Byte(number.byteValue());
        }
        return null;
    }

    public ICtrTextDocumentFilter getCtrlTextDocumentFilter() {
        Document document = this.getDocument();
        if (document != null && document instanceof CtrlPlainDocument) {
            return ((CtrlPlainDocument)document).getCtrTextDocumentFilter();
        }
        return null;
    }

    public Integer getIntegerValue() {
        Number number = this.GETNumberValue();
        if (number != null) {
            return new Integer(number.intValue());
        }
        return null;
    }

    public Long getLongValue() {
        Number number = this.GETNumberValue();
        if (number != null) {
            return new Long(number.longValue());
        }
        return null;
    }

    public Float getFloatValue() {
        Number number = this.GETNumberValue();
        if (number != null) {
            return new Float(number.floatValue());
        }
        return null;
    }

    public Double getDoubleValue() {
        Number number = this.GETNumberValue();
        if (number != null) {
            return new Double(number.doubleValue());
        }
        return null;
    }

    public String getStringValue() {
        Number obj = this.getNumberValue();
        return obj != null ? obj.toString() : null;
    }

    public void addDataChangeListener(DataChangeListener l) {
        this.listenerList.add(DataChangeListener.class, l);
    }

    public void removeDataChangeListener(DataChangeListener l) {
        this.listenerList.remove(DataChangeListener.class, l);
    }

    protected void fireDataChangeListener(DataChangeEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DataChangeListener.class || event == null) continue;
            ((DataChangeListener)listeners[i + 1]).dataChanged(event);
        }
    }

    public void setNegatived(boolean newValue) {
        boolean old = this.negatived;
        if (old != newValue) {
            this.negatived = newValue;
            ICtrTextDocumentFilter textFilter = this.getCtrlTextDocumentFilter();
            if (textFilter != null && textFilter instanceof BasicNumberTextField.DefaultCtrlTextDocumentFilter) {
                ((BasicNumberTextField.DefaultCtrlTextDocumentFilter)textFilter).setNegativeble(this.negatived);
            }
        }
    }

    public boolean isNegatived() {
        return this.negatived;
    }

    public void setGroupingUsed(boolean newValue) {
        this.getNumberFeatureMode().setDisGroupingUsed(newValue);
    }

    public boolean isGroupingUsed() {
        return this.getNumberFeatureMode().isDisGroupingUsed();
    }

    public void setRemovingMinusInDisplay(boolean newValue) {
        this.getNumberFeatureMode().setRemovingMinusInDisplay(newValue);
    }

    public boolean isRemovingMinusInDisplay() {
        return this.getNumberFeatureMode().isRemovingMinusInDisplay();
    }

    public void setDecimalSeparatorAlwaysShown(boolean newValue) {
    }

    public boolean isDecimalSeparatorAlwaysShown() {
        return this.decimalSeparatorAlwaysShown;
    }

    public void setMaximumFractionDigits(int newValue) {
    }

    public void setMaximumIntegerDigits(int newValue) {
    }

    public void setMinimumFractionDigits(int newValue) {
    }

    public void setMinimumIntegerDigits(int newValue) {
    }

    public JFormattedTextField.AbstractFormatter getEditFormatter() {
        JFormattedTextField.AbstractFormatterFactory formatterFactory = this.getFormatterFactory();
        if (formatterFactory != null && formatterFactory instanceof DefaultFormatterFactory) {
            return ((DefaultFormatterFactory)formatterFactory).getEditFormatter();
        }
        return null;
    }

    public void setEditFormatter(JFormattedTextField.AbstractFormatter newValue) {
        if (newValue != null) {
            this.setFormatterFactory(null, newValue);
        }
    }

    public JFormattedTextField.AbstractFormatter getDispalyFormatter() {
        JFormattedTextField.AbstractFormatterFactory formatterFactory = this.getFormatterFactory();
        if (formatterFactory != null && formatterFactory instanceof DefaultFormatterFactory) {
            return ((DefaultFormatterFactory)formatterFactory).getDisplayFormatter();
        }
        return null;
    }

    public void setDisplayFormatter(JFormattedTextField.AbstractFormatter newValue) {
        if (newValue != null) {
            this.setFormatterFactory(newValue, null);
        }
    }

    public int getMaximumFractionDigits() {
        JFormattedTextField.AbstractFormatter formatter = this.getEditFormatter();
        if (formatter != null && formatter instanceof NumberFormatter) {
            return ((DecimalFormat)((NumberFormatter)formatter).getFormat()).getMaximumFractionDigits();
        }
        return this.precision;
    }

    public int getMaximumIntegerDigits() {
        JFormattedTextField.AbstractFormatter formatter = this.getEditFormatter();
        if (formatter != null && formatter instanceof NumberFormatter) {
            return ((DecimalFormat)((NumberFormatter)formatter).getFormat()).getMaximumIntegerDigits();
        }
        return 8;
    }

    public int getMinimumFractionDigits() {
        JFormattedTextField.AbstractFormatter formatter = this.getEditFormatter();
        if (formatter != null && formatter instanceof NumberFormatter) {
            return ((DecimalFormat)((NumberFormatter)formatter).getFormat()).getMinimumFractionDigits();
        }
        return this.precision;
    }

    public int getMinimumIntegerDigits() {
        JFormattedTextField.AbstractFormatter formatter = this.getEditFormatter();
        if (formatter != null && formatter instanceof NumberFormatter) {
            return ((DecimalFormat)((NumberFormatter)formatter).getFormat()).getMinimumIntegerDigits();
        }
        return 8;
    }

    private boolean isValidateDateType(int newDateType) {
        switch (newDateType) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void setUserObject(Object newUserObject) {
        this.userObject = newUserObject;
    }

    @Override
    public Object getUserObject() {
        return this.userObject;
    }

    public void setMaximumValue(Comparable newValue) {
        Number old = this.maximumNumber;
        int eq = CtrlSwingUtilities.judgeNumber(old, (Number)((Object)newValue));
        if (eq != 0) {
            this.maximumNumber = (Number)((Object)newValue);
            if (this.isImmediatelyValidate()) {
                this.createDisEdiFormatterAgain(55);
            }
        }
    }

    public Comparable getMaximumValue() {
        return (Comparable)((Object)this.maximumNumber);
    }

    public void setMinimumValue(Comparable newValue) {
        Number old = this.minimumNumber;
        int eq = CtrlSwingUtilities.judgeNumber(old, (Number)((Object)newValue));
        if (eq != 0) {
            this.minimumNumber = (Number)((Object)newValue);
            if (this.isImmediatelyValidate()) {
                this.createDisEdiFormatterAgain(56);
            }
        }
    }

    public Comparable getMinimumValue() {
        return (Comparable)((Object)this.minimumNumber);
    }

    protected int selfPrecision(int outPrecision) {
        return outPrecision;
    }

    protected void init(int newDataType) {
        this.setColumns(10);
        CtrlPlainDocument numberDocument = new CtrlPlainDocument();
        BasicNumberTextField.DefaultCtrlTextDocumentFilter ctrlTextDocuFilter = new BasicNumberTextField.DefaultCtrlTextDocumentFilter();
        numberDocument.setCtrTextDocumentFilter(ctrlTextDocuFilter);
        this.setDocument(numberDocument);
        if (this.dataChangePropertyHandler != null) {
            this.removePropertyChangeListener("value", this.dataChangePropertyHandler);
            this.dataChangePropertyHandler = null;
        } else {
            this.dataChangePropertyHandler = new DataPropertyChangeListener();
        }
        this.addPropertyChangeListener("value", this.dataChangePropertyHandler);
        this.setInputVerifier(new FormattedTextFieldVerifier());
        this.defaultHandleKDComponentException = HandleKDComponentnException;
        this.setDataType(newDataType);
        this.createFormatterFactoryByDataType(newDataType);
        if (this.manager == null) {
            this.manager = new UndoManager();
        }
        this.getDocument().addUndoableEditListener(this.manager);
        InputMap inputMap = this.getInputMap();
        ActionMap actionMap = this.getActionMap();
        KeyStroke newKeyStroke = KeyStroke.getKeyStroke(90, 2, false);
        inputMap.put(newKeyStroke, undoAction);
        newKeyStroke = KeyStroke.getKeyStroke(89, 2, false);
        inputMap.put(newKeyStroke, redoAction);
        actionMap.put(undoAction, new UndoAction());
        actionMap.put(redoAction, new RedoAction());
        this.enableInputMethods(false);
    }

    private void initByDataType(int newDataType) {
        DecimalFormatEx format = CtrlFormatUtilities.getDisplayNumberFormat();
        if (format != null && (newDataType == 4 || newDataType == 5 || newDataType == 1)) {
            this.precision = format.getMaximumFractionDigits();
            return;
        }
        switch (newDataType) {
            case 0: 
            case 2: 
            case 6: 
            case 7: 
            case 10: {
                this.precision = 0;
                break;
            }
            case 4: {
                if (this.precision > 0 && this.precision <= 6) break;
                this.precision = 6;
                break;
            }
            case 1: 
            case 5: {
                if (this.precision > 0 && this.precision <= 10) break;
                this.precision = 10;
                break;
            }
        }
    }

    private void createFormatterFactoryByDataType(int newDataType) {
        this.dataType = newDataType;
        this.setFormatterFactory(this.createDisplayFormatter(newDataType), this.createEditFormatter(newDataType));
    }

    private void setFormatterFactory(JFormattedTextField.AbstractFormatter disFormatter, JFormattedTextField.AbstractFormatter ediFormatter) {
        JFormattedTextField.AbstractFormatterFactory formatterFactory = this.getFormatterFactory();
        if (formatterFactory == null) {
            formatterFactory = new DefaultFormatterFactory();
        }
        boolean b = false;
        if (disFormatter != null) {
            ((DefaultFormatterFactory)formatterFactory).setDisplayFormatter(disFormatter);
            b = true;
        }
        if (ediFormatter != null) {
            ((DefaultFormatterFactory)formatterFactory).setEditFormatter(ediFormatter);
            b = true;
        }
        if (b) {
            this.setFormatterFactory(formatterFactory);
        }
    }

    @Override
    public void setLabelContainer(KDLabelContainer kdLabelContainer) {
        this.kdLabelContainer = kdLabelContainer;
    }

    @Override
    public KDLabelContainer getLabelContainer() {
        return this.kdLabelContainer;
    }

    @Override
    public void setBoundLabel(JLabel label) {
        if (this.kdLabelContainer != null) {
            this.kdLabelContainer.setBoundLabel(label);
        }
    }

    @Override
    public JLabel getBoundLabel() {
        if (this.kdLabelContainer != null) {
            return this.kdLabelContainer.getBoundLabel();
        }
        return null;
    }

    @Override
    public void setBoundLabelAlignment(int alignment) {
        if (this.kdLabelContainer != null) {
            this.kdLabelContainer.setBoundLabelAlignment(alignment);
        }
    }

    @Override
    public int getBoundLabelAlignment() {
        if (this.kdLabelContainer != null) {
            return this.kdLabelContainer.getBoundLabelAlignment();
        }
        return 7;
    }

    @Override
    public void setBoundLabelLength(int len) {
        if (this.kdLabelContainer != null) {
            this.kdLabelContainer.setBoundLabelLength(len);
        }
    }

    @Override
    public int getBoundLabelLength() {
        if (this.kdLabelContainer != null) {
            return this.kdLabelContainer.getBoundLabelLength();
        }
        return 0;
    }

    @Override
    public void setBoundLabelText(String labelText) {
        if (this.kdLabelContainer != null) {
            this.kdLabelContainer.setBoundLabelText(labelText);
        }
    }

    @Override
    public String getBoundLabelText() {
        if (this.kdLabelContainer != null) {
            return this.kdLabelContainer.getBoundLabelText();
        }
        return "";
    }

    @Override
    public void commitEdit() throws ParseException {
        ParseException pEx = null;
        try {
            super.commitEdit();
        }
        catch (ParseException p) {
            if (this.getDataVerifierType() == 1 || this.getDataVerifierType() == -1) {
                this.rollBack();
            }
            pEx = p;
        }
        if (pEx == null) {
            return;
        }
        if (this.getDataVerifierType() == 11 && this.defaultHandleKDComponentException != null && this.isFocusOwner()) {
            this.handleDefaultKDCompException(pEx, 0);
        }
        throw pEx;
    }

    private void handleDefaultKDCompException(final Exception pEx, int exType) {
        if (this.defaultHandleKDComponentException == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                KDFormattedTextField.this.defaultHandleKDComponentException.handleKDComponentExcepton(KDFormattedTextField.this, pEx, 0);
            }
        });
    }

    @Override
    public void setAllowdMouseProcessComponents(JComponent[] comps) {
        if (comps == null || comps.length == 0) {
            return;
        }
        int len = comps.length;
        if (this.allowedProcessMouseComps == null) {
            this.allowedProcessMouseComps = new JComponent[len];
            System.arraycopy(comps, 0, this.allowedProcessMouseComps, 0, len);
        } else {
            int len2 = this.allowedProcessMouseComps.length + len;
            JComponent[] tempComps = new JComponent[len2];
            System.arraycopy(this.allowedProcessMouseComps, 0, tempComps, 0, this.allowedProcessMouseComps.length);
            System.arraycopy(comps, 0, tempComps, this.allowedProcessMouseComps.length, len);
            this.allowedProcessMouseComps = new JComponent[len2];
            System.arraycopy(tempComps, 0, this.allowedProcessMouseComps, 0, len2);
            tempComps = null;
        }
    }

    @Override
    public boolean shouldProcessMouseOprt(JComponent comp) {
        if (this.allowedProcessMouseComps == null || this.allowedProcessMouseComps.length == 0) {
            return false;
        }
        if (comp != null) {
            int len = this.allowedProcessMouseComps.length;
            for (int i = 0; i < len; ++i) {
                if (this.allowedProcessMouseComps[i] != comp) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    protected void createDisEdiFormatterAgain(int propertyType) {
        this.createFormatterFactoryByDataType(this.getDataType());
    }

    protected NumberFormatter createDisplayFormatter(int newDataType) {
        DecimalFormatEx sysFormat = CtrlFormatUtilities.getDisplayNumberFormat();
        DecimalFormatEx format = null;
        format = this.isPercentDisplay() ? DecimalFormatEx.getPercentInstanceEx() : (sysFormat != null ? new DecimalFormatEx(sysFormat.toPattern()) : new DecimalFormatEx());
        format.setFormattedTextField(this);
        DecimalFormatSymbols symbols = CtrlFormatUtilities.getDecimalFormatSymbols();
        format.setDecimalFormatSymbols(symbols);
        format.setGroupingUsed(this.isGroupingUsed());
        NumberFormatterEx formatter = new NumberFormatterEx();
        formatter.setDecimalPrecision(this.getPrecision());
        format.setMaximumFractionDigits(this.getPrecision());
        formatter.setSupportedEmpty(this.isSupportedEmpty());
        formatter.setMaximum(this.getMaximumValue());
        formatter.setMinimum(this.getMinimumValue());
        if (!this.isRemoveingZeroInDispaly()) {
            format.setMinimumFractionDigits(this.getPrecision());
        }
        formatter.setRemoveingZero(this.isRemoveingZeroInDispaly());
        format.setRemovingMinus(this.isRemovingMinusInDisplay());
        this.exConfigDisFormat(format);
        formatter.setFormat(format);
        return formatter;
    }

    protected void exConfigDisFormat(DecimalFormat format) {
    }

    protected NumberFormatter createEditFormatter(int newDataType) {
        DecimalFormatEx sysFormat = CtrlFormatUtilities.getEditNumberFormat();
        DecimalFormatEx format = null;
        format = sysFormat == null ? new DecimalFormatEx() : new DecimalFormatEx(sysFormat.toPattern());
        NumberFormatterEx formatter = new NumberFormatterEx();
        format.setDecimalFormatSymbols(CtrlFormatUtilities.getDecimalFormatSymbols());
        format.setFormattedTextField(this);
        formatter.setDecimalPrecision(this.getPrecision());
        format.setMaximumFractionDigits(this.getPrecision());
        format.setGroupingUsed(false);
        formatter.setSupportedEmpty(this.isSupportedEmpty());
        if (this.getDataVerifierType() == 12) {
            formatter.setAllowsInvalid(false);
            formatter.setSupportedEmpty(false);
            format.setMinimumFractionDigits(this.getPrecision());
        } else {
            formatter.setAllowsInvalid(true);
        }
        formatter.setRemoveingZero(this.isRemoveingZeroInEdit());
        if (!this.isRemoveingZeroInEdit()) {
            format.setMinimumFractionDigits(this.getPrecision());
        }
        formatter.setMaximum(this.getMaximumValue());
        formatter.setMinimum(this.getMinimumValue());
        formatter.setCommitsOnValidEdit(this.isCommitsOnValidEdit());
        formatter.setSupportedEmpty(this.isSupportedEmpty());
        this.exConfigEditFormat(format);
        formatter.setFormat(format);
        return formatter;
    }

    protected void exConfigEditFormat(DecimalFormat format) {
    }

    public boolean isCommitsOnValidEdit() {
        return this.isCommitsOnValidEdit;
    }

    public void setCommitsOnValidEdit(boolean newValue) {
        boolean old = this.isCommitsOnValidEdit;
        if (old != newValue) {
            this.isCommitsOnValidEdit = newValue;
            if (this.isImmediatelyValidate()) {
                this.createDisEdiFormatterAgain(66);
            }
        }
    }

    public boolean isSupportedEmpty() {
        return this.isSupportedEmpty;
    }

    public void setSupportedEmpty(boolean newValue) {
        boolean old = this.isSupportedEmpty;
        if (old != newValue) {
            this.isSupportedEmpty = newValue;
            if (this.isImmediatelyValidate()) {
                this.createDisEdiFormatterAgain(67);
            }
        }
    }

    public NumberFeatureMode getNumberFeatureMode() {
        if (this.numberFeatureMode == null) {
            this.numberFeatureMode = this.createNumberFeatureMode();
            if (this.innerPropertyListener == null) {
                this.innerPropertyListener = new InnerPropertyChangeListener();
            } else {
                this.numberFeatureMode.removeProtyListener(this.innerPropertyListener);
            }
            this.numberFeatureMode.addPropertyListener(this.innerPropertyListener);
        }
        return this.numberFeatureMode;
    }

    protected NumberFeatureMode createNumberFeatureMode() {
        return new NumberFeatureMode();
    }

    public void setEditingText(String t) {
        super.setText(t);
    }

    public void setCustomInsets(Insets newValue) {
        this.customInsets = newValue;
    }

    @Override
    public Insets getInsets() {
        if (this.customInsets != null) {
            return this.customInsets;
        }
        return super.getInsets();
    }

    private void rollBack() {
        JFormattedTextField.AbstractFormatterFactory factory = this.getFormatterFactory();
        JFormattedTextField.AbstractFormatter atf = factory != null ? factory.getFormatter(this) : null;
        this.setFormatter(atf);
    }

    public void reInstallEditFormater() {
        JFormattedTextField.AbstractFormatterFactory factory = this.getFormatterFactory();
        if (factory instanceof DefaultFormatterFactory) {
            DefaultFormatterFactory f = (DefaultFormatterFactory)factory;
            this.setFormatter(f.getEditFormatter());
        }
    }

    private void superPrecision(int precision) {
        if (this.superPrecision && precision > 10 && this.precision != precision) {
            this.precision = precision;
            this.setFormatterFactory(this.createDisplayFormatter(this.dataType), this.createEditFormatter(this.dataType));
        }
    }

    public class RedoAction
    extends AbstractAction {
        private static final long serialVersionUID = -142051817545978955L;

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                if (KDFormattedTextField.this.manager.canRedo()) {
                    KDFormattedTextField.this.manager.redo();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public class UndoAction
    extends AbstractAction {
        private static final long serialVersionUID = 717256882077591283L;

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                if (KDFormattedTextField.this.manager.canUndo()) {
                    KDFormattedTextField.this.manager.undo();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private class InnerPropertyChangeListener
    implements PropertyChangeListener {
        private InnerPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if (name.equals("nfmDisGroupingUsed")) {
                if (KDFormattedTextField.this.isImmediatelyValidate()) {
                    KDFormattedTextField.this.createDisEdiFormatterAgain(57);
                }
                return;
            }
            if (name.equals("nfmDisPercentingUsed")) {
                if (KDFormattedTextField.this.isImmediatelyValidate()) {
                    KDFormattedTextField.this.createDisEdiFormatterAgain(60);
                }
                return;
            }
            if (name.equals("nfmEdiGroupingUsed")) {
                if (KDFormattedTextField.this.isImmediatelyValidate()) {
                    KDFormattedTextField.this.createDisEdiFormatterAgain(58);
                }
                return;
            }
            if (name.equals("nfmEdiPercentingUsed")) {
                if (KDFormattedTextField.this.isImmediatelyValidate()) {
                    KDFormattedTextField.this.createDisEdiFormatterAgain(61);
                }
                return;
            }
            if (name.equals("nfmGroupingSize")) {
                if (KDFormattedTextField.this.isImmediatelyValidate()) {
                    KDFormattedTextField.this.createDisEdiFormatterAgain(59);
                }
                return;
            }
            if (name.equals("nfmRemoveingZeroInDispaly")) {
                if (KDFormattedTextField.this.isImmediatelyValidate()) {
                    KDFormattedTextField.this.createDisEdiFormatterAgain(63);
                }
                return;
            }
            if (name.equals("nfmRemoveingZeroInEdit")) {
                if (KDFormattedTextField.this.isImmediatelyValidate()) {
                    KDFormattedTextField.this.createDisEdiFormatterAgain(64);
                }
                return;
            }
            if (name.equals("nfmRemovingMinusInDisplay") && KDFormattedTextField.this.isImmediatelyValidate()) {
                KDFormattedTextField.this.createDisEdiFormatterAgain(70);
            }
        }
    }

    public class FormattedTextFieldVerifier
    extends InputVerifier {
        @Override
        public boolean verify(JComponent input) {
            if (KDFormattedTextField.this.getDataVerifierType() != 11) {
                return true;
            }
            boolean b = true;
            try {
                JFormattedTextField.AbstractFormatter formater = KDFormattedTextField.this.getFormatter();
                if (formater != null) {
                    formater.stringToValue(KDFormattedTextField.this.getText());
                }
            }
            catch (ParseException e) {
                b = false;
            }
            if (!b) {
                ((JFormattedTextField)input).selectAll();
            } else {
                ((JFormattedTextField)input).select(0, 0);
            }
            return b;
        }

        @Override
        public boolean shouldYieldFocus(JComponent input) {
            return this.verify(input);
        }
    }

    class DataPropertyChangeListener
    implements PropertyChangeListener {
        DataPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            Object newVa;
            Object oldVa;
            String name = e.getPropertyName();
            if ("value".equals(name) && CtrlSwingUtilities.judgeNumberObject(oldVa = e.getOldValue(), newVa = e.getNewValue()) != 0) {
                KDFormattedTextField.this.fireDataChangeListener(new DataChangeEvent(KDFormattedTextField.this, newVa, oldVa));
            }
        }
    }
}

