/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing;

import com.kingdee.bos.ctrl.common.util.STConverter;
import com.kingdee.bos.ctrl.swing.IToolMenuBar;
import com.kingdee.bos.ctrl.swing.KDDebugPane;
import com.kingdee.bos.ctrl.swing.KDSkinRootPane;
import com.kingdee.bos.ctrl.swing.KDStatusBar;
import com.kingdee.bos.ctrl.swing.RecordChecker;
import com.kingdee.bos.ctrl.swing.helper.KDHelperBar;
import com.kingdee.bos.ctrl.swing.palette.PaletteFrame;
import java.awt.GraphicsConfiguration;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.lang.reflect.Field;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.UIManager;

public class KDFrame
extends JFrame
implements IToolMenuBar {
    private static boolean alreadyInitEasterEgg = true;
    private boolean firstShow = true;
    private static KDFrame frame;
    private static final long serialVersionUID = 7435424443702574540L;
    static boolean IS_OPEN;

    public KDFrame() {
        this.init();
    }

    public KDFrame(GraphicsConfiguration gc) {
        super(gc);
        this.init();
    }

    public KDFrame(String title) {
        super(title);
        this.setTitle(title);
        this.init();
    }

    public KDFrame(String title, GraphicsConfiguration gc) {
        super(title, gc);
        this.setTitle(title);
        this.init();
    }

    @Override
    public void setTitle(String title) {
        if (title == null) {
            title = "";
        }
        String os = System.getProperty("os.name");
        String encodingStr = System.getProperty("file.encoding");
        if ((os.equals("Windows 98") || os.equals("Windows Me")) && (encodingStr.equals("MS950") || encodingStr.equals("Big5"))) {
            title = STConverter.sc2tc((String)title);
        }
        super.setTitle(title);
    }

    private void init() {
        ImageIcon icon = (ImageIcon)UIManager.getIcon("Frame.Icon");
        if (icon == null) {
            this.setIconImage(null);
        } else {
            this.setIconImage(icon.getImage());
        }
        if (alreadyInitEasterEgg) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new EggKeyEventDispatcher());
            alreadyInitEasterEgg = false;
        }
    }

    @Override
    public void show() {
        if (this.firstShow) {
            KDDebugPane.register(this, KeyStroke.getKeyStroke(68, 576));
            this.firstShow = false;
        }
        long startTime = System.currentTimeMillis();
        RecordChecker.setStartTimeForUtil(startTime);
        super.show();
        this.requestFocus();
        long endTime = System.currentTimeMillis();
        RecordChecker.setEndTimeForUtil(startTime, endTime);
    }

    void fireWindowEventByEscKey(WindowEvent we) {
        this.processWindowEvent(we);
    }

    @Override
    public void addToolBar(JToolBar toolBar, int orientation) {
        if (this.getSkinRootPane() != null) {
            this.getSkinRootPane().addToolBar(toolBar, orientation);
        } else {
            this.throwSkingRootPaneExcepton();
        }
    }

    @Override
    public void addToolBar(JToolBar toolBar, int orientation, Object identify) {
        if (this.getSkinRootPane() != null) {
            this.getSkinRootPane().addToolBar(toolBar, orientation, identify);
        } else {
            this.throwSkingRootPaneExcepton();
        }
    }

    @Override
    public void addToolBar(JToolBar toolBar) {
        this.addToolBar(toolBar, 1);
    }

    @Override
    public void addToolBar(JToolBar toolBar, Object identify) {
        this.addToolBar(toolBar, 1, identify);
    }

    @Override
    public void removeToolBar(JToolBar toolbar) {
        if (this.getSkinRootPane() != null) {
            this.getSkinRootPane().removeToolBar(toolbar);
        } else {
            this.throwSkingRootPaneExcepton();
        }
    }

    @Override
    public void removeToolBarByIdentify(Object identify) {
        if (this.getSkinRootPane() != null) {
            this.getSkinRootPane().removeToolBarByIdentify(identify);
        } else {
            this.throwSkingRootPaneExcepton();
        }
    }

    @Override
    public void removeAllToolBar() {
        if (this.getSkinRootPane() != null) {
            this.getSkinRootPane().removeAllToolBar();
        } else {
            this.throwSkingRootPaneExcepton();
        }
    }

    @Override
    public JToolBar[] getToolBars() {
        if (this.getSkinRootPane() != null) {
            return this.getSkinRootPane().getToolBars();
        }
        this.throwSkingRootPaneExcepton();
        return null;
    }

    @Override
    public JToolBar getToolBar(Object identify) {
        if (this.getSkinRootPane() != null) {
            return this.getSkinRootPane().getToolBar(identify);
        }
        this.throwSkingRootPaneExcepton();
        return null;
    }

    @Override
    public KDStatusBar getStatusBar() {
        if (this.getSkinRootPane() != null) {
            return this.getSkinRootPane().getStatusBar();
        }
        this.throwSkingRootPaneExcepton();
        return null;
    }

    @Override
    public void setStatusBar(KDStatusBar statusBar) {
        if (this.getSkinRootPane() != null) {
            this.getSkinRootPane().setStatusBar(statusBar);
        } else {
            this.throwSkingRootPaneExcepton();
        }
    }

    public void setHelperBar(KDHelperBar helperBar) {
        if (this.getSkinRootPane() != null) {
            this.getSkinRootPane().setHelperBar(helperBar);
        } else {
            this.throwSkingRootPaneExcepton();
        }
    }

    public void removeHelperBar(KDHelperBar helperBar) {
        if (this.getSkinRootPane() != null) {
            this.getSkinRootPane().removeHelperBar(helperBar);
        } else {
            this.throwSkingRootPaneExcepton();
        }
    }

    @Override
    public void removeStatusBar(KDStatusBar statusBar) {
        if (this.getSkinRootPane() != null) {
            this.getSkinRootPane().removeStatusBar(statusBar);
        } else {
            this.throwSkingRootPaneExcepton();
        }
    }

    @Override
    public void removeAllStatusBar() {
        if (this.getSkinRootPane() != null) {
            this.getSkinRootPane().removeAllStatusBar();
        }
    }

    @Override
    protected JRootPane createRootPane() {
        return new KDSkinRootPane();
    }

    @Override
    public void removeJMenuBar(JMenuBar menuBar) {
        if (this.getSkinRootPane() != null) {
            this.getSkinRootPane().removeJMenuBar(menuBar);
        } else {
            this.throwSkingRootPaneExcepton();
        }
    }

    @Override
    public void setToolBarIdentify(JToolBar toolBar, Object identify) {
        if (this.getSkinRootPane() != null) {
            this.getSkinRootPane().setToolBarIdentify(toolBar, identify);
        } else {
            this.throwSkingRootPaneExcepton();
        }
    }

    protected KDSkinRootPane getSkinRootPane() {
        JRootPane jRootPane = super.getRootPane();
        if (jRootPane instanceof KDSkinRootPane) {
            return (KDSkinRootPane)jRootPane;
        }
        return null;
    }

    private void throwSkingRootPaneExcepton() {
        throw new IllegalArgumentException("KDSkinRootPane is null,please setting the KDSkinRootPane to the KDFrame.");
    }

    public static final boolean closeSunInputMethodComposer() {
        IS_OPEN = false;
        return KDFrame.dealWithSunInputMethodComposer(false);
    }

    public static final boolean openSunInputMethodComposer() {
        IS_OPEN = true;
        return KDFrame.dealWithSunInputMethodComposer(true);
    }

    protected static boolean dealWithSunInputMethodComposer(boolean isOpen) {
        boolean ret = true;
        try {
            Class<?> clazz = Class.forName("sun.awt.im.InputMethodContext");
            Field f = clazz.getDeclaredField("belowTheSpotInputRequested");
            f.setAccessible(true);
            f.set(clazz, new Boolean(isOpen));
            f.setAccessible(false);
        }
        catch (Throwable th) {
            th.printStackTrace();
            ret = false;
        }
        return ret;
    }

    static {
        IS_OPEN = true;
    }

    public static class EggKeyEventDispatcher
    implements KeyEventDispatcher {
        @Override
        public boolean dispatchKeyEvent(KeyEvent e) {
            if (e.isAltDown() && e.isShiftDown() && e.getKeyCode() == 85) {
                if (frame == null) {
                    frame = (KDFrame)new PaletteFrame();
                }
                frame.setLocationRelativeTo(null);
                frame.setVisible(true);
                return true;
            }
            return false;
        }
    }
}

