/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.swing.CtrlPlainDocument;
import com.kingdee.bos.ctrl.swing.IBoundLabelControl;
import com.kingdee.bos.ctrl.swing.ICtrTextDocumentFilter;
import com.kingdee.bos.ctrl.swing.IKDComponent;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.MaskFormatterEx;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.Format;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.Document;
import javax.swing.undo.UndoManager;

public class KDMaskTextField
extends JFormattedTextField
implements IKDComponent,
IBoundLabelControl {
    private static final long serialVersionUID = 9199858813572828234L;
    private Object userObject = null;
    protected KDLabelContainer kdLabelContainer;
    private boolean isDigit = false;
    private boolean isLetter = false;
    private boolean allowsInvalid = false;
    private String mask = null;
    private String validCharacters = null;
    private String invalidCharacters = null;
    private int maskPosition = 4;
    private int charsCount = -1;
    private PropertyChangeListener dataChangePropertyHandler = null;
    private Insets customInsets;
    public static final String undoAction = "undo-MaskTextField";
    public static final String redoAction = "redo-MaskTextField";
    public UndoManager manager = null;

    @Override
    public void setUserObject(Object newUserObject) {
        this.userObject = newUserObject;
    }

    @Override
    public Object getUserObject() {
        return this.userObject;
    }

    public void setCustomInsets(Insets newValue) {
        this.customInsets = newValue;
    }

    @Override
    public Insets getInsets() {
        if (this.customInsets != null) {
            return this.customInsets;
        }
        return super.getInsets();
    }

    public KDMaskTextField() {
        this.init();
    }

    public KDMaskTextField(Object value) {
        super(value);
        this.init();
        this.setValue(value);
    }

    public KDMaskTextField(Format format) {
        super(format);
    }

    public KDMaskTextField(JFormattedTextField.AbstractFormatter formatter) {
        super(formatter);
    }

    public KDMaskTextField(JFormattedTextField.AbstractFormatterFactory factory) {
        super(factory);
    }

    public KDMaskTextField(JFormattedTextField.AbstractFormatterFactory factory, Object currentValue) {
        super(factory, currentValue);
    }

    protected void init() {
        CtrlPlainDocument numberDocument = new CtrlPlainDocument();
        MaskCtrTextDocumentFilter ctrlTextDocuFilter = new MaskCtrTextDocumentFilter();
        numberDocument.setCtrTextDocumentFilter(ctrlTextDocuFilter);
        this.setDocument(numberDocument);
        this.setFormatterFactory(this.createDisplayFormatter(null), this.createEditFormatter(null));
        if (this.dataChangePropertyHandler != null) {
            this.removePropertyChangeListener("value", this.dataChangePropertyHandler);
            this.dataChangePropertyHandler = null;
        } else {
            this.dataChangePropertyHandler = new DataPropertyChangeListener();
        }
        this.addPropertyChangeListener("value", this.dataChangePropertyHandler);
        if (this.manager == null) {
            this.manager = new UndoManager();
        }
        this.getDocument().addUndoableEditListener(this.manager);
        InputMap inputMap = this.getInputMap();
        ActionMap actionMap = this.getActionMap();
        KeyStroke newKeyStroke = KeyStroke.getKeyStroke(90, 2, false);
        inputMap.put(newKeyStroke, undoAction);
        newKeyStroke = KeyStroke.getKeyStroke(89, 2, false);
        inputMap.put(newKeyStroke, redoAction);
        actionMap.put(undoAction, new UndoAction());
        actionMap.put(redoAction, new RedoAction());
    }

    @Override
    protected void processFocusEvent(FocusEvent e) {
        Document document = this.getDocument();
        if (document != null && document instanceof CtrlPlainDocument) {
            if (e.getID() == 1005) {
                ((CtrlPlainDocument)document).setFocusing(false);
            } else {
                ((CtrlPlainDocument)document).setFocusing(true);
            }
        }
        super.processFocusEvent(e);
    }

    public void setCtrlTextDocumentFilter(ICtrTextDocumentFilter newValue) {
        Document document = this.getDocument();
        if (document != null && document instanceof CtrlPlainDocument) {
            ((CtrlPlainDocument)document).setCtrTextDocumentFilter(newValue);
        }
    }

    public ICtrTextDocumentFilter getCtrlTextDocumentFilter() {
        Document document = this.getDocument();
        if (document != null && document instanceof CtrlPlainDocument) {
            return ((CtrlPlainDocument)document).getCtrTextDocumentFilter();
        }
        return null;
    }

    protected JFormattedTextField.AbstractFormatter createDisplayFormatter(Object param) {
        MaskFormatterEx disFormatter = new MaskFormatterEx();
        disFormatter.setAllowsInvalid(true);
        disFormatter.setOverwriteMode(false);
        return disFormatter;
    }

    protected JFormattedTextField.AbstractFormatter createEditFormatter(Object param) {
        MaskFormatterEx ediFormatter = new MaskFormatterEx();
        ediFormatter.setAllowsInvalid(true);
        ediFormatter.setOverwriteMode(false);
        return ediFormatter;
    }

    public JFormattedTextField.AbstractFormatter getDispalyFormatter() {
        JFormattedTextField.AbstractFormatterFactory formatterFactory = this.getFormatterFactory();
        if (formatterFactory != null && formatterFactory instanceof DefaultFormatterFactory) {
            return ((DefaultFormatterFactory)formatterFactory).getDisplayFormatter();
        }
        return null;
    }

    public JFormattedTextField.AbstractFormatter getEditFormatter() {
        JFormattedTextField.AbstractFormatterFactory formatterFactory = this.getFormatterFactory();
        if (formatterFactory != null && formatterFactory instanceof DefaultFormatterFactory) {
            return ((DefaultFormatterFactory)formatterFactory).getEditFormatter();
        }
        return null;
    }

    private void setFormatterFactory(JFormattedTextField.AbstractFormatter disFormatter, JFormattedTextField.AbstractFormatter ediFormatter) {
        JFormattedTextField.AbstractFormatterFactory formatterFactory = this.getFormatterFactory();
        if (formatterFactory == null) {
            formatterFactory = new DefaultFormatterFactory();
        }
        boolean b = false;
        if (disFormatter != null) {
            ((DefaultFormatterFactory)formatterFactory).setDisplayFormatter(disFormatter);
            b = true;
        }
        if (ediFormatter != null) {
            ((DefaultFormatterFactory)formatterFactory).setEditFormatter(ediFormatter);
            b = true;
        }
        if (b) {
            this.setFormatterFactory(formatterFactory);
        }
    }

    protected void setEditFormatter(JFormattedTextField.AbstractFormatter newValue) {
        if (newValue != null) {
            this.setFormatterFactory(null, newValue);
        }
    }

    protected void setDisplayFormatter(JFormattedTextField.AbstractFormatter newValue) {
        if (newValue != null) {
            this.setFormatterFactory(newValue, null);
        }
    }

    public void setMask(String newValue) {
        String old = this.mask;
        if (!StringUtil.equals((String)old, (String)newValue)) {
            this.mask = newValue;
            this.analysisMask(this.mask);
        }
    }

    public String getMask() {
        return this.mask;
    }

    public void setValidCharacters(String newValue) {
        String old = this.validCharacters;
        if (!StringUtil.equals((String)old, (String)newValue)) {
            this.validCharacters = newValue;
        }
    }

    public String getValidCharacters() {
        return this.validCharacters;
    }

    public void setInvalidCharacters(String newValue) {
        String old = this.invalidCharacters;
        if (!StringUtil.equals((String)old, (String)newValue)) {
            this.invalidCharacters = newValue;
        }
    }

    public String getInvalidCharacters() {
        return this.invalidCharacters;
    }

    public void setAllowsInvalid(boolean newValue) {
        boolean old = this.allowsInvalid;
        if (old != newValue) {
            this.allowsInvalid = newValue;
        }
    }

    public boolean getAllowsInvalid() {
        return this.allowsInvalid;
    }

    public String getStringValue() {
        Object obj = this.getValue();
        if (obj != null) {
            return obj instanceof String ? (String)obj : obj.toString();
        }
        return null;
    }

    public void setStringValue(String val) {
        this.setValue(val);
    }

    @Override
    public void setLabelContainer(KDLabelContainer kdLabelContainer) {
        this.kdLabelContainer = kdLabelContainer;
    }

    @Override
    public KDLabelContainer getLabelContainer() {
        return this.kdLabelContainer;
    }

    @Override
    public void setBoundLabel(JLabel label) {
        if (this.kdLabelContainer != null) {
            this.kdLabelContainer.setBoundLabel(label);
        }
    }

    @Override
    public JLabel getBoundLabel() {
        if (this.kdLabelContainer != null) {
            return this.kdLabelContainer.getBoundLabel();
        }
        return null;
    }

    @Override
    public void setBoundLabelAlignment(int alignment) {
        if (this.kdLabelContainer != null) {
            this.kdLabelContainer.setBoundLabelAlignment(alignment);
        }
    }

    @Override
    public int getBoundLabelAlignment() {
        if (this.kdLabelContainer != null) {
            return this.kdLabelContainer.getBoundLabelAlignment();
        }
        return 7;
    }

    @Override
    public void setBoundLabelLength(int len) {
        if (this.kdLabelContainer != null) {
            this.kdLabelContainer.setBoundLabelLength(len);
        }
    }

    @Override
    public int getBoundLabelLength() {
        if (this.kdLabelContainer != null) {
            return this.kdLabelContainer.getBoundLabelLength();
        }
        return 0;
    }

    @Override
    public void setBoundLabelText(String labelText) {
        if (this.kdLabelContainer != null) {
            this.kdLabelContainer.setBoundLabelText(labelText);
        }
    }

    @Override
    public String getBoundLabelText() {
        if (this.kdLabelContainer != null) {
            return this.kdLabelContainer.getBoundLabelText();
        }
        return "";
    }

    public boolean isDigit() {
        return this.isDigit;
    }

    public void setDigit(boolean newValue) {
        boolean old = this.isDigit;
        if (old != newValue) {
            this.isDigit = newValue;
        }
    }

    public boolean isLetter() {
        return this.isLetter;
    }

    public void setLetter(boolean newValue) {
        boolean old = this.isLetter;
        if (old != newValue) {
            this.isLetter = newValue;
        }
    }

    public int getCharsCount() {
        return this.charsCount;
    }

    public void setCharsCount(int newValue) {
        int old = this.charsCount;
        if (old != newValue) {
            this.charsCount = newValue;
            this.getCtrlTextDocumentFilter().setValidLength(this.charsCount);
        }
    }

    public void addDataChangeListener(DataChangeListener l) {
        this.listenerList.add(DataChangeListener.class, l);
    }

    public void removeDataChangeListener(DataChangeListener l) {
        this.listenerList.remove(DataChangeListener.class, l);
    }

    protected void fireDataChangeListener(DataChangeEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DataChangeListener.class || event == null) continue;
            ((DataChangeListener)listeners[i + 1]).dataChanged(event);
        }
    }

    private void dataChangeOprt(Object oldVa, Object newVa) {
        DataChangeEvent event = new DataChangeEvent(this, newVa, oldVa);
        this.fireDataChangeListener(event);
    }

    protected boolean isValidateStr(String str) {
        return StringUtil.isValidateStr((String)str, (boolean)this.isDigit(), (boolean)this.isLetter(), (String)this.getValidCharacters(), (String)this.getInvalidCharacters(), (int)this.getCharsCount());
    }

    protected void analysisMask(String mask) {
    }

    public int getMaskPosition() {
        return this.maskPosition;
    }

    public void setMaskPosition(int newValue) {
        this.maskPosition = newValue == 4 || newValue == 2 ? newValue : 4;
    }

    public class RedoAction
    extends AbstractAction {
        private static final long serialVersionUID = -7125369341905036690L;

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                if (KDMaskTextField.this.manager.canRedo()) {
                    KDMaskTextField.this.manager.redo();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public class UndoAction
    extends AbstractAction {
        private static final long serialVersionUID = 8709850897208279962L;

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                if (KDMaskTextField.this.manager.canUndo()) {
                    KDMaskTextField.this.manager.undo();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    class DataPropertyChangeListener
    implements PropertyChangeListener {
        DataPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            Object newVa;
            Object oldVa;
            String name = e.getPropertyName();
            if ("value".equals(name) && !StringUtil.equals((String)((String)(oldVa = e.getOldValue())), (String)((String)(newVa = e.getNewValue())))) {
                KDMaskTextField.this.dataChangeOprt(oldVa, newVa);
            }
        }
    }

    class MaskCtrTextDocumentFilter
    implements ICtrTextDocumentFilter {
        private int validLen = -1;

        MaskCtrTextDocumentFilter() {
        }

        @Override
        public boolean isValidateStr(String str) {
            return KDMaskTextField.this.isValidateStr(str);
        }

        @Override
        public void setValidateStr(String newValue) {
        }

        @Override
        public String getValidateStr() {
            return null;
        }

        @Override
        public boolean isValidLength(Document doc) {
            if (this.validLen > 0 && doc != null) {
                return this.validLen > doc.getLength();
            }
            return true;
        }

        @Override
        public void setValidLength(int len) {
            this.validLen = len;
        }
    }
}

