/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing;

import com.kingdee.bos.ctrl.swing.ButtonActionPropertyListenerEx;
import com.kingdee.bos.ctrl.swing.ButtonPropertyConfigurer;
import com.kingdee.bos.ctrl.swing.IKDComponent;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class KDMenuItem
extends JMenuItem
implements IKDComponent {
    private static final long serialVersionUID = 7547746744868222720L;
    protected Object userObject = null;

    public KDMenuItem() {
    }

    public KDMenuItem(Icon icon) {
        super(icon);
    }

    public KDMenuItem(String text) {
        super(text);
    }

    public KDMenuItem(Action a) {
        super(a);
    }

    public KDMenuItem(String text, Icon icon) {
        super(text, icon);
    }

    public KDMenuItem(String text, int mnemonic) {
        super(text, mnemonic);
    }

    @Override
    public Object getUserObject() {
        return this.userObject;
    }

    @Override
    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public void setCustomAction(Action a) {
        String text = this.getText();
        int mnemonic = this.getMnemonic();
        super.setAction(a);
        if (a != null) {
            if (a.getValue("Name") == null) {
                this.setText(text);
            }
            if (a.getValue("MnemonicKey") == null) {
                this.setMnemonic(mnemonic);
            }
        }
    }

    @Override
    public Icon getIcon() {
        return super.getIcon();
    }

    @Override
    public void setToolTipText(String text) {
    }

    @Override
    protected PropertyChangeListener createActionPropertyChangeListener(Action a) {
        return new ButtonActionPropertyListenerEx(this, a){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                String propertyName = e.getPropertyName();
                JMenuItem mi = (JMenuItem)this.getTarget();
                if (mi == null) {
                    Action action = (Action)e.getSource();
                    action.removePropertyChangeListener(this);
                } else if (e.getPropertyName().equals("Name")) {
                    String text = (String)e.getNewValue();
                    if (text != null && text.length() > 0) {
                        mi.setText(text);
                        mi.repaint();
                    }
                } else if (propertyName.equals("enabled")) {
                    Boolean enabledState = (Boolean)e.getNewValue();
                    mi.setEnabled(enabledState);
                    mi.repaint();
                } else if (e.getPropertyName().equals("SmallIcon")) {
                    Icon icon = (Icon)e.getNewValue();
                    mi.setIcon(icon);
                    mi.invalidate();
                    mi.repaint();
                } else if (e.getPropertyName().equals("MnemonicKey")) {
                    Integer mn = (Integer)e.getNewValue();
                    mi.setMnemonic(mn);
                    mi.invalidate();
                    mi.repaint();
                } else if (propertyName.equals("visible")) {
                    Boolean visibleState = (Boolean)e.getNewValue();
                    mi.setVisible(visibleState);
                }
            }
        };
    }

    @Override
    protected void configurePropertiesFromAction(Action a) {
        ButtonPropertyConfigurer.configure(this, a);
        KeyStroke ks = a == null ? null : (KeyStroke)a.getValue("AcceleratorKey");
        this.setAccelerator(ks == null ? null : ks);
    }

    protected class SelfImageIcon
    extends ImageIcon {
        private static final long serialVersionUID = -6077439610265865045L;
        private Icon tempIcon = null;

        public SelfImageIcon(Icon imageIcon) {
            this(imageIcon, 1);
        }

        public SelfImageIcon(Icon icon, int mode) {
            this.tempIcon = icon;
        }

        @Override
        public Image getImage() {
            if (this.tempIcon instanceof ImageIcon) {
                return ((ImageIcon)this.tempIcon).getImage();
            }
            return null;
        }

        @Override
        public synchronized void paintIcon(Component c, Graphics g, int x, int y) {
            this.tempIcon.paintIcon(c, g, 4, 0);
        }
    }
}

