/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing;

import com.kingdee.bos.ctrl.swing.ISimpleStatusBarRenderer;
import com.kingdee.bos.ctrl.swing.SimpleStatusBarPart;
import com.kingdee.bos.ctrl.swing.plaf.KingdeeStatusBarUI;
import java.awt.Component;
import java.awt.Insets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class KDStatusBar
extends JComponent {
    private static final long serialVersionUID = 4790609697410100317L;
    private static final String uiClassID = "StatusBarUI";
    private StatusBarAssign statusBarAssign = null;
    private float partAlignment = 0.0f;
    private Insets customInsets;

    public KDStatusBar() {
        this(0.0f);
    }

    public KDStatusBar(float partAlignment) {
        this.partAlignment = partAlignment;
        this.updateUI();
    }

    public void setCustomInsets(Insets newValue) {
        this.customInsets = newValue;
    }

    @Override
    public Insets getInsets() {
        if (this.customInsets != null) {
            return this.customInsets;
        }
        return super.getInsets();
    }

    public void addRendererToPart(ISimpleStatusBarRenderer renderer, Object identify, int partIndex) {
        if (renderer == null) {
            return;
        }
        int count = this.getComponentCount();
        if (partIndex < 0 || partIndex >= count) {
            throw new ArrayIndexOutOfBoundsException("partIndex " + partIndex + " is out of bounds,can not find one SimpleStatusBarPart.");
        }
        SimpleStatusBarPart part = null;
        try {
            part = this.getPart(partIndex);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        if (part == null) {
            throw new ArrayIndexOutOfBoundsException("partIndex " + partIndex + " is out of bounds,can not find one SimpleStatusBarPart.");
        }
        part.addRenderer(renderer, identify);
    }

    public void addPart(SimpleStatusBarPart part) {
        this.add(part);
        part.setStatusBar(this);
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        if (!(comp instanceof SimpleStatusBarPart)) {
            throw new IllegalArgumentException("comp is not com.kingdee.bos.ctrl.swing.SimpleStatusBarPart");
        }
        super.addImpl(comp, constraints, index);
    }

    public void setPartAlignment(float align) {
        if (align != 0.0f && align != 1.0f) {
            throw new IllegalArgumentException("align argument is error.");
        }
        float old = this.getPartAlignment();
        if (align != this.partAlignment) {
            this.partAlignment = align;
            this.firePropertyChange("partAlignment", new Float(old), new Float(align));
        }
    }

    public float getPartAlignment() {
        return this.partAlignment;
    }

    public SimpleStatusBarPart getPart(int index) {
        return (SimpleStatusBarPart)this.getComponent(index);
    }

    public SimpleStatusBarPart[] getAllPart() {
        return (SimpleStatusBarPart[])this.getComponents();
    }

    public ISimpleStatusBarRenderer[] getAllRenderer() {
        int count = this.getComponentCount();
        ArrayList<ISimpleStatusBarRenderer> al = new ArrayList<ISimpleStatusBarRenderer>();
        int idx = 0;
        for (int i = 0; i < count; ++i) {
            Component comp = this.getComponent(i);
            if (!comp.isVisible() || !(comp instanceof SimpleStatusBarPart)) continue;
            int cc = ((SimpleStatusBarPart)comp).getComponentCount();
            for (int j = 0; j < cc; ++j) {
                ISimpleStatusBarRenderer render = ((SimpleStatusBarPart)comp).getRenderer(j);
                if (render == null) continue;
                al.add(idx, render);
                ++idx;
            }
        }
        if (al.size() > 0) {
            return (ISimpleStatusBarRenderer[])al.toArray();
        }
        return null;
    }

    public ISimpleStatusBarRenderer getRenderer(Object identify) {
        return this.getStatusBarAssign().getRenderer(identify);
    }

    public Object getRendererIdentify(ISimpleStatusBarRenderer renderer) {
        return this.getStatusBarAssign().getIdentify(renderer);
    }

    public void setRendererText(String text, Object identifyOfRenderer) {
        ISimpleStatusBarRenderer renderer = this.getStatusBarAssign().getRenderer(identifyOfRenderer);
        if (renderer == null) {
            throw new IllegalArgumentException("do not exist [" + identifyOfRenderer + "] ISimpleStatusBarRenderer among the KDStatusBar.");
        }
        renderer.setText(text);
    }

    public void setRendererIdentify(ISimpleStatusBarRenderer renderer, Object identify) {
        this.getStatusBarAssign().setRendererIdentify(renderer, identify);
    }

    StatusBarAssign getStatusBarAssign() {
        if (this.statusBarAssign == null) {
            this.statusBarAssign = new StatusBarAssign();
        }
        return this.statusBarAssign;
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public KingdeeStatusBarUI getUI() {
        return (KingdeeStatusBarUI)this.ui;
    }

    @Override
    public void updateUI() {
        this.setUI((KingdeeStatusBarUI)UIManager.getUI(this));
    }

    public void setUI(KingdeeStatusBarUI ui) {
        super.setUI(ui);
    }

    public void setRetractablePart(int index, boolean newValue) {
        SimpleStatusBarPart part = this.getPart(index);
        if (part != null) {
            part.setRetractable(newValue);
        }
    }

    static {
        UIManager.getDefaults().put(uiClassID, "com.kingdee.bos.ctrl.swing.plaf.KingdeeStatusBarUI");
    }

    static class StatusBarAssign
    implements Serializable {
        private static final long serialVersionUID = 2709267342799271425L;
        Hashtable hash = new Hashtable(0);

        public void setRendererIdentify(ISimpleStatusBarRenderer renderer, Object identify) {
            if (renderer == null || identify == null) {
                throw new NullPointerException("ISimpleStatusBarRenderer or idnetify is null.");
            }
            if (this.getHashRender().containsKey(identify)) {
                if (this.getHashRender().get(identify) != renderer) {
                    throw new IllegalArgumentException("identify of ISimpleStatusBarRenderer doesn't is uniquely,it was defined.");
                }
            } else if (this.getHashRender().containsValue(renderer)) {
                Enumeration keys = this.getHashRender().keys();
                while (keys.hasMoreElements()) {
                    Object tempKey = keys.nextElement();
                    if (this.getHashRender().get(tempKey) != renderer) continue;
                    this.getHashRender().remove(tempKey);
                    this.getHashRender().put(identify, renderer);
                    break;
                }
            } else {
                this.getHashRender().put(identify, renderer);
            }
        }

        public ISimpleStatusBarRenderer getRenderer(Object identify) {
            if (identify == null) {
                return null;
            }
            return (ISimpleStatusBarRenderer)this.getHashRender().get(identify);
        }

        public Object getIdentify(ISimpleStatusBarRenderer render) {
            Enumeration keys = this.getHashRender().keys();
            while (keys.hasMoreElements()) {
                Object tempKey = keys.nextElement();
                if (this.getHashRender().get(tempKey) != render) continue;
                return tempKey;
            }
            return null;
        }

        Hashtable getHashRender() {
            if (this.hash == null) {
                this.hash = new Hashtable(0);
            }
            return this.hash;
        }
    }
}

