/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.common.util.StreamUtil;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetListener;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class KDTextFieldAssistor
extends JPanel {
    private static final Logger logger = CommonLogger.getLogger(KDTextFieldAssistor.class);
    private KDTextField parent;
    private Popup popup;
    private String recordName = null;
    private boolean needRetrieval = true;
    private String[] assistorCache;
    private ArrayList assistorContent = new ArrayList();
    private boolean needRetrievalMyCommonUse = true;
    private String[] myCommonUseCache = null;
    private ArrayList myCommonUseContent = new ArrayList();
    private int assistInfoLimit = 100;
    private KDTable assistorTable = new KDTable();
    private KDTable myCommonUseTable = new KDTable();
    protected KDTabbedPane kdTMain;
    private CentralizedHandler centralizedHandler = new CentralizedHandler();
    private boolean isShowing;
    private int listCellCountPerPage = 5;
    private boolean closeAble = true;
    private static final String TABLE_COLUMN_ID = "id";
    private static final String TABLE_COLUMN_NAME = "name";
    private static final String TABLE_COLUMN_NUMBER = "number";
    private static final int SPAN = 10;
    private static final int BUTTON_WIDTH = 73;
    private static final int BUTTON_HEIGHT = 21;
    private static final int COLUMN_WIDTH = 100;
    private boolean multipleSelect = false;
    private JTextHandler jtextListener = new JTextHandler();

    public KDTextFieldAssistor(KDTextField parent) {
        this.setLayout(new BorderLayout());
        this.parent = parent;
        this.initTabbedPane();
    }

    private void initTabbedPane() {
        this.kdTMain = new KDTabbedPane();
        this.kdTMain.setName("kdTMain");
        this.kdTMain.setTabPlacement(3);
        this.kdTMain.setForcedHide(true);
        this.add((Component)this.kdTMain, "Center");
        this.assistorTable.setScrollStateHorizon(1);
        this.assistorTable.setScrollStateVertical(1);
        this.myCommonUseTable.setScrollStateHorizon(1);
        this.myCommonUseTable.setScrollStateVertical(1);
        this.assistorTable.setBackground(Color.WHITE);
        this.myCommonUseTable.setBackground(Color.WHITE);
        this.kdTMain.setFocusable(false);
        this.assistorTable.setFocusable(false);
        this.myCommonUseTable.setFocusable(false);
        this.kdTMain.add((Component)this.assistorTable, LanguageManager.getLangMessage((String)"historyRecord", KDTextFieldAssistor.class, (String)"\u5386\u53f2\u8bb0\u5f55"), 0);
        this.kdTMain.add((Component)this.myCommonUseTable, LanguageManager.getLangMessage((String)"myCommonUser", KDTextFieldAssistor.class, (String)"\u6211\u7684\u5e38\u7528"), 1);
        this.initHistoryTable();
        this.initHistoryControls();
        this.initMyCommonUseTable();
        this.initMyCommonUseControls();
    }

    private void initMyCommonUseTable() {
        String[] bindContents = new String[4];
        IColumn col = this.myCommonUseTable.addColumn();
        col.setKey(TABLE_COLUMN_ID);
        bindContents[0] = TABLE_COLUMN_ID;
        col.setWidth(100);
        col.getStyleAttributes().setHided(true);
        col = this.myCommonUseTable.addColumn();
        col.setKey(TABLE_COLUMN_NUMBER);
        bindContents[1] = TABLE_COLUMN_NUMBER;
        col.setWidth(100);
        col = this.myCommonUseTable.addColumn();
        col.setKey(TABLE_COLUMN_NAME);
        bindContents[2] = TABLE_COLUMN_NAME;
        col.setWidth(100);
        this.myCommonUseTable.putBindContents("query", bindContents);
        this.myCommonUseTable.setFormatXml("");
        this.myCommonUseTable.checkParsed(true);
        int x = -82;
        int y = -29;
        int width = 73;
        int height = 21;
        height = y - 20;
        width = -19;
        x = 10;
        y = 10;
        KDLayout.Constraints cons = new KDLayout.Constraints();
        cons.originalBounds = new Rectangle(x, y, width, height);
        cons.anchor = 15;
        this.myCommonUseTable.putClientProperty((Object)"KDLayoutConstraints", (Object)cons);
        this.myCommonUseTable.getIndexColumn().getStyleAttributes().setHided(true);
        this.myCommonUseTable.setGridLineColor(Color.WHITE);
    }

    private void initMyCommonUseControls() {
        KDTableHelper.releaseEsc((JComponent)this.myCommonUseTable);
        CtrlSwingUtilities.removeManagingFocusForwardTraversalKeys((JComponent)this.myCommonUseTable, KeyStroke.getKeyStroke(10, 0));
        this.myCommonUseTable.getSelectManager().setSelectMode(this.isEnabledMultipleSelect() ? 10 : 2);
        this.myCommonUseTable.getStyleAttributes().setLocked(true);
        this.myCommonUseTable.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getClickCount() == 2 && e.getType() == 1) {
                    KDTextFieldAssistor.this.commitSelection();
                    KDTextFieldAssistor.this.setShowing(false);
                }
            }
        });
        this.myCommonUseTable.addRequestRowSetListener(new RequestRowSetListener(){

            public void doRequestRowSet(RequestRowSetEvent e) {
            }
        });
    }

    private void deleteMyCommonUse() {
        KDTSelectManager sm = this.myCommonUseTable.getSelectManager();
        int size = sm.size();
        ArrayList deleteDatas = new ArrayList();
        if (size <= 0) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            KDTSelectBlock sb = sm.get(i);
            int top = 0;
            int bottom = 0;
            if (sb.getMode() == 8) {
                bottom = this.myCommonUseTable.getRowCount3();
            } else {
                top = sb.getTop() >= 0 ? sb.getTop() : 0;
                bottom = sb.getBottom() >= 0 ? sb.getBottom() : 0;
            }
            for (int j = top; j <= bottom; ++j) {
                Object number;
                IRow row = this.myCommonUseTable.getRow(j);
                if (row == null || row.getCell(TABLE_COLUMN_NUMBER) == null || (number = row.getCell(TABLE_COLUMN_NUMBER).getValue()) == null) continue;
                this.deleteFromMyCommonUseCache(number.toString());
            }
        }
        this.saveMyCommonUse();
    }

    private void deleteFromMyCommonUseCache(String number) {
        if (this.myCommonUseCache == null || this.myCommonUseCache.length <= 0) {
            return;
        }
        for (int i = 0; i < this.myCommonUseCache.length; ++i) {
            if (this.myCommonUseCache[i].toUpperCase().indexOf(number.toUpperCase()) < 0) continue;
            this.myCommonUseCache[i] = "";
            break;
        }
        for (Object tempContent : this.myCommonUseContent) {
            if (tempContent.toString().toUpperCase().indexOf(number.toUpperCase()) < 0) continue;
            this.myCommonUseContent.remove(tempContent);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveMyCommonUse() {
        if (this.myCommonUseContent == null || this.myCommonUseContent.size() <= 0) {
            return;
        }
        String fileName = (this.recordName == null ? this.parent.getName() : this.recordName) + "MyCommonUse";
        if (StringUtils.isEmpty(fileName = FilenameUtils.normalize((String)fileName))) {
            return;
        }
        File f = new File(System.getProperty("java.io.tmpdir") + fileName);
        FileOutputStream fom = null;
        try {
            String str = "";
            for (int i = 0; i < this.myCommonUseCache.length; ++i) {
                if (this.myCommonUseCache[i] == null || this.myCommonUseCache[i].trim().length() <= 0) continue;
                str = str + this.myCommonUseCache[i] + "\n";
            }
            fom = new FileOutputStream(f);
            fom.write(str.getBytes("UTF-8"));
            fom.write(10);
            fom.flush();
            StreamUtil.closeCloseable((Closeable)fom);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            StreamUtil.closeCloseable(fom);
        }
    }

    private void initHistoryTable() {
        String[] bindContents = new String[4];
        IColumn col = this.assistorTable.addColumn();
        col.setKey(TABLE_COLUMN_ID);
        bindContents[0] = TABLE_COLUMN_ID;
        col.setWidth(100);
        col.getStyleAttributes().setHided(true);
        col = this.assistorTable.addColumn();
        col.setKey(TABLE_COLUMN_NUMBER);
        bindContents[1] = TABLE_COLUMN_NUMBER;
        col.setWidth(100);
        col = this.assistorTable.addColumn();
        col.setKey(TABLE_COLUMN_NAME);
        bindContents[2] = TABLE_COLUMN_NAME;
        col.setWidth(100);
        this.assistorTable.putBindContents("query", bindContents);
        this.assistorTable.setFormatXml("");
        this.assistorTable.checkParsed(true);
        int x = -82;
        int y = -29;
        int width = 73;
        int height = 21;
        height = y - 20;
        width = -19;
        x = 10;
        y = 10;
        KDLayout.Constraints cons = new KDLayout.Constraints();
        cons.originalBounds = new Rectangle(x, y, width, height);
        cons.anchor = 15;
        this.assistorTable.putClientProperty((Object)"KDLayoutConstraints", (Object)cons);
        this.assistorTable.getIndexColumn().getStyleAttributes().setHided(true);
        this.assistorTable.setGridLineColor(Color.WHITE);
    }

    private void initHistoryControls() {
        KDTableHelper.releaseEsc((JComponent)this.assistorTable);
        CtrlSwingUtilities.removeManagingFocusForwardTraversalKeys((JComponent)this.assistorTable, KeyStroke.getKeyStroke(10, 0));
        this.assistorTable.getSelectManager().setSelectMode(this.isEnabledMultipleSelect() ? 10 : 2);
        this.assistorTable.getStyleAttributes().setLocked(true);
        this.assistorTable.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getClickCount() == 2 && e.getType() == 1) {
                    KDTextFieldAssistor.this.commitSelection();
                    KDTextFieldAssistor.this.setShowing(false);
                }
            }
        });
        this.assistorTable.addRequestRowSetListener(new RequestRowSetListener(){

            public void doRequestRowSet(RequestRowSetEvent e) {
            }
        });
    }

    public void setRecordName(String name) {
        String n = null;
        if (name != null) {
            n = name.replaceAll("\\\\|/|\\:|\\*|\"|>|<|\\|", "");
        }
        this.recordName = n;
    }

    public void installListeners() {
        KDTextField edt = this.parent;
        edt.addKeyListener(this.jtextListener);
        edt.addMouseListener(this.jtextListener);
        edt.addFocusListener(this.jtextListener);
    }

    public void uninstallListeners() {
        KDTextField edt = this.parent;
        edt.removeKeyListener(this.jtextListener);
        edt.removeMouseListener(this.jtextListener);
        edt.removeFocusListener(this.jtextListener);
    }

    public void setAssistorMaximumRowCount(int count) {
        this.listCellCountPerPage = count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void memorizeAssistorInfo() {
        block22: {
            if (this.parent.getText().equals("")) {
                return;
            }
            String fileName = this.recordName == null ? this.parent.getName() : this.recordName;
            if (StringUtils.isEmpty(fileName = FilenameUtils.normalize((String)fileName))) {
                return;
            }
            File f = new File(System.getProperty("java.io.tmpdir") + fileName);
            if (!f.exists()) {
                FileOutputStream fom = null;
                try {
                    f.createNewFile();
                    fom = new FileOutputStream(f);
                    fom.write(this.parent.getText().getBytes("UTF-8"));
                    fom.write(10);
                    fom.flush();
                    this.assistorCache = new String[]{this.parent.getText()};
                    StreamUtil.closeCloseable((Closeable)fom);
                    return;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    break block22;
                }
                finally {
                    StreamUtil.closeCloseable(fom);
                }
            }
            FileOutputStream fom = null;
            try {
                int i;
                int i2;
                if (this.assistorCache == null) {
                    this.assistorCache = new String[0];
                }
                for (i2 = 0; i2 < this.assistorCache.length; ++i2) {
                    if (!this.assistorCache[i2].equals(this.parent.getText())) continue;
                    for (int j = i2; j > 0; --j) {
                        this.assistorCache[j] = this.assistorCache[j - 1];
                    }
                    this.assistorCache[0] = this.parent.getText();
                    return;
                }
                if (this.assistorCache.length == this.assistInfoLimit) {
                    for (i2 = this.assistInfoLimit - 1; i2 > 0; --i2) {
                        this.assistorCache[i2] = this.assistorCache[i2 - 1];
                    }
                    this.assistorCache[0] = this.parent.getText();
                } else {
                    String[] tempAssistorInformation = new String[this.assistorCache.length + 1];
                    for (i = this.assistorCache.length; i > 0; --i) {
                        tempAssistorInformation[i] = this.assistorCache[i - 1];
                    }
                    tempAssistorInformation[0] = this.parent.getText();
                    this.assistorCache = tempAssistorInformation;
                }
                String str = "";
                for (i = 0; i < this.assistorCache.length; ++i) {
                    str = str + this.assistorCache[i] + "\n";
                }
                fom = new FileOutputStream(f);
                fom.write(str.getBytes("UTF-8"));
                fom.write(10);
                fom.flush();
                StreamUtil.closeCloseable((Closeable)fom);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                StreamUtil.closeCloseable(fom);
            }
        }
    }

    private Object[] getAssistorContent() {
        return this.assistorContent.toArray();
    }

    private String getSelectedItem() {
        String selectedItem = null;
        selectedItem = this.getSelectedHistoryItem();
        if (selectedItem != null && selectedItem.trim().length() > 0) {
            return selectedItem;
        }
        selectedItem = this.getSelectedCommonUseItem();
        return selectedItem;
    }

    private String getSelectedHistoryItem() {
        String selectedItem = null;
        KDTSelectManager sm = this.assistorTable.getSelectManager();
        int size = sm.size();
        ArrayList datas = new ArrayList();
        if (size <= 0) {
            return null;
        }
        String mainKey = TABLE_COLUMN_NUMBER;
        for (int i = 0; i < size; ++i) {
            KDTSelectBlock sb = sm.get(i);
            int top = 0;
            int bottom = 0;
            if (sb.getMode() == 8) {
                bottom = this.assistorTable.getRowCount3();
            } else {
                top = sb.getTop() >= 0 ? sb.getTop() : 0;
                bottom = sb.getBottom() >= 0 ? sb.getBottom() : 0;
            }
            for (int j = top; j <= bottom; ++j) {
                Object v;
                IRow row = this.assistorTable.getRow(j);
                if (row == null || row.getCell(mainKey) == null || (v = row.getCell(mainKey).getValue()) == null) continue;
                selectedItem = v.toString();
                return selectedItem;
            }
        }
        return selectedItem;
    }

    private String getSelectedCommonUseItem() {
        String selectedItem = null;
        KDTSelectManager sm = this.myCommonUseTable.getSelectManager();
        int size = sm.size();
        ArrayList datas = new ArrayList();
        if (size <= 0) {
            return null;
        }
        String mainKey = TABLE_COLUMN_NUMBER;
        for (int i = 0; i < size; ++i) {
            KDTSelectBlock sb = sm.get(i);
            int top = 0;
            int bottom = 0;
            if (sb.getMode() == 8) {
                bottom = this.myCommonUseTable.getRowCount3();
            } else {
                top = sb.getTop() >= 0 ? sb.getTop() : 0;
                bottom = sb.getBottom() >= 0 ? sb.getBottom() : 0;
            }
            for (int j = top; j <= bottom; ++j) {
                Object v;
                IRow row = this.myCommonUseTable.getRow(j);
                if (row == null || row.getCell(mainKey) == null || (v = row.getCell(mainKey).getValue()) == null) continue;
                selectedItem = v.toString();
                return selectedItem;
            }
        }
        return selectedItem;
    }

    public void setShowing(boolean b) {
        this.isShowing = b;
        if (b) {
            KDPromptBox parentPromptBox;
            if (this.popup == null) {
                Point parentLocationOnScreen = this.parent.getLocationOnScreen();
                Point p = new Point(parentLocationOnScreen.x, parentLocationOnScreen.y + this.parent.getHeight());
                if (this.parent.getParent() instanceof KDPromptBox) {
                    KDPromptBox parentPromptBox2 = (KDPromptBox)this.parent.getParent();
                    this.popup = PopupFactory.getSharedInstance().getPopup(parentPromptBox2, this, p.x, p.y);
                } else {
                    this.popup = PopupFactory.getSharedInstance().getPopup(this.parent, this, p.x, p.y);
                }
            }
            if (!this.parent.isFocusOwner()) {
                if (this.parent.getParent() instanceof KDPromptBox) {
                    parentPromptBox = (KDPromptBox)this.parent.getParent();
                    parentPromptBox.setHasDownPanel(false);
                    parentPromptBox.setHasDownPanelSelected(false);
                }
                try {
                    if (this.parent.getParent() instanceof KDPromptBox) {
                        parentPromptBox = (KDPromptBox)this.parent.getParent();
                        parentPromptBox.setHasDownPanel(false);
                        parentPromptBox.setHasDownPanelSelected(false);
                    }
                    this.popup.hide();
                    this.popup = null;
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                catch (Error e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            } else {
                try {
                    if (this.parent.getParent() instanceof KDPromptBox) {
                        parentPromptBox = (KDPromptBox)this.parent.getParent();
                        parentPromptBox.setHasDownPanel(true);
                    }
                    this.popup.show();
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                catch (Error e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        } else if (this.popup != null) {
            try {
                if (this.parent.getParent() instanceof KDPromptBox) {
                    KDPromptBox parentPromptBox = (KDPromptBox)this.parent.getParent();
                    parentPromptBox.setHasDownPanel(false);
                    parentPromptBox.setHasDownPanelSelected(false);
                }
                this.popup.hide();
                this.popup = null;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (Error e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public boolean isShowing() {
        return this.isShowing;
    }

    private boolean renewAssistorContent() {
        boolean renewResult = false;
        boolean renewHistoryResult = this.renewHistoryContent();
        boolean renewMyCommonUseResult = this.renewMyCommonUseContent();
        renewResult = renewHistoryResult || renewMyCommonUseResult;
        return renewResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean renewHistoryContent() {
        if (this.parent.getParent() instanceof KDPromptBox) {
            KDPromptBox parentPromptBox = (KDPromptBox)this.parent.getParent();
            parentPromptBox.setHasDownPanelSelected(false);
        }
        try {
            block8: {
                if (!this.needRetrieval) break block8;
                String fileName = this.recordName == null ? this.parent.getName() : this.recordName;
                if (StringUtils.isEmpty(fileName = FilenameUtils.normalize((String)fileName))) {
                    return false;
                }
                File f = new File(System.getProperty("java.io.tmpdir") + fileName);
                if (!f.exists()) {
                    return false;
                }
                FileInputStream fim = null;
                byte[] bytes = new byte[(int)f.length()];
                try {
                    fim = new FileInputStream(f);
                    fim.read(bytes);
                }
                catch (Throwable throwable) {
                    StreamUtil.closeCloseable(fim);
                    throw throwable;
                }
                StreamUtil.closeCloseable((Closeable)fim);
                String str = new String(bytes, "UTF-8");
                this.assistorCache = str.split("\n");
                this.needRetrieval = false;
            }
            this.assistorContent.clear();
            int findCount = 0;
            for (int i = 0; i < this.assistorCache.length && findCount < 10; ++i) {
                if (this.assistorCache[i].toUpperCase().indexOf(this.parent.getText().toUpperCase()) < 0) continue;
                this.assistorContent.add(this.assistorCache[i]);
                ++findCount;
            }
            return this.assistorContent.size() != 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private void updateAssistorContent() {
        this.fillHistroryTable();
        this.fillMyCommonUseTable();
    }

    private void fillHistroryTable() {
        if (this.assistorContent == null || this.assistorContent.size() == 0) {
            this.kdTMain.remove((Component)this.assistorTable);
            return;
        }
        this.kdTMain.add((Component)this.assistorTable, LanguageManager.getLangMessage((String)"historyRecord", KDTextFieldAssistor.class, (String)"\u5386\u53f2\u8bb0\u5f55"), 0);
        this.assistorTable.removeRows();
        Iterator it = this.assistorContent.iterator();
        String content = null;
        String number = null;
        String name = null;
        IRow row = null;
        while (it != null && it.hasNext()) {
            content = (String)it.next();
            if (content == null) continue;
            if (content.indexOf("\t") >= 0) {
                number = content.substring(0, content.indexOf("\t"));
                name = content.substring(content.indexOf("\t"));
            } else {
                number = content;
            }
            row = this.assistorTable.addRow();
            row.getCell(TABLE_COLUMN_NUMBER).setValue((Object)number);
            row.getCell(TABLE_COLUMN_NAME).setValue((Object)name);
        }
        if (this.assistorTable.getRow(0) != null) {
            int i;
            this.assistorTable.getSelectManager().select(0, -1);
            int columnCount = this.assistorTable.getColumnCount();
            for (i = 0; i < columnCount; ++i) {
                KDTableHelper.autoFitColumnWidth((KDTable)this.assistorTable, (int)i);
            }
            for (i = 0; i < columnCount; ++i) {
                int columnWidth = this.assistorTable.getColumn(i).getWidth();
                if (columnWidth >= 100) continue;
                this.assistorTable.getColumn(i).setWidth(100);
            }
        }
    }

    private void fillMyCommonUseTable() {
        if (this.myCommonUseContent == null || this.myCommonUseContent.size() == 0) {
            this.kdTMain.remove((Component)this.myCommonUseTable);
            return;
        }
        this.kdTMain.add((Component)this.myCommonUseTable, LanguageManager.getLangMessage((String)"myCommonUser", KDTextFieldAssistor.class, (String)"\u6211\u7684\u5e38\u7528"), 1);
        this.myCommonUseTable.removeRows();
        Iterator it = this.myCommonUseContent.iterator();
        String content = null;
        String number = null;
        String name = null;
        IRow row = null;
        while (it != null && it.hasNext()) {
            content = (String)it.next();
            if (content == null || content.trim().length() <= 0) continue;
            if (content.indexOf("\t") >= 0) {
                number = content.substring(0, content.indexOf("\t"));
                name = content.substring(content.indexOf("\t"));
            } else {
                number = content;
            }
            row = this.myCommonUseTable.addRow();
            row.getCell(TABLE_COLUMN_NUMBER).setValue((Object)number);
            row.getCell(TABLE_COLUMN_NAME).setValue((Object)name);
        }
        if (this.myCommonUseTable.getRow(0) != null) {
            int i;
            this.assistorTable.getSelectManager().select(0, -1);
            int columnCount = this.myCommonUseTable.getColumnCount();
            for (i = 0; i < columnCount; ++i) {
                KDTableHelper.autoFitColumnWidth((KDTable)this.myCommonUseTable, (int)i);
            }
            for (i = 0; i < columnCount; ++i) {
                int columnWidth = this.myCommonUseTable.getColumn(i).getWidth();
                if (columnWidth >= 100) continue;
                this.myCommonUseTable.getColumn(i).setWidth(100);
            }
        }
    }

    private void updateAssistor() {
        this.updateAssistorContent();
        this.setShowing(true);
    }

    public void commitSelection() {
        this.setCloseAble(false);
        String result = this.getSelectedItem();
        if (result != null && !result.equals(this.parent.getText())) {
            this.parent.setText(result);
        }
        this.setCloseAble(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean renewMyCommonUseContent() {
        if (this.parent.getParent() instanceof KDPromptBox) {
            KDPromptBox parentPromptBox = (KDPromptBox)this.parent.getParent();
            parentPromptBox.setHasDownPanelSelected(false);
        }
        try {
            block8: {
                if (!this.needRetrievalMyCommonUse) break block8;
                String fileName = (this.recordName == null ? this.parent.getName() : this.recordName) + "MyCommonUse";
                if (StringUtils.isEmpty(fileName = FilenameUtils.normalize((String)fileName))) {
                    return false;
                }
                File f = new File(System.getProperty("java.io.tmpdir") + fileName);
                if (!f.exists()) {
                    return false;
                }
                FileInputStream fim = null;
                byte[] bytes = new byte[(int)f.length()];
                try {
                    fim = new FileInputStream(f);
                    ((InputStream)fim).read(bytes);
                }
                catch (Throwable throwable) {
                    StreamUtil.closeCloseable(fim);
                    throw throwable;
                }
                StreamUtil.closeCloseable((Closeable)fim);
                String str = new String(bytes, "UTF-8");
                this.myCommonUseCache = str.split("\n");
                this.needRetrievalMyCommonUse = false;
            }
            this.myCommonUseContent.clear();
            int findCount = 0;
            for (int i = 0; i < this.myCommonUseCache.length && findCount < 10; ++i) {
                if (this.myCommonUseCache[i].toUpperCase().indexOf(this.parent.getText().toUpperCase()) < 0) continue;
                this.myCommonUseContent.add(this.myCommonUseCache[i]);
                ++findCount;
            }
            return this.myCommonUseContent.size() != 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isCloseAble() {
        return this.closeAble;
    }

    public void setCloseAble(boolean closeAble) {
        this.closeAble = closeAble;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void memorizeAssistorInfo(String editValue) {
        block22: {
            if (editValue.equals("")) {
                return;
            }
            String fileName = this.recordName == null ? this.parent.getName() : this.recordName;
            if (StringUtils.isEmpty(fileName = FilenameUtils.normalize((String)fileName))) {
                return;
            }
            File f = new File(System.getProperty("java.io.tmpdir") + fileName);
            if (!f.exists()) {
                FileOutputStream fom = null;
                try {
                    f.createNewFile();
                    fom = new FileOutputStream(f);
                    ((OutputStream)fom).write(editValue.getBytes("UTF-8"));
                    ((OutputStream)fom).write(10);
                    fom.flush();
                    this.assistorCache = new String[]{editValue};
                    StreamUtil.closeCloseable((Closeable)fom);
                    return;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    break block22;
                }
                finally {
                    StreamUtil.closeCloseable(fom);
                }
            }
            FileOutputStream fom = null;
            try {
                int i;
                int i2;
                if (this.assistorCache == null) {
                    this.assistorCache = new String[0];
                }
                for (i2 = 0; i2 < this.assistorCache.length; ++i2) {
                    if (!this.assistorCache[i2].equals(editValue)) continue;
                    for (int j = i2; j > 0; --j) {
                        this.assistorCache[j] = this.assistorCache[j - 1];
                    }
                    this.assistorCache[0] = editValue;
                    return;
                }
                if (this.assistorCache.length == this.assistInfoLimit) {
                    for (i2 = this.assistInfoLimit - 1; i2 > 0; --i2) {
                        this.assistorCache[i2] = this.assistorCache[i2 - 1];
                    }
                    this.assistorCache[0] = editValue;
                } else {
                    String[] tempAssistorInformation = new String[this.assistorCache.length + 1];
                    for (i = this.assistorCache.length; i > 0; --i) {
                        tempAssistorInformation[i] = this.assistorCache[i - 1];
                    }
                    tempAssistorInformation[0] = editValue;
                    this.assistorCache = tempAssistorInformation;
                }
                String str = "";
                for (i = 0; i < this.assistorCache.length; ++i) {
                    str = str + this.assistorCache[i] + "\n";
                }
                fom = new FileOutputStream(f);
                fom.write(str.getBytes("UTF-8"));
                fom.write(10);
                fom.flush();
                StreamUtil.closeCloseable((Closeable)fom);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                StreamUtil.closeCloseable(fom);
            }
        }
    }

    public boolean isEnabledMultipleSelect() {
        return this.multipleSelect;
    }

    public void setEnabledMultiSelection(boolean b) {
        this.multipleSelect = b;
        this.assistorTable.getSelectManager().setSelectMode(b ? 10 : 2);
    }

    private class JTextHandler
    extends MouseAdapter
    implements KeyListener,
    FocusListener {
        private JTextHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (KDTextFieldAssistor.this.parent.getParent() instanceof KDPromptBox) {
                KDPromptBox parentPromptBox = (KDPromptBox)KDTextFieldAssistor.this.parent.getParent();
                if (!parentPromptBox.isEnabled()) {
                    return;
                }
                if (parentPromptBox.isReadOnly()) {
                    return;
                }
            }
            if (KDTextFieldAssistor.this.renewAssistorContent()) {
                KDTextFieldAssistor.this.updateAssistor();
            } else {
                KDTextFieldAssistor.this.setShowing(false);
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 27) {
                KDTextFieldAssistor.this.setShowing(false);
            } else if (e.getKeyCode() == 40) {
                Component selectedComponent = KDTextFieldAssistor.this.kdTMain.getSelectedComponent();
                if (selectedComponent == null) {
                    return;
                }
                if (selectedComponent.equals(KDTextFieldAssistor.this.assistorTable)) {
                    int selectRowIndex = KDTextFieldAssistor.this.assistorTable.getSelectManager().getActiveRowIndex();
                    int rowCount = KDTextFieldAssistor.this.assistorTable.getRowCount();
                    int currentIndex = 0;
                    if (rowCount > 0 && selectRowIndex < rowCount) {
                        currentIndex = selectRowIndex + 1;
                        KDTextFieldAssistor.this.assistorTable.getSelectManager().select(currentIndex, -1);
                        KDTextFieldAssistor.this.assistorTable.scrollToVisible(currentIndex, -1);
                        if (KDTextFieldAssistor.this.parent.getParent() instanceof KDPromptBox) {
                            KDPromptBox parentPromptBox = (KDPromptBox)KDTextFieldAssistor.this.parent.getParent();
                            parentPromptBox.setHasDownPanelSelected(true);
                        }
                    }
                } else if (selectedComponent.equals(KDTextFieldAssistor.this.myCommonUseTable)) {
                    int selectRowIndex = KDTextFieldAssistor.this.myCommonUseTable.getSelectManager().getActiveRowIndex();
                    int rowCount = KDTextFieldAssistor.this.myCommonUseTable.getRowCount();
                    int currentIndex = 0;
                    if (rowCount > 0 && selectRowIndex < rowCount) {
                        currentIndex = selectRowIndex + 1;
                        KDTextFieldAssistor.this.myCommonUseTable.getSelectManager().select(currentIndex, -1);
                        KDTextFieldAssistor.this.myCommonUseTable.scrollToVisible(currentIndex, -1);
                        if (KDTextFieldAssistor.this.parent.getParent() instanceof KDPromptBox) {
                            KDPromptBox parentPromptBox = (KDPromptBox)KDTextFieldAssistor.this.parent.getParent();
                            parentPromptBox.setHasDownPanelSelected(true);
                        }
                    }
                }
            } else if (e.getKeyCode() == 38) {
                Component selectedComponent = KDTextFieldAssistor.this.kdTMain.getSelectedComponent();
                if (selectedComponent == null) {
                    return;
                }
                if (selectedComponent.equals(KDTextFieldAssistor.this.assistorTable)) {
                    int selectRowIndex = KDTextFieldAssistor.this.assistorTable.getSelectManager().getActiveRowIndex();
                    int currentIndex = 0;
                    if (selectRowIndex > 0) {
                        currentIndex = selectRowIndex - 1;
                        KDTextFieldAssistor.this.assistorTable.getSelectManager().select(currentIndex, -1);
                        KDTextFieldAssistor.this.assistorTable.scrollToVisible(currentIndex, -1);
                    }
                } else if (selectedComponent.equals(KDTextFieldAssistor.this.myCommonUseTable)) {
                    int selectRowIndex = KDTextFieldAssistor.this.myCommonUseTable.getSelectManager().getActiveRowIndex();
                    int currentIndex = 0;
                    if (selectRowIndex > 0) {
                        currentIndex = selectRowIndex - 1;
                        KDTextFieldAssistor.this.myCommonUseTable.getSelectManager().select(currentIndex, -1);
                        KDTextFieldAssistor.this.myCommonUseTable.scrollToVisible(currentIndex, -1);
                    }
                }
            } else if (e.getKeyCode() == 10) {
                if (KDTextFieldAssistor.this.isShowing) {
                    KDTextFieldAssistor.this.commitSelection();
                    KDTextFieldAssistor.this.setShowing(false);
                    if (KDTextFieldAssistor.this.parent.getParent() instanceof KDPromptBox) {
                        KDPromptBox parentPromptBox = (KDPromptBox)KDTextFieldAssistor.this.parent.getParent();
                        parentPromptBox.setHasDownPanelSelected(false);
                    }
                }
            } else if (e.getKeyCode() == 127) {
                KDTextFieldAssistor.this.deleteMyCommonUse();
                KDTextFieldAssistor.this.updateAssistor();
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 27) {
                return;
            }
            int keyCode = e.getKeyCode();
            if (keyCode >= 48 && keyCode <= 57 || keyCode >= 65 && keyCode <= 90 || keyCode >= 96 && keyCode <= 105 || keyCode == 8 || keyCode == 127 || keyCode == 32) {
                if (KDTextFieldAssistor.this.renewAssistorContent()) {
                    KDTextFieldAssistor.this.updateAssistor();
                } else {
                    KDTextFieldAssistor.this.setShowing(false);
                }
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            KDTextFieldAssistor.this.setShowing(false);
        }
    }

    private class KingdeeTextFieldAssistorLayout
    implements LayoutManager {
        private int columnHeight = 20;
        private int insets = 4;

        private KingdeeTextFieldAssistorLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int assistorTableWidth = (int)KDTextFieldAssistor.this.assistorTable.getPreferredSize().getWidth();
            int assistorTableHeight = (int)KDTextFieldAssistor.this.assistorTable.getPreferredSize().getHeight();
            int myCommonUseTableWidth = (int)KDTextFieldAssistor.this.myCommonUseTable.getPreferredSize().getWidth();
            int myCommonUseTableHeight = (int)KDTextFieldAssistor.this.myCommonUseTable.getPreferredSize().getHeight();
            int width = assistorTableWidth > myCommonUseTableWidth ? assistorTableWidth : myCommonUseTableWidth;
            int height = assistorTableHeight > myCommonUseTableHeight ? assistorTableHeight : myCommonUseTableHeight;
            return new Dimension(width, height + 100);
        }

        @Override
        public void layoutContainer(Container parent) {
            int width = (int)KDTextFieldAssistor.this.kdTMain.getPreferredSize().getWidth();
            int height = (int)KDTextFieldAssistor.this.kdTMain.getPreferredSize().getHeight();
            KDTextFieldAssistor.this.kdTMain.setBounds(0, 0, width, height + 100);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }
    }

    private class CentralizedHandler
    extends MouseAdapter
    implements MouseMotionListener {
        private CentralizedHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (KDTextFieldAssistor.this.parent == null || KDTextFieldAssistor.this.assistorTable == null) {
                KDTextFieldAssistor.this.setShowing(false);
                return;
            }
            String selectedItem = null;
            KDTSelectManager sm = KDTextFieldAssistor.this.assistorTable.getSelectManager();
            int size = sm.size();
            if (size <= 0) {
                return;
            }
            String mainKey = KDTextFieldAssistor.TABLE_COLUMN_NUMBER;
            for (int i = 0; i < size; ++i) {
                KDTSelectBlock sb = sm.get(i);
                int top = 0;
                int bottom = 0;
                if (sb.getMode() == 8) {
                    bottom = KDTextFieldAssistor.this.assistorTable.getRowCount3();
                } else {
                    top = sb.getTop() >= 0 ? sb.getTop() : 0;
                    bottom = sb.getBottom() >= 0 ? sb.getBottom() : 0;
                }
                for (int j = top; j <= bottom; ++j) {
                    Object v;
                    IRow row = KDTextFieldAssistor.this.assistorTable.getRow(j);
                    if (row == null || row.getCell(mainKey) == null || (v = row.getCell(mainKey).getValue()) == null) continue;
                    selectedItem = v.toString();
                    KDTextFieldAssistor.this.parent.setText(selectedItem);
                    return;
                }
            }
            KDTextFieldAssistor.this.setShowing(false);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            KDTextFieldAssistor.this.setShowing(false);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }
    }

    private class AssistorHandler
    extends MouseAdapter
    implements DocumentListener,
    KeyListener,
    FocusListener,
    PropertyChangeListener {
        private AssistorHandler() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            if (KDTextFieldAssistor.this.renewAssistorContent() && KDTextFieldAssistor.this.parent.isFocusOwner() && !KDTextFieldAssistor.this.parent.isBySetText()) {
                KDTextFieldAssistor.this.updateAssistor();
            } else {
                KDTextFieldAssistor.this.setShowing(false);
            }
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            if (KDTextFieldAssistor.this.renewAssistorContent() && KDTextFieldAssistor.this.parent.isFocusOwner() && !KDTextFieldAssistor.this.parent.isBySetText()) {
                KDTextFieldAssistor.this.updateAssistor();
            } else {
                KDTextFieldAssistor.this.setShowing(false);
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            if (KDTextFieldAssistor.this.renewAssistorContent() && KDTextFieldAssistor.this.parent.isFocusOwner() && !KDTextFieldAssistor.this.parent.isBySetText()) {
                KDTextFieldAssistor.this.updateAssistor();
            } else {
                KDTextFieldAssistor.this.setShowing(false);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (KDTextFieldAssistor.this.parent.getParent() instanceof KDPromptBox) {
                KDPromptBox parentPromptBox = (KDPromptBox)KDTextFieldAssistor.this.parent.getParent();
                if (!parentPromptBox.isEnabled()) {
                    return;
                }
                if (!parentPromptBox.isEditable()) {
                    return;
                }
                if (parentPromptBox.isReadOnly()) {
                    return;
                }
            }
            if (KDTextFieldAssistor.this.renewAssistorContent()) {
                KDTextFieldAssistor.this.updateAssistor();
            } else {
                KDTextFieldAssistor.this.setShowing(false);
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 27) {
                KDTextFieldAssistor.this.setShowing(false);
            } else if (e.getKeyCode() == 38 && e.isAltDown()) {
                KDTextFieldAssistor.this.setShowing(false);
            } else if (e.getKeyCode() == 40 && e.isAltDown()) {
                if (KDTextFieldAssistor.this.renewAssistorContent()) {
                    KDTextFieldAssistor.this.updateAssistor();
                } else {
                    KDTextFieldAssistor.this.setShowing(false);
                }
            } else if (e.getKeyCode() == 40) {
                int selectRowIndex = KDTextFieldAssistor.this.assistorTable.getSelectManager().getActiveRowIndex();
                int rowCount = KDTextFieldAssistor.this.assistorTable.getRowCount();
                int currentIndex = 0;
                if (rowCount < 0 || selectRowIndex < rowCount) {
                    currentIndex = selectRowIndex + 1;
                    KDTextFieldAssistor.this.assistorTable.getSelectManager().select(currentIndex, -1);
                    KDTextFieldAssistor.this.assistorTable.scrollToVisible(currentIndex, -1);
                }
            } else if (e.getKeyCode() == 38) {
                int selectRowIndex = KDTextFieldAssistor.this.assistorTable.getSelectManager().getActiveRowIndex();
                int currentIndex = 0;
                if (selectRowIndex > 0) {
                    currentIndex = selectRowIndex - 1;
                    KDTextFieldAssistor.this.assistorTable.getSelectManager().select(currentIndex, -1);
                    KDTextFieldAssistor.this.assistorTable.scrollToVisible(currentIndex, -1);
                }
            } else if (e.getKeyCode() == 10) {
                KDTextFieldAssistor.this.commitSelection();
                KDTextFieldAssistor.this.setShowing(false);
                e.consume();
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            KDTextFieldAssistor.this.setShowing(false);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName() == "document") {
                ((AbstractDocument)evt.getOldValue()).removeDocumentListener(this);
                ((AbstractDocument)evt.getNewValue()).addDocumentListener(this);
            }
        }
    }
}

