/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.swing.plaf.MultiLangIcon;
import java.util.Locale;
import javax.swing.Icon;

public class LanguageInfo {
    protected Locale locale;
    protected Locale standarlocale;
    protected Icon icon;
    private String displayName;

    public LanguageInfo(Locale l, Icon i) {
        this(l, i, null);
    }

    public LanguageInfo(Locale l, Icon i, String name) {
        this(l, i, name, l);
    }

    public LanguageInfo(Locale l, Icon i, String name, Locale sl) {
        this.locale = l;
        this.icon = i == null ? new MultiLangIcon(l) : i;
        this.displayName = name;
        this.standarlocale = sl;
    }

    public LanguageInfo(Locale l) {
        this(l, null);
    }

    public void setIcon(Icon i) {
        this.icon = i;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public boolean isSameLanguage(LanguageInfo l) {
        return this.locale.equals(l.getLocale());
    }

    public boolean isSameStandarLanguage(LanguageInfo l) {
        return this.standarlocale.equals(l.getStandarlocale());
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        boolean ret = false;
        if (o instanceof LanguageInfo) {
            LanguageInfo lan = (LanguageInfo)o;
            ret = this.isSameLanguage(lan);
        }
        return ret;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String getDisplayName(Locale loc) {
        if (StringUtil.isEmptyString((String)this.displayName)) {
            return this.getLocale().getDisplayName(loc);
        }
        return this.displayName;
    }

    public Locale getStandarlocale() {
        return this.standarlocale;
    }
}

