/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing;

import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;

public class TextLengthVerifier
extends InputVerifier {
    private int maxLength = -1;
    private int minLength = 0;

    public TextLengthVerifier() {
    }

    public TextLengthVerifier(int min, int max) {
        this.setMinLength(min);
        this.setMaxLength(max);
    }

    @Override
    public boolean verify(JComponent input) {
        int maxlen = this.getMaxLength();
        int minlen = this.getMinLength();
        if (maxlen != -1 && maxlen < minlen) {
            throw new IllegalArgumentException("max value is less than min value");
        }
        JTextComponent tc = (JTextComponent)input;
        String str = tc.getText();
        int len = str == null ? 0 : str.length();
        boolean ret = true;
        if (maxlen != -1 && len > maxlen) {
            ret = false;
        }
        if (len < minlen) {
            ret = false;
        }
        return ret;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public void setMaxLength(int i) {
        if (i >= -1) {
            this.maxLength = i;
        }
    }

    public void setMinLength(int i) {
        if (i >= 0) {
            this.minLength = i;
        }
    }
}

