/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing.calculator.plaf;

import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.calculator.KDCalculator;
import com.kingdee.bos.ctrl.swing.calculator.KDCalculatorModel;
import com.kingdee.bos.ctrl.swing.calculator.KDCalculatorPopup;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import javax.accessibility.Accessible;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;

public class KingdeeCalculatorUI
extends ComponentUI {
    private KDCalculator calculator;
    private JButton calcBtn;
    private KDFormattedTextField display;
    private KDCalculatorPopup calculatorPopup;
    private LayoutManager layout;
    private ButtonHandler buttonHandler;
    private WindowListener popupWindowHandler;
    private KeyListener keyListener;
    private FocusListener focusListener;
    private PropertyChangeListener propertyChangeListener;
    private transient KDDialog popup = null;
    protected static final int BUTTONSIZE = 22;
    protected static final Dimension PREFERREDSIZE = new Dimension(150, 22);
    protected static final Dimension MINSIZE = new Dimension(30, 22);
    protected static final Dimension MAXSIZE = new Dimension(Integer.MAX_VALUE, 22);
    private boolean showCalculatorPopup = false;

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.calculator = (KDCalculator)c;
        this.layout = this.createCalculatorLayout();
        this.calculator.setLayout(this.layout);
        this.installComponents(this.calculator);
        this.installDefaults(this.calculator);
        this.installListeners(this.calculator);
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallListeners(this.calculator);
        this.uninstallDefaults(this.calculator);
        this.uninstallComponents(this.calculator);
        super.uninstallUI(c);
    }

    protected void installComponents(KDCalculator c) {
        this.calcBtn = this.createButton();
        c.add((Component)this.calcBtn, "button");
        this.display = this.createDisplay();
        c.add((Component)this.display, "display");
        this.calculatorPopup = this.createCalculatorPopup();
    }

    protected void uninstallComponents(KDCalculator c) {
        this.calculatorPopup = null;
        this.display = null;
        this.calcBtn = null;
        c.removeAll();
    }

    protected void installDefaults(KDCalculator c) {
    }

    protected void uninstallDefaults(KDCalculator calculator) {
    }

    protected void installListeners(KDCalculator calculator) {
        if (this.keyListener == null) {
            this.keyListener = new CalculatorKeyListener();
            this.display.addKeyListener(this.keyListener);
        }
        if (this.focusListener == null) {
            this.focusListener = new CalculatorFocusListener();
            this.display.addFocusListener(this.focusListener);
        }
        if (this.propertyChangeListener == null) {
            this.propertyChangeListener = new CalculatorPropertyChangeListener();
            calculator.addPropertyChangeListener(this.propertyChangeListener);
        }
    }

    protected void uninstallListeners(KDCalculator calculator) {
        if (this.keyListener != null) {
            this.display.removeKeyListener(this.keyListener);
            this.keyListener = null;
        }
        if (this.focusListener != null) {
            this.display.removeFocusListener(this.focusListener);
            this.focusListener = null;
        }
        if (this.propertyChangeListener != null) {
            calculator.removePropertyChangeListener(this.propertyChangeListener);
            this.propertyChangeListener = null;
        }
    }

    private LayoutManager createCalculatorLayout() {
        if (this.layout == null) {
            this.layout = new CalculatorLayout();
        }
        return this.layout;
    }

    private boolean isShowCalculatorPopup() {
        return this.showCalculatorPopup;
    }

    private void setShowCalculatorPopup(boolean showCalculatorPopup) {
        this.showCalculatorPopup = showCalculatorPopup;
    }

    private JButton createButton() {
        JButton btn = new JButton();
        if (this.buttonHandler == null) {
            this.buttonHandler = new ButtonHandler();
        }
        btn.setIcon(UIManager.getIcon("Calculator.calculatorIcon"));
        btn.setBorder(null);
        btn.setDisabledIcon(UIManager.getIcon("Calculator.calculatorDisableIcon"));
        btn.setFocusable(false);
        btn.addMouseListener(this.buttonHandler);
        return btn;
    }

    protected KDFormattedTextField createDisplay() {
        return this.calculator.getDisplay();
    }

    protected KDCalculatorPopup createCalculatorPopup() {
        return this.calculator.getCalculatorPopup();
    }

    public static ComponentUI createUI(JComponent c) {
        return new KingdeeCalculatorUI();
    }

    @Override
    public boolean contains(JComponent c, int x, int y) {
        return super.contains(c, x, y);
    }

    @Override
    public Accessible getAccessibleChild(JComponent c, int i) {
        return super.getAccessibleChild(c, i);
    }

    @Override
    public int getAccessibleChildrenCount(JComponent c) {
        return super.getAccessibleChildrenCount(c);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return new Dimension(MAXSIZE);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return new Dimension(MINSIZE);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return new Dimension(PREFERREDSIZE);
    }

    public void setPopupVisible(boolean v) {
        if (this.popup == null && v) {
            this.showCalculatorPopup();
        } else if (this.popup != null) {
            boolean b = this.popup.isVisible();
            if (!b && v) {
                this.showCalculatorPopup();
            } else if (b && !v) {
                this.showCalculatorPopup();
            }
        }
    }

    protected void showCalculatorPopup() {
        this.configurePopup();
        boolean b = this.popup.isVisible();
        if (!b) {
            CtrlSwingUtilities.locateWindowToComponent(this.popup, null, this.calculator, 3);
            this.popup.show();
            this.calculatorPopup.getModel().setExpressValue(this.display.getText());
            this.calculatorPopup.getModel().calculate();
        } else {
            this.popup.dispose();
            this.popup = null;
            this.calculatorPopup.getModel().setOperation(KDCalculatorModel.OPERATION_NONE);
        }
    }

    protected void configurePopup() {
        if (this.popup == null) {
            Window w = SwingUtilities.getWindowAncestor(this.calculator);
            this.popup = w instanceof Frame ? new KDDialog((Frame)w) : (w instanceof Dialog ? new KDDialog((Dialog)w) : new KDDialog());
            this.popup.setModal(false);
            this.popup.setUndecorated(true);
            this.popup.getContentPane().add(this.calculatorPopup);
            this.popup.setResizable(false);
            this.popup.pack();
            if (this.popupWindowHandler != null) {
                this.popup.removeWindowListener(this.popupWindowHandler);
                this.popupWindowHandler = null;
            }
            if (this.popupWindowHandler == null) {
                this.popupWindowHandler = new PopupWindowHandler();
                this.popup.addWindowListener(this.popupWindowHandler);
            }
        }
    }

    private class CalculatorPropertyChangeListener
    implements PropertyChangeListener {
        private CalculatorPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            BigDecimal newValue;
            BigDecimal oldVlaue;
            if (evt.getPropertyName().equals("value") && (oldVlaue = (BigDecimal)evt.getOldValue()).compareTo(newValue = (BigDecimal)evt.getNewValue()) != 0) {
                KingdeeCalculatorUI.this.calculatorPopup.getModel().setExpressValue(newValue.toString());
            }
        }
    }

    private class CalculatorFocusListener
    implements FocusListener {
        private CalculatorFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            KingdeeCalculatorUI.this.calculatorPopup.getModel().setExpressValue(KingdeeCalculatorUI.this.display.getText());
        }
    }

    private class CalculatorKeyListener
    implements KeyListener {
        private CalculatorKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.isAltDown() && e.getKeyCode() == 40) {
                KingdeeCalculatorUI.this.setPopupVisible(true);
            } else if (e.getKeyCode() == 10) {
                KingdeeCalculatorUI.this.calculatorPopup.getModel().setExpressValue(KingdeeCalculatorUI.this.display.getText());
                KingdeeCalculatorUI.this.calculatorPopup.getModel().calculate();
            } else if (e.getKeyCode() == 106) {
                KingdeeCalculatorUI.this.setPopupVisible(true);
                KingdeeCalculatorUI.this.calculatorPopup.getModel().setCalculated(true);
                KingdeeCalculatorUI.this.calculatorPopup.getModel().multiply();
            } else if (e.getKeyCode() == 111) {
                KingdeeCalculatorUI.this.setPopupVisible(true);
                KingdeeCalculatorUI.this.calculatorPopup.getModel().setCalculated(true);
                KingdeeCalculatorUI.this.calculatorPopup.getModel().divide();
            } else if (e.getKeyCode() == 109) {
                KingdeeCalculatorUI.this.setPopupVisible(true);
                KingdeeCalculatorUI.this.calculatorPopup.getModel().setCalculated(true);
                KingdeeCalculatorUI.this.calculatorPopup.getModel().sub();
            } else if (e.getKeyCode() == 107) {
                KingdeeCalculatorUI.this.setPopupVisible(true);
                KingdeeCalculatorUI.this.calculatorPopup.getModel().setCalculated(true);
                KingdeeCalculatorUI.this.calculatorPopup.getModel().add();
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            if (e.getKeyCode() == 40) {
                KingdeeCalculatorUI.this.setPopupVisible(true);
            }
        }
    }

    private class PopupWindowHandler
    extends WindowAdapter {
        private PopupWindowHandler() {
        }

        @Override
        public void windowClosed(WindowEvent e) {
            KingdeeCalculatorUI.this.setShowCalculatorPopup(false);
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
            KingdeeCalculatorUI.this.setShowCalculatorPopup(true);
            KingdeeCalculatorUI.this.setPopupVisible(false);
            KingdeeCalculatorUI.this.calculatorPopup.getModel().setOperation(KDCalculatorModel.OPERATION_NONE);
            KingdeeCalculatorUI.this.display.requestFocus();
        }

        @Override
        public void windowActivated(WindowEvent e) {
        }
    }

    private class ButtonHandler
    extends MouseAdapter {
        private ButtonHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!KingdeeCalculatorUI.this.isShowCalculatorPopup()) {
                KingdeeCalculatorUI.this.setPopupVisible(true);
            }
        }
    }

    private class CalculatorLayout
    implements LayoutManager {
        private Dimension zeroSize = new Dimension(0, 0);
        private Component display = null;
        private Component calcButton = null;

        private CalculatorLayout() {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
            if (comp == this.display) {
                this.display = null;
                return;
            }
            if (comp == this.calcButton) {
                this.calcButton = null;
                return;
            }
        }

        @Override
        public void layoutContainer(Container parent) {
            Insets insets = parent.getInsets();
            int availWidth = parent.getWidth() - (insets.left + insets.right);
            Dimension buttonDim = this.preferredSize(this.calcButton);
            int displayWidth = availWidth - buttonDim.width - 2;
            int displayX = insets.left;
            int buttonX = displayX + displayWidth + 2;
            int y = insets.top;
            this.display.setBounds(displayX, y, displayWidth, buttonDim.height);
            this.calcButton.setBounds(buttonX, y, buttonDim.width, buttonDim.height);
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
            if (name.equals("display")) {
                this.display = comp;
            }
            if (name.equals("button")) {
                this.calcButton = comp;
            }
        }

        private Dimension preferredSize(Component c) {
            return c == null ? this.zeroSize : c.getPreferredSize();
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Dimension buttonD = new Dimension(this.preferredSize(this.calcButton));
            Dimension displayD = new Dimension(this.preferredSize(this.display));
            Dimension size = new Dimension(buttonD.width, buttonD.height);
            size.width += displayD.width + 2;
            if (parent != null) {
                Insets insets = parent.getInsets();
                size.width += insets.left + insets.right;
                size.height += insets.top + insets.bottom;
            }
            return size;
        }
    }
}

