/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing.dial;

import com.kingdee.bos.ctrl.swing.dial.DialPan;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import javax.swing.JComponent;

public class KpiPan
extends DialPan {
    protected static final Color BORDERCOLOR = new Color(0xBCBCBC);
    protected static final Color FILLCOLOR = new Color(5922147);
    protected static final int RADIUSMEDIUM = 63;
    protected static final double SCALEPOS = 0.611764705882353;
    protected static final double TICKSWIDTH = 0.11764705882352941;
    protected static final double BORDERWIDTH = 0.011764705882352941;
    protected static final double NEEDLERADIUS = 0.14705882352941177;
    protected static final double PANHEIGHT = 0.023529411764705882;
    public static final int MAXTICKWIDTH = 20;
    protected static final double TOTALHEIGHT = 0.37610619469026546;
    private Paint fillPaint = FILLCOLOR;
    private Paint borderPaint = BORDERCOLOR;

    @Override
    public void draw(Graphics g, Rectangle area, JComponent c) {
        c.getBounds();
        Graphics2D g2 = (Graphics2D)g;
        int height = area.height;
        int width = area.width;
        int r = (int)(0.611764705882353 * (double)height);
        int tickWidth = (int)(0.11764705882352941 * (double)height);
        if (tickWidth > 20) {
            tickWidth = 20;
        }
        int borderWidth = (int)(0.011764705882352941 * (double)height);
        int y0 = area.y + height;
        int x = area.x + width / 2;
        int y = y0 - (int)(0.023529411764705882 * (double)height);
        int x1 = x - r - tickWidth - borderWidth;
        int y1 = y - r - tickWidth - borderWidth;
        int tempRadius = r + tickWidth + borderWidth;
        g2.drawString(this.unitTitle, x + tempRadius * 3 / 4, y - tempRadius - 20);
        g2.setPaint(new Color(0xFFFFFF));
        g2.fillArc(x1, y1, tempRadius * 2, tempRadius * 2, 0, 180);
        g2.fillRect(x1, y, tempRadius * 2, (int)(0.023529411764705882 * (double)height));
        tempRadius = r + tickWidth - tickWidth / 2;
        g2.setPaint(new Color(0x333333));
        g2.fillArc(x - tempRadius, y - tempRadius, tempRadius * 2, tempRadius * 2, 0, 180);
        tempRadius = r - borderWidth;
        GradientPaint p = new GradientPaint(x + tempRadius, y - tempRadius, new Color(1909283), x, y, new Color(0xDCDCDC));
        GradientPaint p2 = new GradientPaint(x - tempRadius, y - tempRadius, new Color(1909283), x, y, new Color(0xDCDCDC));
        g2.setPaint(p);
        g2.fillArc(x - tempRadius, y - tempRadius, 2 * tempRadius, 2 * tempRadius, 0, 90);
        g2.setPaint(p2);
        g2.fillArc(x - tempRadius, y - tempRadius, 2 * tempRadius, 2 * tempRadius, 90, 90);
        p = new GradientPaint(x + (int)((double)tempRadius * 0.843), y - (int)((double)tempRadius * 0.843), new Color(0x4D4D4D), x, y, new Color(0xDCDCDC));
        p2 = new GradientPaint(x - (int)((double)tempRadius * 0.843), y - (int)((double)tempRadius * 0.843), new Color(0x4D4D4D), x, y, new Color(0xDCDCDC));
        g2.setPaint(p);
        g2.fillArc(x - (int)((double)tempRadius * 0.843), y - (int)((double)tempRadius * 0.843), 2 * (int)((double)tempRadius * 0.843), 2 * (int)((double)tempRadius * 0.843), 0, 90);
        g2.setPaint(p2);
        g2.fillArc(x - (int)((double)tempRadius * 0.843), y - (int)((double)tempRadius * 0.843), 2 * (int)((double)tempRadius * 0.843), 2 * (int)((double)tempRadius * 0.843), 90, 90);
        tempRadius = (int)((double)height * 0.14705882352941177);
        p = new GradientPaint(x - tempRadius, y - tempRadius, new Color(0xFFFFFF), x + tempRadius, y, new Color(0x333333));
        g2.setPaint(p);
        g2.fillArc(x - tempRadius, y - tempRadius, 2 * tempRadius, 2 * tempRadius, 0, 180);
    }

    public Paint getBorderPaint() {
        return this.borderPaint;
    }

    public Paint getFillPaint() {
        return this.fillPaint;
    }

    public void setBorderPaint(Paint paint) {
        this.borderPaint = paint;
    }

    public void setFillPaint(Paint paint) {
        this.fillPaint = paint;
    }
}

