/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing.plaf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.UIManager;

class ImageArrowButton
extends JButton {
    private static final long serialVersionUID = -6834847844978005443L;
    protected Dimension iconSize = this.getIconSize();
    protected static final Color OUTERBORDER = new Color(180, 180, 180);
    protected static final Color INNERBORDER = new Color(214, 213, 201);
    protected static final Color LIGHTSHADOW = Color.WHITE;
    protected static final Color INNERSHADOW = new Color(248, 249, 244);
    protected int direction;

    public ImageArrowButton(int direction) {
        this.setRequestFocusEnabled(false);
        this.setDirection(direction);
        this.setBackground(new Color(234, 234, 227));
    }

    protected Dimension getIconSize() {
        return new Dimension(8, 5);
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int dir) {
        this.direction = dir;
        this.validate();
    }

    @Override
    public void paint(Graphics g) {
        int w = this.getSize().width;
        int h = this.getSize().height;
        Color origColor = g.getColor();
        boolean isPressed = this.getModel().isPressed();
        boolean isEnabled = this.isEnabled();
        g.setColor(this.getBackground());
        g.fillRect(1, 1, w - 2, h - 2);
        int x1 = 0;
        int y1 = 0;
        int x2 = x1 + w - 1;
        int y2 = y1 + h - 1;
        if (isPressed) {
            g.setColor(OUTERBORDER);
            g.drawRect(x1, y1, x2, y2);
            g.setColor(INNERBORDER);
            g.drawLine(x1 + 1, y1 + 1, x2 - 1, y1 + 1);
            g.drawLine(x1 + 1, y2 - 1, x1 + 1, y1 + 2);
            g.setColor(LIGHTSHADOW);
            g.drawLine(x1 + 1, y2 - 1, x2 - 1, y2 - 1);
            g.drawLine(x2 - 1, y2 - 1, x2 - 1, y1 + 1);
        } else {
            g.setColor(OUTERBORDER);
            g.drawRect(x1, y1, x2, y2);
            g.setColor(LIGHTSHADOW);
            g.drawLine(x1 + 1, y1 + 1, x2 - 1, y1 + 1);
            g.drawLine(x1 + 1, y2 - 1, x1 + 1, y1 + 2);
            g.setColor(INNERBORDER);
            g.drawLine(x1 + 1, y2 - 1, x2 - 1, y2 - 1);
            g.drawLine(x2 - 1, y2 - 1, x2 - 1, y1 + 1);
        }
        if (isPressed) {
            g.translate(1, 1);
        }
        this.paintTriangle(g, (w - this.iconSize.width + 1) / 2, (h - this.iconSize.height + 1) / 2, isEnabled);
        if (isPressed) {
            g.translate(-1, -1);
        }
        g.setColor(origColor);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(18, 8);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(18, 8);
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public void paintTriangle(Graphics g, int x, int y, boolean isEnabled) {
        Image arrowNorth = ((ImageIcon)UIManager.get("ImageArrowButton.northIcon")).getImage();
        Image arrowSouth = ((ImageIcon)UIManager.get("ImageArrowButton.southIcon")).getImage();
        Image arrowWest = ((ImageIcon)UIManager.get("ImageArrowButton.westIcon")).getImage();
        Image arrowNorthDisable = ((ImageIcon)UIManager.get("ImageArrowButton.disableNorthIcon")).getImage();
        Image arrowSouthDisable = ((ImageIcon)UIManager.get("ImageArrowButton.disableSouthIcon")).getImage();
        Image triangle = arrowNorth;
        switch (this.direction) {
            case 1: {
                triangle = isEnabled ? arrowNorth : arrowNorthDisable;
                break;
            }
            case 5: {
                triangle = isEnabled ? arrowSouth : arrowSouthDisable;
                break;
            }
            case 7: {
                triangle = arrowWest;
            }
        }
        g.drawImage(triangle, x, y, this);
    }
}

