/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing.plaf;

import com.kingdee.bos.ctrl.common.util.STConverter;
import com.kingdee.bos.ctrl.swing.plaf.KingdeeBorders;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class KingdeeButtonUI
extends BasicButtonUI {
    public static final int TEXTSHIFTOFFSET = 1;
    private static final int MAX_WIDTH = 149;
    private static final int MAX_HEIGHT = 21;
    private static final int MIN_WIDTH = 73;
    private static final int MIN_HEIGHT = 21;
    private static final int PRE_WIDTH = 73;
    private static final int PRE_HEIGHT = 21;
    private BasicStroke basicStroke = null;
    private Color disableForeground = null;
    private Color disableBackground = null;
    private static final Dimension MAX_DIMENSION = new Dimension(149, 21);
    private static final Dimension MIN_DIMENSION = new Dimension(73, 21);
    private static final Dimension PRE_DIMENSION = new Dimension(73, 21);
    private static KingdeeButtonUI kdButtonUI = new KingdeeButtonUI();

    public static ComponentUI createUI(JComponent c) {
        return kdButtonUI;
    }

    @Override
    protected void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        b.setRolloverEnabled(true);
        b.setOpaque(false);
        String pp = this.getPropertyPrefix();
        this.basicStroke = new BasicStroke(1.0f, 1, 1, 0.0f, new float[]{1.0f}, 0.0f);
        this.defaultTextIconGap = (Integer)UIManager.get(pp + "textIconGap");
        this.defaultTextShiftOffset = 1;
        b.setBorder(KingdeeBorders.createRomanticButtonBorder());
        this.disableForeground = UIManager.getColor("Button.disableForeground");
        this.disableForeground = this.disableForeground != null ? this.disableForeground : Color.decode("#6E6E6E");
        this.disableBackground = UIManager.getColor("Button.disableBackground");
        this.disableBackground = this.disableBackground != null ? this.disableBackground : Color.decode("#EEEEEE");
        this.setTravelsalKeys(b);
    }

    private void setTravelsalKeys(AbstractButton b) {
        CtrlSwingUtilities.addManagingFocusForwardTraversalKeys(b, KeyStroke.getKeyStroke(39, 0));
        CtrlSwingUtilities.addManagingFocusBackwardTraversalKeys(b, KeyStroke.getKeyStroke(37, 0));
    }

    @Override
    protected void paintIcon(Graphics g, JComponent c, Rectangle iconRect) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        if (model.isPressed() && model.isArmed()) {
            this.setTextShiftOffset();
        }
        super.paintIcon(g, c, iconRect);
    }

    @Override
    protected void paintText(Graphics g, AbstractButton b, Rectangle textRect, String text) {
        String toPaintText = text;
        if (CtrlSwingUtilities.getConvertType() == 0) {
            toPaintText = STConverter.tc2sc((String)text);
        } else if (CtrlSwingUtilities.getConvertType() == 1) {
            toPaintText = STConverter.sc2tc((String)text);
        }
        ButtonModel model = b.getModel();
        FontMetrics fm = g.getFontMetrics();
        int mnemonicIndex = b.getDisplayedMnemonicIndex();
        if (model.isPressed() && model.isArmed()) {
            this.setTextShiftOffset();
        }
        if (model.isEnabled()) {
            if (model.isRollover()) {
                g.setColor(UIManager.getColor("Button.mouseoverForeground"));
                if (toPaintText != null && !toPaintText.equals("")) {
                    BasicGraphicsUtils.drawStringUnderlineCharAt(g, toPaintText, mnemonicIndex, textRect.x + this.getTextShiftOffset(), textRect.y + fm.getAscent() + this.getTextShiftOffset());
                }
            } else {
                g.setColor(b.getForeground());
                if (toPaintText != null && !toPaintText.equals("")) {
                    BasicGraphicsUtils.drawStringUnderlineCharAt(g, toPaintText, mnemonicIndex, textRect.x + this.getTextShiftOffset(), textRect.y + fm.getAscent() + this.getTextShiftOffset());
                }
            }
        } else {
            g.setColor(this.disableForeground);
            if (toPaintText != null && !toPaintText.equals("")) {
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, toPaintText, mnemonicIndex, textRect.x, textRect.y + fm.getAscent());
            }
        }
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        boolean b = this.isLimitedSize(c);
        if (b) {
            return MAX_DIMENSION;
        }
        return super.getMaximumSize(c);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        boolean b = this.isLimitedSize(c);
        if (b) {
            return MIN_DIMENSION;
        }
        return super.getMinimumSize(c);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        boolean b = this.isLimitedSize(c);
        if (b) {
            return this.getSelfPreSize(this.getSuperPreferredSize(c));
        }
        return super.getPreferredSize(c);
    }

    private boolean isLimitedSize(JComponent c) {
        if (c != null) {
            Object v = c.getClientProperty("isLimitingSize");
            if (v != null && v instanceof Boolean) {
                return (Boolean)v;
            }
            return false;
        }
        return false;
    }

    private Dimension getSuperPreferredSize(JComponent c) {
        Dimension dim = super.getPreferredSize(c);
        if (dim != null) {
            return dim;
        }
        return MAX_DIMENSION;
    }

    private Dimension getSelfPreSize(Dimension newValue) {
        if (newValue != null) {
            int tempW = newValue.width;
            int tempH = newValue.height;
            if (tempW > 73) {
                tempW = 149;
            } else if (tempW < 73) {
                tempW = 73;
            }
            if (tempH > 21) {
                tempH = 21;
            } else if (tempH < 21) {
                tempH = 21;
            }
            return new Dimension(tempW, tempH);
        }
        return PRE_DIMENSION;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        this.fillContentArea(g, (AbstractButton)c, c.getBackground());
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        if (model.isRollover()) {
            g.setColor(UIManager.getColor("Button.mouseoverBackground"));
            g.fillRect(2, 2, b.getWidth() - 4, b.getHeight() - 4);
        }
        super.paint(g, c);
    }

    @Override
    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        Rectangle focusRect = new Rectangle();
        String text = b.getText();
        if (CtrlSwingUtilities.getConvertType() == 0) {
            text = STConverter.tc2sc((String)text);
        } else if (CtrlSwingUtilities.getConvertType() == 1) {
            text = STConverter.sc2tc((String)text);
        }
        boolean isIcon = b.getIcon() != null;
        ButtonModel model = b.getModel();
        FontMetrics fm = g.getFontMetrics();
        int mnemonicIndex = b.getDisplayedMnemonicIndex();
        if (model.isPressed()) {
            g.setColor(UIManager.getColor("Button.mousedownBackground"));
            g.fillRect(2, 2, b.getWidth() - 4, b.getHeight() - 4);
            if (text != null && !"".equals(text)) {
                if (!isIcon) {
                    focusRect.setBounds(textRect);
                    g.setColor(UIManager.getColor("Button.mousedownForeground"));
                    BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemonicIndex, textRect.x + this.getTextShiftOffset(), textRect.y + fm.getAscent() + this.getTextShiftOffset());
                } else {
                    focusRect.setBounds(iconRect.union(textRect));
                }
            } else if (isIcon) {
                focusRect.setBounds(iconRect);
            }
        } else if (model.isRollover()) {
            g.setColor(UIManager.getColor("Button.mouseoverBackground"));
            g.fillRect(2, 2, b.getWidth() - 4, b.getHeight() - 4);
            if (text != null && !"".equals(text)) {
                if (!isIcon) {
                    focusRect.setBounds(textRect);
                    g.setColor(UIManager.getColor("Button.mouseoverForeground"));
                    BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemonicIndex, textRect.x + this.getTextShiftOffset(), textRect.y + fm.getAscent() + this.getTextShiftOffset());
                } else {
                    focusRect.setBounds(iconRect.union(textRect));
                }
            } else if (isIcon) {
                focusRect.setBounds(iconRect);
            }
        } else {
            g.setColor(UIManager.getColor("Button.focusBackground"));
            g.fillRect(2, 2, b.getWidth() - 4, b.getHeight() - 4);
            if (text != null && !"".equals(text)) {
                if (!isIcon) {
                    focusRect.setBounds(textRect);
                    g.setColor(UIManager.getColor("Button.focusForeground"));
                    BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemonicIndex, textRect.x + this.getTextShiftOffset(), textRect.y + fm.getAscent() + this.getTextShiftOffset());
                } else {
                    focusRect.setBounds(iconRect.union(textRect));
                }
            } else if (isIcon) {
                focusRect.setBounds(iconRect);
            }
        }
        this.paintIcon(g, b, iconRect);
        this.paintText(g, b, textRect, text);
        ((Graphics2D)g).setStroke(this.basicStroke);
        g.setColor(UIManager.getColor("Button.verticalLineColor"));
        g.drawRect(focusRect.x - 4, focusRect.y + 2, focusRect.width + 8, focusRect.height - 3);
    }

    protected void fillContentArea(Graphics g, AbstractButton b, Color fillColor) {
        Insets margin = b.getMargin();
        Insets insets = b.getInsets();
        Dimension size = b.getSize();
        if (b.isContentAreaFilled()) {
            g.setColor(fillColor);
            g.fillRect(insets.left - margin.left, insets.top - margin.top, size.width - (insets.left - margin.left) - (insets.right - margin.right), size.height - (insets.top - margin.top) - (insets.bottom - margin.bottom));
        }
    }
}

