/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing.plaf;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuBarUI;

public class KingdeeMenuBarUI
extends BasicMenuBarUI {
    public static final int SHADOW_HORIZONTAL = 1;
    public static final int SHADOW_VERTICAL = 2;
    private Color pointerColor = null;
    private Color shadowPointerColor = null;
    private Color shadowColor = null;
    private Color darkShadowColor = null;
    private JComponent c;
    private Color firstShadowColor = null;
    private Color secondShadowColor = null;
    private Color thirdShadowColor = null;
    private Color fourthShadowColor = null;
    private Color fifthsShadowColor = null;
    private int shadowOrientation = 1;

    public KingdeeMenuBarUI(JComponent c) {
        this.c = c;
    }

    public static ComponentUI createUI(JComponent c) {
        return new KingdeeMenuBarUI(c);
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
    }

    @Override
    public void installDefaults() {
        super.installDefaults();
        this.initSelfColors();
        this.c.setBorder(null);
    }

    @Override
    public void uninstallDefaults() {
        super.uninstallDefaults();
    }

    protected void initSelfColors() {
        this.pointerColor = UIManager.getColor("MenuBar.dotColor");
        this.pointerColor = this.pointerColor != null ? this.pointerColor : Color.decode("#7386A5");
        this.shadowPointerColor = UIManager.getColor("MenuBar.shadowDotColor");
        this.shadowPointerColor = this.shadowPointerColor != null ? this.shadowPointerColor : Color.decode("#002549");
        this.shadowColor = UIManager.getColor("MenuBar.backgroundShadow");
        this.shadowColor = this.shadowColor != null ? this.shadowColor : Color.decode("#E6EDF3");
        this.darkShadowColor = UIManager.getColor("MenuBar.backgroundDarkShadow");
        this.darkShadowColor = this.darkShadowColor != null ? this.darkShadowColor : Color.decode("#D3E0EB");
        this.firstShadowColor = UIManager.getColor("MenuBar.firstShadowColor");
        if (this.firstShadowColor == null) {
            this.firstShadowColor = Color.decode("#E6EDF3");
        }
        this.secondShadowColor = UIManager.getColor("MenuBar.secondShadowColor");
        if (this.secondShadowColor == null) {
            this.secondShadowColor = Color.decode("#E5EDF3");
        }
        this.thirdShadowColor = UIManager.getColor("MenuBar.thirdShadowColor");
        if (this.thirdShadowColor == null) {
            this.thirdShadowColor = Color.decode("#E4EBF2");
        }
        this.fourthShadowColor = UIManager.getColor("MenuBar.fourthShadowColor");
        if (this.fourthShadowColor == null) {
            this.fourthShadowColor = Color.decode("#E2E9F1");
        }
        this.fifthsShadowColor = UIManager.getColor("MenuBar.fifthsShadowColor");
        if (this.fifthsShadowColor == null) {
            this.fifthsShadowColor = Color.decode("#D3E0EB");
        }
        this.shadowOrientation = UIManager.getInt("MenuBar.shadowOrientation");
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        this.paintSelfBackground(g);
    }

    protected void paintSelfBackground(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        Paint oldPaint = g2d.getPaint();
        Rectangle rect = this.c.getBounds();
        if (this.shadowOrientation == 2) {
            int height = this.c.getHeight();
            float perHeight1 = 13.0f;
            float perHeight2 = 1.0f;
            float perHeight3 = 11.0f;
            float perHeight4 = 1.0f;
            float x0 = 0.0f;
            float y0 = 0.0f;
            float x1 = x0;
            float y1 = y0 + perHeight1;
            float x2 = x1;
            float y2 = y1 + perHeight2;
            float x3 = x2;
            float y3 = y2 + perHeight3;
            float x4 = x3;
            float y4 = y3 + perHeight4;
            GradientPaint gradient = new GradientPaint(x0, y0, this.firstShadowColor, x1, y1, this.secondShadowColor);
            g2d.setPaint(gradient);
            g2d.fillRect((int)x0, (int)y0, rect.width, (int)perHeight1);
            gradient = new GradientPaint(x1, y1, this.secondShadowColor, x2, y2, this.thirdShadowColor);
            g2d.setPaint(gradient);
            g2d.fillRect((int)x1, (int)y1, rect.width, (int)perHeight2);
            gradient = new GradientPaint(x2, y2, this.thirdShadowColor, x3, y3, this.fourthShadowColor);
            g2d.setPaint(gradient);
            g2d.fillRect((int)x2, (int)y2, rect.width, (int)perHeight3);
            gradient = new GradientPaint(x3, y3, this.fourthShadowColor, x4, y4, this.fifthsShadowColor);
            g2d.setPaint(gradient);
            g2d.fillRect((int)x3, (int)y3, rect.width, height - (int)y3);
        } else if (this.shadowOrientation == 1) {
            int width = this.c.getWidth();
            int perWidth = width / 4;
            float x0 = 0.0f;
            float y0 = 0.0f;
            float x1 = x0 + (float)perWidth;
            float y1 = y0;
            float x2 = x1 + (float)perWidth;
            float y2 = y1;
            float x3 = x2 + (float)perWidth;
            float y3 = y2;
            float x4 = x3 + (float)perWidth;
            float y4 = y3;
            GradientPaint gradient = new GradientPaint(x0, y0, this.firstShadowColor, x1, y1, this.secondShadowColor);
            g2d.setPaint(gradient);
            g2d.fillRect((int)x0, (int)y0, perWidth, rect.height);
            gradient = new GradientPaint(x1, y1, this.secondShadowColor, x2, y2, this.thirdShadowColor);
            g2d.setPaint(gradient);
            g2d.fillRect((int)x1, (int)y1, perWidth, rect.height);
            gradient = new GradientPaint(x2, y2, this.thirdShadowColor, x3, y3, this.fourthShadowColor);
            g2d.setPaint(gradient);
            g2d.fillRect((int)x2, (int)y2, perWidth, rect.height);
            gradient = new GradientPaint(x3, y3, this.fourthShadowColor, x4, y4, this.fifthsShadowColor);
            g2d.setPaint(gradient);
            g2d.fillRect((int)x3, (int)y3, width - (int)x3, rect.height);
        }
        g2d.setPaint(oldPaint);
    }

    protected void paintPointer(Graphics g) {
        Color old = g.getColor();
        g.setColor(this.pointerColor);
        g.fillRect(9, 9, 2, 2);
        g.fillRect(9, 13, 2, 2);
        g.fillRect(9, 17, 2, 2);
        g.fillRect(9, 21, 2, 2);
        g.setColor(this.shadowPointerColor);
        g.fillRect(8, 8, 2, 2);
        g.fillRect(8, 12, 2, 2);
        g.fillRect(8, 16, 2, 2);
        g.fillRect(8, 20, 2, 2);
        g.setColor(old);
    }
}

