/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing.plaf;

import com.kingdee.bos.ctrl.swing.plaf.KingdeeMultiLangBoxUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.UIManager;

public class MultiLangIcon
implements Icon {
    public static final MultiLangIcon NULLICON = new MultiLangIcon();
    protected static final Color BKCOLOR = new Color(239, 235, 231);
    protected static final Color DISABLECOLOR = new Color(0xDDDDDD);
    protected static final Color DISABLETEXT = Color.DARK_GRAY;
    protected static final int WIDTH = 16;
    protected static final int HEIGHT = 16;
    protected String languageName;

    public MultiLangIcon() {
        this.setLanguageName(null);
    }

    public MultiLangIcon(Locale l) {
        if (l == null) {
            this.setLanguageName(null);
        } else {
            this.setLanguageName(l.getDisplayLanguage(Locale.ENGLISH));
        }
    }

    public MultiLangIcon(String langName) {
        if (langName == null) {
            this.setLanguageName(null);
        } else {
            this.setLanguageName(langName);
        }
    }

    protected void setLanguageName(String name) {
        if (name == null) {
            this.languageName = "NA";
        } else if (name.length() > 2) {
            this.languageName = name.substring(0, 2);
            if ("en_US".equalsIgnoreCase(name)) {
                this.languageName = "en";
            } else if ("zh_CN".equalsIgnoreCase(name)) {
                this.languageName = "zh";
            } else if ("zh_TW".equalsIgnoreCase(name)) {
                this.languageName = "tw";
            }
        } else {
            this.languageName = name;
        }
        this.languageName = this.languageName.toUpperCase();
    }

    @Override
    public int getIconHeight() {
        return 16;
    }

    @Override
    public int getIconWidth() {
        return 16;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        g.translate(x, y);
        Font oldFont = g.getFont();
        Font newFont = new Font("Tahoma", 0, 11);
        g.setFont(newFont);
        FontMetrics fm = g.getFontMetrics();
        int h = fm.getHeight();
        int w = fm.stringWidth(this.languageName);
        boolean isInbutton = c instanceof KingdeeMultiLangBoxUI.MultiLangBoxButton;
        boolean isEnabled = c.isEnabled();
        boolean isPressed = false;
        boolean isRollover = false;
        if (!isInbutton) {
            if (isEnabled) {
                g.setColor(BKCOLOR);
            } else {
                g.setColor(DISABLECOLOR);
            }
            g.fillRect(0, 0, 16, 16);
        } else {
            AbstractButton button = (AbstractButton)c;
            ButtonModel model = button.getModel();
            isPressed = model.isPressed() && model.isArmed();
            boolean bl = isRollover = model.isRollover() && button.isRolloverEnabled();
        }
        if (isEnabled) {
            if (isRollover) {
                if (isPressed) {
                    g.setColor(UIManager.getColor("MultiLangBox.mousedownForeground"));
                } else {
                    g.setColor(UIManager.getColor("MultiLangBox.mouseoverForeground"));
                }
            } else {
                g.setColor(UIManager.getColor("MultiLangBox.initForeground"));
            }
        } else {
            g.setColor(UIManager.getColor("MultiLangBox.disableForeground"));
        }
        g.drawString(this.languageName, (16 - w + 1) / 2, (16 - h) / 2 + fm.getAscent());
        if (!isInbutton) {
            g.setColor(UIManager.getColor("MultiLangBox.initBorderColor"));
            g.drawLine(0, 15, 15, 15);
            g.drawLine(15, 0, 15, 15);
            g.setColor(UIManager.getColor("MultiLangBox.initLightBorderColor"));
            g.drawLine(0, 0, 15, 0);
            g.drawLine(0, 0, 0, 15);
        }
        g.translate(-x, -y);
        g.setFont(oldFont);
    }
}

