/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing.tree;

import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeCellRenderer;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.CellEditorListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.FontUIResource;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;

public class DefaultKingdeeTreeCellEditor
implements ActionListener,
TreeCellEditor,
TreeSelectionListener {
    protected TreeCellEditor realEditor;
    protected DefaultKingdeeTreeCellRenderer renderer;
    protected Container editingContainer;
    protected transient Component editingComponent;
    protected boolean canEdit;
    protected transient int offset;
    protected transient KDTree tree;
    protected transient TreePath lastPath;
    protected transient Timer timer;
    protected transient int lastRow;
    protected Color borderSelectionColor;
    protected transient Icon editingIcon;
    protected Font font;

    public DefaultKingdeeTreeCellEditor(JTree tree, DefaultKingdeeTreeCellRenderer renderer) {
        this(tree, renderer, null);
    }

    public DefaultKingdeeTreeCellEditor(JTree tree, DefaultKingdeeTreeCellRenderer renderer, TreeCellEditor editor) {
        this.renderer = renderer;
        this.realEditor = editor;
        if (this.realEditor == null) {
            this.realEditor = this.createTreeCellEditor();
        }
        this.editingContainer = this.createContainer();
        this.setTree((KDTree)tree);
        this.setBorderSelectionColor(UIManager.getColor("Tree.editorBorderSelectionColor"));
    }

    public void setBorderSelectionColor(Color newColor) {
        this.borderSelectionColor = newColor;
    }

    public Color getBorderSelectionColor() {
        return this.borderSelectionColor;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Font getFont() {
        return this.font;
    }

    @Override
    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        this.setTree((KDTree)tree);
        this.lastRow = row;
        this.determineOffset((KDTree)tree, value, isSelected, expanded, leaf, row);
        if (this.editingComponent != null) {
            this.editingContainer.remove(this.editingComponent);
        }
        this.editingComponent = this.realEditor.getTreeCellEditorComponent(tree, value, isSelected, expanded, leaf, row);
        TreePath newPath = tree.getPathForRow(row);
        this.canEdit = this.lastPath != null && newPath != null && this.lastPath.equals(newPath);
        Font font = this.getFont();
        if (font == null) {
            if (this.renderer != null) {
                font = this.renderer.getFont();
            }
            if (font == null) {
                font = tree.getFont();
            }
        }
        this.editingContainer.setFont(font);
        this.prepareForEditing();
        return this.editingContainer;
    }

    @Override
    public Object getCellEditorValue() {
        return this.realEditor.getCellEditorValue();
    }

    @Override
    public boolean isCellEditable(EventObject event) {
        boolean retValue = false;
        boolean editable = false;
        if (event != null && event.getSource() instanceof KDTree) {
            this.setTree((KDTree)event.getSource());
            if (event instanceof MouseEvent) {
                TreePath path = this.tree.getPathForLocation(((MouseEvent)event).getX(), ((MouseEvent)event).getY());
                boolean bl = editable = this.lastPath != null && path != null && this.lastPath.equals(path);
            }
        }
        if (!this.realEditor.isCellEditable(event)) {
            return false;
        }
        if (this.canEditImmediately(event)) {
            retValue = true;
        } else if (editable && this.shouldStartEditingTimer(event)) {
            this.startEditingTimer();
        } else if (this.timer != null && this.timer.isRunning()) {
            this.timer.stop();
        }
        if (retValue) {
            this.prepareForEditing();
        }
        return retValue;
    }

    @Override
    public boolean shouldSelectCell(EventObject event) {
        return this.realEditor.shouldSelectCell(event);
    }

    @Override
    public boolean stopCellEditing() {
        if (this.realEditor.stopCellEditing()) {
            this.cleanupAfterEditing();
            return true;
        }
        return false;
    }

    @Override
    public void cancelCellEditing() {
        this.realEditor.cancelCellEditing();
        this.cleanupAfterEditing();
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this.realEditor.addCellEditorListener(l);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this.realEditor.removeCellEditorListener(l);
    }

    public CellEditorListener[] getCellEditorListeners() {
        return ((DefaultCellEditor)this.realEditor).getCellEditorListeners();
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        if (this.tree != null) {
            this.lastPath = this.tree.getSelectionCount() == 1 ? this.tree.getSelectionPath() : null;
        }
        if (this.timer != null) {
            this.timer.stop();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.tree != null && this.lastPath != null) {
            this.tree.startEditingAtPath(this.lastPath);
        }
    }

    protected void setTree(KDTree newTree) {
        if (this.tree != newTree) {
            if (this.tree != null) {
                this.tree.removeTreeSelectionListener(this);
            }
            this.tree = newTree;
            if (this.tree != null) {
                this.tree.addTreeSelectionListener(this);
            }
            if (this.timer != null) {
                this.timer.stop();
            }
        }
    }

    protected boolean shouldStartEditingTimer(EventObject event) {
        if (event instanceof MouseEvent && SwingUtilities.isLeftMouseButton((MouseEvent)event)) {
            MouseEvent me = (MouseEvent)event;
            return me.getClickCount() == 1 && this.inHitRegion(me.getX(), me.getY());
        }
        return false;
    }

    protected void startEditingTimer() {
        if (this.timer == null) {
            this.timer = new Timer(1200, this);
            this.timer.setRepeats(false);
        }
        this.timer.start();
    }

    protected boolean canEditImmediately(EventObject event) {
        if (event instanceof MouseEvent && SwingUtilities.isLeftMouseButton((MouseEvent)event)) {
            MouseEvent me = (MouseEvent)event;
            return me.getClickCount() > 2 && this.inHitRegion(me.getX(), me.getY()) && this.tree.getSelectionCount() == 1;
        }
        return event == null;
    }

    protected boolean inHitRegion(int x, int y) {
        Rectangle bounds;
        int row = this.tree.getRowForLocation(x, y);
        return row == -1 || this.tree == null || (bounds = this.tree.getRowBounds(row)) == null || x > bounds.x + this.offset + (this.tree.isShowCheckBox() ? 20 : 0) || this.offset >= bounds.width - 5;
    }

    protected void determineOffset(KDTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        if (this.renderer != null) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)tree.getSelectionPath().getLastPathComponent();
            this.editingIcon = node.getRenderIcon(tree.getModel().isLeaf(node), expanded);
            this.offset = this.editingIcon != null ? this.editingIcon.getIconWidth() + 2 : 2;
        } else {
            this.editingIcon = null;
            this.offset = 0;
        }
    }

    protected void prepareForEditing() {
        if (this.editingComponent != null) {
            this.editingContainer.add(this.editingComponent);
        }
    }

    protected Container createContainer() {
        return new EditorContainer();
    }

    protected TreeCellEditor createTreeCellEditor() {
        Border aBorder = UIManager.getBorder("Tree.editorBorder");
        DefaultCellEditor editor = new DefaultCellEditor(new DefaultTextField(aBorder)){
            private static final long serialVersionUID = 3961767050811504387L;

            @Override
            public boolean shouldSelectCell(EventObject event) {
                boolean retValue = super.shouldSelectCell(event);
                return retValue;
            }
        };
        return editor;
    }

    private void cleanupAfterEditing() {
        if (this.editingComponent != null) {
            this.editingContainer.remove(this.editingComponent);
        }
        this.editingComponent = null;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        Vector<Object> values = new Vector<Object>();
        s.defaultWriteObject();
        if (this.realEditor != null && this.realEditor instanceof Serializable) {
            values.addElement("realEditor");
            values.addElement(this.realEditor);
        }
        s.writeObject(values);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        Vector values = (Vector)s.readObject();
        int indexCounter = 0;
        int maxCounter = values.size();
        if (indexCounter < maxCounter && values.elementAt(indexCounter).equals("realEditor")) {
            this.realEditor = (TreeCellEditor)values.elementAt(++indexCounter);
            ++indexCounter;
        }
    }

    public class EditorContainer
    extends Container {
        private static final long serialVersionUID = 6535197813682922162L;

        public EditorContainer() {
            this.setLayout(new FlowLayout());
        }

        @Override
        public void paint(Graphics g) {
            Color background;
            Dimension size = this.getSize();
            if (DefaultKingdeeTreeCellEditor.this.editingIcon != null) {
                int yLoc = (this.getSize().height - DefaultKingdeeTreeCellEditor.this.editingIcon.getIconHeight()) / 2;
                DefaultKingdeeTreeCellEditor.this.editingIcon.paintIcon(this, g, 0, yLoc);
            }
            if ((background = DefaultKingdeeTreeCellEditor.this.getBorderSelectionColor()) != null) {
                g.setColor(background);
                g.drawRect(0, 0, size.width - 1, size.height - 1);
            }
            super.paint(g);
        }

        @Override
        public void doLayout() {
            if (DefaultKingdeeTreeCellEditor.this.editingComponent != null) {
                Dimension cSize = this.getSize();
                DefaultKingdeeTreeCellEditor.this.editingComponent.getPreferredSize();
                DefaultKingdeeTreeCellEditor.this.editingComponent.setLocation(DefaultKingdeeTreeCellEditor.this.offset, 0);
                DefaultKingdeeTreeCellEditor.this.editingComponent.setBounds(DefaultKingdeeTreeCellEditor.this.offset, 0, cSize.width - DefaultKingdeeTreeCellEditor.this.offset, cSize.height);
            }
        }

        @Override
        public Dimension getPreferredSize() {
            if (DefaultKingdeeTreeCellEditor.this.editingComponent != null) {
                Dimension rSize;
                Dimension pSize = DefaultKingdeeTreeCellEditor.this.editingComponent.getPreferredSize();
                pSize.width += DefaultKingdeeTreeCellEditor.this.offset + 5;
                Dimension dimension = rSize = DefaultKingdeeTreeCellEditor.this.renderer != null ? DefaultKingdeeTreeCellEditor.this.renderer.getPreferredSize() : null;
                if (rSize != null) {
                    pSize.height = Math.max(pSize.height, rSize.height);
                }
                if (DefaultKingdeeTreeCellEditor.this.editingIcon != null) {
                    pSize.height = Math.max(pSize.height, DefaultKingdeeTreeCellEditor.this.editingIcon.getIconHeight());
                }
                pSize.width = Math.max(pSize.width, 100);
                return pSize;
            }
            return new Dimension(0, 0);
        }
    }

    public class DefaultTextField
    extends KDTextField {
        private static final long serialVersionUID = -1150410981502245481L;
        protected Border border;

        public DefaultTextField(Border border) {
        }

        @Override
        public void setBorder(Border border) {
            super.setBorder(border);
            this.border = border;
        }

        @Override
        public Border getBorder() {
            return this.border;
        }

        @Override
        public Font getFont() {
            Container parent;
            Font font = super.getFont();
            if (font instanceof FontUIResource && (parent = this.getParent()) != null && parent.getFont() != null) {
                font = parent.getFont();
            }
            return font;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            if (DefaultKingdeeTreeCellEditor.this.renderer != null && DefaultKingdeeTreeCellEditor.this.getFont() == null) {
                Dimension rSize = DefaultKingdeeTreeCellEditor.this.renderer.getPreferredSize();
                size.height = rSize.height;
            }
            return size;
        }
    }
}

