/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing.tree;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.swing.tree.ITreeNode;
import java.awt.Color;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class DefaultKingdeeTreeNode
extends DefaultMutableTreeNode
implements ITreeNode {
    private static final long serialVersionUID = 2214567336490621004L;
    protected int checkedValue;
    protected Icon normalIcon;
    protected Icon customOpenIcon;
    protected Icon customClosedIcon;
    protected transient Color textColor = UIManager.getColor("Tree.textForeground");
    protected boolean textBold = false;
    protected String text = "";
    protected boolean checkBoxVisible = true;
    protected boolean checkBoxEnabled = true;

    public DefaultKingdeeTreeNode(Object userObject, Icon icon) {
        this(userObject, icon, false, true);
    }

    public DefaultKingdeeTreeNode() {
        this(null);
    }

    public DefaultKingdeeTreeNode(Object userObject) {
        this(userObject, null, false, true);
    }

    public DefaultKingdeeTreeNode(Object userObject, Icon icon, boolean checked, boolean allowsChildren) {
        super(userObject, allowsChildren);
        this.checkedValue = checked ? 32 : 16;
        this.normalIcon = icon;
        if (userObject != null) {
            this.text = userObject.toString();
        }
    }

    public DefaultKingdeeTreeNode(Object userObject, Color textColor, boolean textBold, Icon icon, boolean checked, boolean allowsChildren) {
        super(userObject, allowsChildren);
        this.checkedValue = checked ? 32 : 16;
        this.normalIcon = icon;
        this.textColor = textColor;
        this.textBold = textBold;
        if (userObject != null) {
            this.text = userObject.toString();
        }
    }

    public DefaultKingdeeTreeNode(Object userObject, Color textColor, boolean textBold, Icon icon) {
        this(userObject, textColor, textBold, icon, false, true);
    }

    public DefaultKingdeeTreeNode(Object userObject, Color textColor, boolean textBold) {
        this(userObject, textColor, textBold, null, false, true);
    }

    @Override
    public boolean isChecked() {
        return this.checkedValue != 16;
    }

    @Override
    public void setChecked(boolean value) {
        this.checkedValue = value ? 32 : 16;
    }

    public void setChecked(int value) {
        if (value == 32 || value == 16 || value == 64) {
            this.checkedValue = value;
        }
    }

    public int getCheckedValue() {
        return this.checkedValue;
    }

    public void syncChecked() {
        this.syncChilds(this, this.isChecked());
        this.syncParent(this);
    }

    private void syncChilds(DefaultKingdeeTreeNode node, boolean value) {
        Enumeration<TreeNode> enumeration = node.children();
        while (enumeration.hasMoreElements()) {
            DefaultKingdeeTreeNode childnode = (DefaultKingdeeTreeNode)enumeration.nextElement();
            if (childnode.isCheckBoxVisible() && childnode.isCheckBoxEnabled()) {
                childnode.setChecked(value);
            }
            if (childnode.getChildCount() <= 0) continue;
            this.syncChilds(childnode, value);
        }
    }

    private void syncParent(DefaultKingdeeTreeNode node) {
        DefaultKingdeeTreeNode grandParentNode;
        DefaultKingdeeTreeNode parentnode = (DefaultKingdeeTreeNode)node.getParent();
        if (parentnode == null) {
            return;
        }
        int value = node.checkedValue;
        if (parentnode.isCheckBoxEnabled() && parentnode.isCheckBoxVisible()) {
            boolean bsame = true;
            Enumeration<TreeNode> enumeration = parentnode.children();
            while (enumeration.hasMoreElements()) {
                DefaultKingdeeTreeNode childnode = (DefaultKingdeeTreeNode)enumeration.nextElement();
                if (childnode.checkedValue == value) continue;
                bsame = false;
                break;
            }
            parentnode.checkedValue = bsame ? value : 64;
        }
        if ((grandParentNode = (DefaultKingdeeTreeNode)parentnode.getParent()) != null) {
            this.syncParent(parentnode);
        }
    }

    @Override
    public Icon getCustomIcon() {
        return this.normalIcon;
    }

    @Override
    public void setCustomIcon(Icon icon) {
        this.normalIcon = icon;
    }

    @Override
    public Color getTextColor() {
        return this.textColor;
    }

    @Override
    public void setTextColor(Color color) {
        this.textColor = color;
    }

    @Override
    public boolean isTextBold() {
        return this.textBold;
    }

    @Override
    public void setTextBold(boolean bold) {
        this.textBold = bold;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void setText(String text) {
        this.text = text;
    }

    @Override
    public String toString() {
        return this.text;
    }

    @Override
    public void setUserObject(Object userObject) {
        super.setUserObject(userObject);
        if (StringUtil.isEmptyString((String)this.text) && userObject != null) {
            this.text = userObject.toString();
        }
    }

    public boolean isCheckBoxVisible() {
        return this.checkBoxVisible;
    }

    public void setCheckBoxVisible(boolean b) {
        this.checkBoxVisible = b;
    }

    public boolean isCheckBoxEnabled() {
        return this.checkBoxEnabled;
    }

    public void setCheckBoxEnabled(boolean b) {
        this.checkBoxEnabled = b;
    }

    public Icon getCustomClosedIcon() {
        return this.customClosedIcon;
    }

    public Icon getCustomOpenIcon() {
        return this.customOpenIcon;
    }

    public void setCustomClosedIcon(Icon icon) {
        this.customClosedIcon = icon;
    }

    public void setCustomOpenIcon(Icon icon) {
        this.customOpenIcon = icon;
    }

    public Icon getRenderIcon(boolean isLeaf, boolean isExpanded) {
        Icon icon = this.getCustomIcon();
        if (icon == null) {
            if (isLeaf) {
                icon = UIManager.getIcon("Tree.leafIcon");
            } else if (isExpanded) {
                icon = this.getCustomOpenIcon();
                if (icon == null) {
                    icon = UIManager.getIcon("Tree.openIcon");
                }
            } else {
                icon = this.getCustomClosedIcon();
                if (icon == null) {
                    icon = UIManager.getIcon("Tree.closedIcon");
                }
            }
        }
        return icon;
    }
}

