/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.workbench.splash;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;

class BilinearImagePainter {
    BilinearImagePainter() {
    }

    public static BufferedImage drawImageBilinear(BufferedImage image, int targetWidth, int targetHeight) {
        int h;
        int w;
        int type = image.getType();
        BufferedImage ret = image;
        BufferedImage scratchImage = null;
        Graphics2D scratchG2 = null;
        int prevW = w = ret.getWidth();
        int prevH = h = ret.getHeight();
        do {
            if (w > targetWidth) {
                if ((w /= 2) < targetWidth) {
                    w = targetWidth;
                }
            } else if ((w *= 2) > targetWidth) {
                w = targetWidth;
            }
            if (h > targetHeight) {
                if ((h /= 2) < targetHeight) {
                    h = targetHeight;
                }
            } else if ((h *= 2) > targetHeight) {
                h = targetHeight;
            }
            if (scratchImage == null) {
                scratchImage = new BufferedImage(w, h, type);
                scratchG2 = scratchImage.createGraphics();
            }
            scratchG2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            scratchG2.drawImage(ret, 0, 0, w, h, 0, 0, prevW, prevH, null);
            prevW = w;
            prevH = h;
            ret = scratchImage;
        } while (w != targetWidth || h != targetHeight);
        if (scratchG2 != null) {
            scratchG2.dispose();
        }
        if (targetWidth != ret.getWidth() || targetHeight != ret.getHeight()) {
            scratchImage = new BufferedImage(targetWidth, targetHeight, type);
            scratchG2 = scratchImage.createGraphics();
            scratchG2.drawImage((Image)ret, 0, 0, null);
            scratchG2.dispose();
            ret = scratchImage;
        }
        return ret;
    }
}

