/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.workbench.splash;

import com.kingdee.bos.ctrl.workbench.splash.AbstractSplashPanel;
import com.kingdee.bos.ctrl.workbench.splash.ImageUtil;
import com.kingdee.bos.ctrl.workbench.splash.SplashProgressBar;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;
import javax.swing.JDialog;
import org.jdesktop.animation.timing.Animator;

class MetalTexturePanel
extends AbstractSplashPanel {
    Robot robot;
    BufferedImage image1;
    Animator animator;
    int offset = 0;
    SplashProgressBar bar;
    BufferedImage innerImage;
    String appendix = "..";
    Color finalColor;
    static int size = 2;
    Paint[] gPaint = new Paint[size];
    Rectangle[] rects = new Rectangle[size];
    BufferedImage background;

    MetalTexturePanel(JDialog dialog, SplashProgressBar bar) {
        super(dialog, bar);
        try {
            this.bar = bar;
            this.setLayout(null);
            this.add(bar);
            this.bar.setBounds(50, 210, 300, 13);
            this.dialog = dialog;
            this.robot = new Robot();
            int themeIndex = MetalTexturePanel.checkTheme();
            this.finalColor = themeIndex == 0 ? Color.GREEN : (themeIndex == 3 ? new Color(50, 100, 200) : (themeIndex == 2 ? Color.ORANGE : (themeIndex == 4 ? Color.PINK : Color.BLUE)));
            this.image1 = ImageUtil.getGraphicsConfiguration().createCompatibleImage(80, 40);
            BufferedImage temp1 = ImageIO.read(MetalTexturePanel.class.getResource("brushed-metal-texture.png"));
            Graphics2D g21 = this.image1.createGraphics();
            g21.drawImage(temp1, 0, 0, 80, 40, null);
            this.innerImage = ImageIO.read(MetalTexturePanel.class.getResource("opaque-title2.png"));
            Color c1 = Color.white;
            Color c2 = this.finalColor;
            for (int i = 0; i < size; ++i) {
                this.gPaint[i] = new GradientPaint(200 * (i + 1), 0.0f, c1, 200 * i, 0.0f, c2);
                this.rects[i] = new Rectangle(200 * i, 0, 200 * (i + 1), 247);
                Color temp = c2;
                c2 = c1;
                c1 = temp;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void paint(Graphics g) {
        if (this.background == null) {
            this.background = this.robot.createScreenCapture(this.dialog.getBounds());
        }
        g.drawImage(this.background, 0, 0, null);
        super.paint(g);
        g.setColor(Color.black);
        g.drawString(this.message == null ? "" : this.message + this.appendix, (int)((double)this.getWidth() * 0.618), (int)((double)this.getHeight() * 0.8));
    }

    @Override
    protected void paintComponent(Graphics g) {
        TexturePaint paint = new TexturePaint(this.image1, new Rectangle(0, 0, this.getWidth(), 40));
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setPaint(paint);
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        Composite c = g2.getComposite();
        g2.setComposite(AlphaComposite.getInstance(3, 0.75f));
        for (int i = 0; i < size; ++i) {
            g2.setPaint(this.gPaint[i]);
            g2.fill(this.rects[i]);
        }
        g2.setComposite(c);
        g2.drawImage((Image)this.innerImage, 0, 0, null);
        g2.setComposite(AlphaComposite.getInstance(4));
        super.paintComponent(g2);
    }
}

