/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.common.dupont;

import com.kingdee.bos.bi.model.ui.dialog.dupont.SpecialStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleParser;
import java.awt.Color;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.jdom2.CDATA;
import org.jdom2.Content;
import org.jdom2.Element;

public class DupontConfig
implements Serializable {
    Map mapProps;
    private static final SpecialStyleAttributes defaultSA = SpecialStyleAttributes.getDefaultSA();
    public static final String PROP_PREDICT_FONTNAME = "predict_fontname";
    public static final String PROP_PREDICT_FONTSIZE = "predict_fontsize";
    public static final String PROP_PREDICT_FONTBOLD = "predict_fontbold";
    public static final String PROP_PREDICT_FONTITALIC = "predict_fontitalic";
    public static final String PROP_PREDICT_FONTCOLOR = "predict_fontcolor";
    public static final String PROP_PREDICT_FONTUNDERLINE = "predict_fontunderline";
    public static final String PROP_PREDICT_FONTSTRIKETHOUGH = "predict_fontstrikethrough";
    public static final String PROP_PREDICT_BACKCOLOR = "predict_backcolor";
    public static final String[] PROPS_KEY;

    public DupontConfig() {
        this.mapProps = new HashMap();
    }

    public DupontConfig(Map mapProps) {
        this.mapProps = mapProps;
    }

    public String getValue(String key) {
        if (this.mapProps == null) {
            return null;
        }
        return (String)this.mapProps.get(key);
    }

    public void setValue(String key, String value) {
        if (this.mapProps == null) {
            this.mapProps = new HashMap();
        }
        this.mapProps.put(key, value);
    }

    public void setPridictFontname(String fontname) {
        this.setValue(PROP_PREDICT_FONTNAME, fontname);
    }

    public String getPridictFontname() {
        String fontname = this.getValue(PROP_PREDICT_FONTNAME);
        if (fontname == null) {
            return defaultSA.getFontName();
        }
        return fontname;
    }

    public int getPridictFontsize() {
        String fontsize = this.getValue(PROP_PREDICT_FONTSIZE);
        if (fontsize != null) {
            try {
                return Integer.parseInt(fontsize);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultSA.getFontSize();
    }

    public void setPridictFontsize(int fontsize) {
        this.setValue(PROP_PREDICT_FONTSIZE, fontsize + "");
    }

    public Color getPridictFontColor() {
        String fontcolor = this.getValue(PROP_PREDICT_FONTCOLOR);
        if (fontcolor != null) {
            try {
                return Color.decode(fontcolor);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultSA.getFontColor();
    }

    public void setPridictFontColor(Color color) {
        this.setValue(PROP_PREDICT_FONTCOLOR, StyleParser.colorToHex((Color)color));
    }

    public boolean getPridictFontBold() {
        String isBold = this.getValue(PROP_PREDICT_FONTBOLD);
        if (isBold == null) {
            return defaultSA.isBold();
        }
        return "true".equalsIgnoreCase(isBold);
    }

    public void setPridictFontBold(boolean isBold) {
        this.setValue(PROP_PREDICT_FONTBOLD, isBold ? "true" : "false");
    }

    public boolean getPridictFontItalic() {
        String isItalic = this.getValue(PROP_PREDICT_FONTITALIC);
        if (isItalic == null) {
            return defaultSA.isItalic();
        }
        return "true".equalsIgnoreCase(isItalic);
    }

    public void setPridictFontItalic(boolean isItalic) {
        this.setValue(PROP_PREDICT_FONTITALIC, isItalic ? "true" : "false");
    }

    public void setPridictFontUnderline(boolean isUnderline) {
        this.setValue(PROP_PREDICT_FONTUNDERLINE, isUnderline ? "true" : "false");
    }

    public boolean getPridictFontUnderline() {
        String isUnderline = this.getValue(PROP_PREDICT_FONTUNDERLINE);
        if (isUnderline == null) {
            return defaultSA.isUnderline();
        }
        return "true".equalsIgnoreCase(isUnderline);
    }

    public void setPridictFontStrikethrough(boolean isStrikethrough) {
        this.setValue(PROP_PREDICT_FONTSTRIKETHOUGH, isStrikethrough ? "true" : "false");
    }

    public boolean getPridictFontStrikethrough() {
        String isStrike = this.getValue(PROP_PREDICT_FONTSTRIKETHOUGH);
        if (isStrike == null) {
            return defaultSA.isStrikeThrough();
        }
        return "true".equalsIgnoreCase(isStrike);
    }

    public Color getPridictBackColor() {
        String backColor = this.getValue(PROP_PREDICT_BACKCOLOR);
        if (backColor != null) {
            try {
                return Color.decode(backColor);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultSA.getBackground();
    }

    public void setPridictBackColor(Color color) {
        this.setValue(PROP_PREDICT_BACKCOLOR, StyleParser.colorToHex((Color)color));
    }

    public Element toXML() {
        Element r = new Element("Config");
        Object[] propKey = this.mapProps.keySet().toArray();
        for (int i = 0; i < propKey.length; ++i) {
            String v = (String)this.mapProps.get(propKey[i]);
            Element p = new Element((String)propKey[i]);
            p.addContent((Content)new CDATA(v));
            r.addContent((Content)p);
        }
        return r;
    }

    public static DupontConfig fromXML(Element e) {
        HashMap<String, String> mapProps = new HashMap<String, String>();
        for (int i = 0; i < PROPS_KEY.length; ++i) {
            Element c = e.getChild(PROPS_KEY[i]);
            if (c == null) continue;
            mapProps.put(PROPS_KEY[i], c.getTextTrim());
        }
        return new DupontConfig(mapProps);
    }

    public static DupontConfig createOldConfig() {
        DupontConfig dc = new DupontConfig();
        dc.setPridictBackColor(defaultSA.getBackground());
        dc.setPridictFontBold(defaultSA.isBold());
        dc.setPridictFontColor(defaultSA.getFontColor());
        dc.setPridictFontItalic(defaultSA.isItalic());
        dc.setPridictFontname(defaultSA.getFontName());
        dc.setPridictFontsize(defaultSA.getFontSize());
        dc.setPridictFontStrikethrough(defaultSA.isStrikeThrough());
        dc.setPridictFontUnderline(defaultSA.isUnderline());
        return dc;
    }

    static {
        defaultSA.setFontSize(12);
        defaultSA.setBackground(Color.decode("#EBF3FB"));
        defaultSA.setFontColor(Color.decode("#0063AB"));
        defaultSA.setBold(true);
        PROPS_KEY = new String[]{PROP_PREDICT_FONTNAME, PROP_PREDICT_FONTSIZE, PROP_PREDICT_FONTBOLD, PROP_PREDICT_FONTITALIC, PROP_PREDICT_FONTCOLOR, PROP_PREDICT_FONTUNDERLINE, PROP_PREDICT_FONTSTRIKETHOUGH, PROP_PREDICT_BACKCOLOR};
    }
}

