/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.common.mm.customdim;

import com.kingdee.bos.bi.model.util.StringUtil;
import java.io.Serializable;

public class GeneralDimProperty
implements Serializable {
    private String number;
    private String name;
    private String type;
    private String length;
    private String precision;
    private String fieldName;
    private boolean isInner;
    private Object value;
    private String toShowType;
    public static final String BEGIN = "(";
    public static final String MIDDLE = ",";
    public static final String END = ")";
    public static final String UNDEFINED = "unDefined";
    private static final long serialVersionUID = 4529600465401656468L;

    public GeneralDimProperty() {
    }

    public GeneralDimProperty(String name, String number, String type, String fieldName, String length, String precision, boolean isInner) {
        this.fieldName = fieldName;
        this.length = length;
        this.name = name;
        this.number = number;
        this.precision = precision;
        this.type = type;
        this.isInner = isInner;
    }

    public GeneralDimProperty(String name, String number, String type, String fieldName, String length, String precision) {
        this(name, number, type, fieldName, length, precision, false);
    }

    public boolean isInner() {
        return this.isInner;
    }

    public void setInner(boolean isInner) {
        this.isInner = isInner;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getLength() {
        return this.length;
    }

    public void setLength(String length) {
        this.length = length;
    }

    public String getPrecision() {
        return this.precision;
    }

    public void setPrecision(String precision) {
        this.precision = precision;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getRealFieldName() {
        return StringUtil.isEmpty(this.getFieldName()) ? "F" + this.getNumber() : this.getFieldName();
    }

    public String toShowType() {
        if ("nvarchar".equalsIgnoreCase(this.type)) {
            this.toShowType = "\u5b57\u7b26\u4e32(" + (this.length == null ? "255" : this.length) + END;
        } else if ("decimal".equalsIgnoreCase(this.type)) {
            this.toShowType = "\u5c0f\u6570(" + (this.length == null ? "12" : this.length) + MIDDLE + (this.precision == null ? "2" : this.precision) + END;
        } else if ("int".equalsIgnoreCase(this.type)) {
            this.toShowType = "\u6574\u6570";
        } else if ("datetime".equalsIgnoreCase(this.type)) {
            this.toShowType = "\u65f6\u95f4";
        }
        return this.toShowType == null ? UNDEFINED : this.toShowType;
    }

    public Object clone() throws CloneNotSupportedException {
        GeneralDimProperty g = new GeneralDimProperty();
        g.setNumber(this.number);
        g.setName(this.name);
        g.setType(this.type);
        g.setLength(this.length);
        g.setPrecision(this.precision);
        g.setFieldName(this.fieldName);
        g.setValue(this.value);
        g.setInner(this.isInner);
        return g;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof GeneralDimProperty) {
            GeneralDimProperty another = (GeneralDimProperty)obj;
            return StringUtil.equalsIgnoreCase(another.getType(), this.getType()) && StringUtil.equalsIgnoreCase(another.getFieldName(), this.getFieldName()) && StringUtil.equalsIgnoreCase(another.getLength(), this.getLength()) && StringUtil.equalsIgnoreCase(another.getPrecision(), this.getPrecision());
        }
        return false;
    }
}

