/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.common.mm.time.builder;

import com.kingdee.bos.bi.model.common.mm.time.TimeDimensionNode;
import com.kingdee.bos.bi.model.common.mm.time.TimeModel;
import com.kingdee.bos.bi.model.common.mm.time.TimeTreeModel;
import com.kingdee.bos.bi.model.common.mm.time.TimeUtil;
import com.kingdee.bos.bi.model.common.mm.time.builder.AbstractTimeLevel;
import java.util.Map;

public class QuarterLevel
extends AbstractTimeLevel {
    public QuarterLevel(TimeModel timeModel) {
        super(timeModel);
        this.levelCode = 3;
        this.levelName = "quarter";
        this.levelBriefNumber = "Q";
    }

    public QuarterLevel(TimeModel timeModel, Map params) {
        super(timeModel, params);
        this.levelCode = 3;
        this.levelName = "quarter";
        this.levelBriefNumber = "Q";
    }

    @Override
    protected void doBuilderFromYear(TimeDimensionNode parentNode) {
        boolean cursor = true;
        int theEnd = 4;
        this.createQuarterTreeNodes(parentNode, 1, 4);
    }

    @Override
    protected void doBuilderFromHalfYear(TimeDimensionNode parentNode) {
        int cursor = (this.prevLevel.value - 1) * 2 + 1;
        int theEnd = this.prevLevel.value * 2;
        this.createQuarterTreeNodes(parentNode, cursor, theEnd);
    }

    @Override
    protected void doBuilderFromQuarter(TimeDimensionNode parentNode) {
    }

    @Override
    protected void doBuilderFromMonth(TimeDimensionNode parentNode) {
    }

    @Override
    protected void doBuilderFromDate(TimeDimensionNode parentNode) {
    }

    private void createQuarterTreeNodes(TimeDimensionNode parentNode, int cursor, int theEnd) {
        int startQuarter = TimeUtil.getQuarter(this.startTime);
        int endQuarter = TimeUtil.getQuarter(this.endTime);
        int year = this.getYear();
        while (cursor <= theEnd) {
            if (!(this.prevLevel.isStart && cursor < startQuarter || this.prevLevel.isEnd && cursor > endQuarter)) {
                int month = (cursor - 1) * 3 + 1;
                TimeUtil.resetCalendarAll(this.calendar, year, month, 1);
                TimeDimensionNode quarterNode = new TimeDimensionNode();
                TimeTreeModel quarterModel = new TimeTreeModel();
                quarterModel.setDimensionType(parentNode.getTimeModel().getDimensionType());
                quarterNode.setTimeModel(quarterModel);
                quarterModel.setName("\u7b2c" + cursor + "\u5b63\u5ea6");
                quarterModel.setNumber(TimeUtil.getStringTime(this.calendar));
                quarterModel.setLevelName("quarter");
                quarterModel.setShortNumber(Integer.toString(cursor));
                this.addParamsForDashBoard(quarterModel);
                parentNode.addChild(quarterNode);
                if (this.nextLevel != null) {
                    this.value = cursor;
                    this.isStart = this.prevLevel.isStart && cursor == startQuarter;
                    this.isEnd = this.prevLevel.isEnd && cursor == endQuarter;
                    this.nextLevel.builder(quarterNode);
                }
            }
            ++cursor;
        }
    }
}

