/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.rt.appmodel;

import com.kingdee.bos.Context;
import com.kingdee.bos.bi.model.DB.DBUtil;
import com.kingdee.bos.bi.model.rt.appmodel.AppModel;
import com.kingdee.bos.bi.model.rt.appmodel.AppModelView;
import com.kingdee.bos.bi.model.rt.appmodel.DataRule;
import com.kingdee.bos.bi.model.rt.log.ScheduleLogger;
import com.kingdee.bos.bi.model.ui.exception.BIModelBizException;
import com.kingdee.util.db.SQLUtils;
import java.io.IOException;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.xml.sax.InputSource;

public class DataRuleSchema {
    private List dataRules;
    private String name;
    private AppModel appmodel;

    private DataRuleSchema(String name, List dataRules, AppModel appmodel) {
        this.name = name;
        this.dataRules = dataRules;
        this.appmodel = appmodel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataRuleSchema fromDB(String amid, String schemaid, Connection cn, Context ctx) throws SQLException, IOException, JDOMException {
        AppModel appmodel = new AppModel(AppModelView.fromDB(amid, ctx), ctx);
        String sql = "select FSchemaName from T_BI_AM_DR_Schema where FAMID='" + amid + "' and FSchemaID='" + schemaid + "'";
        String schemaName = DBUtil.getRecord(sql, cn).toString();
        ArrayList<DataRule> lstDr = new ArrayList<DataRule>();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            sql = "select FParameters from T_BI_AM_DR_Detail where FSchemaID='" + schemaid + "' order by FOrder ASC";
            stmt = cn.prepareStatement(sql);
            rs = stmt.executeQuery();
            int itemorder = 0;
            while (rs.next()) {
                String xml = rs.getString(1);
                StringReader read = new StringReader(xml);
                InputSource source = new InputSource(read);
                SAXBuilder sb = new SAXBuilder();
                Document doc = null;
                doc = sb.build(source);
                Element e = doc.getRootElement();
                lstDr.add(DataRule.fromNode(e, appmodel, schemaid, itemorder++, cn));
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, stmt);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        return new DataRuleSchema(schemaName, lstDr, appmodel);
    }

    public void run(Date date, Connection cn, Context ctx, Map params, Map mapDataFlag, ScheduleLogger sLog) {
        Iterator it = this.dataRules.iterator();
        String strategy = (String)params.get("FailStrategy");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        while (it.hasNext()) {
            DataRule dr = (DataRule)it.next();
            try {
                StringBuffer sbError = new StringBuffer();
                dr.calc(date, cn, ctx, params, mapDataFlag, sbError);
                if (sbError.length() <= 0) continue;
                sbError.deleteCharAt(sbError.length() - 1);
                sbError.deleteCharAt(sbError.length() - 1);
                String calTime = "\u3010" + sdf.format(date) + "\u3011";
                sLog.error(dr.getAppmodelId(), dr.getSchemaId(), dr.getItemorder(), calTime + sbError.toString());
            }
            catch (BIModelBizException e) {
                if ("abort".equalsIgnoreCase(strategy)) {
                    return;
                }
                if (!"ignore".equalsIgnoreCase(strategy)) continue;
            }
        }
    }
}

