/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.rt.bireport.calmember.zrate;

import com.kingdee.bos.Context;
import com.kingdee.bos.bi.model.common.EnumObj;
import com.kingdee.bos.bi.model.common.bireport.DimensionMember;
import com.kingdee.bos.bi.model.rt.appmodel.AppModel;
import com.kingdee.bos.bi.model.rt.appmodel.AppModelView;
import com.kingdee.bos.bi.model.rt.bireport.calmember.CalMember;
import com.kingdee.bos.bi.model.rt.bireport.calmember.CalculatorType;
import com.kingdee.bos.bi.model.rt.dim.Dimension;
import com.kingdee.bos.bi.model.rt.dim.DimensionMeta;
import com.kingdee.bos.bi.model.rt.dim.DimensionType;
import com.kingdee.bos.bi.model.rt.dim.FormatString;
import com.kingdee.bos.bi.model.rt.dim.Member;
import com.kingdee.bos.bi.model.ui.dialog.bireport.calmember.CalSelProvider;
import com.kingdee.bos.bi.model.ui.dialog.bireport.calmember.zrate.ZRateDetailPanel;
import com.kingdee.bos.bi.model.util.StringUtil;
import com.kingdee.bos.bi.model.util.XmlUtil;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class ZRateCalMember
extends CalMember {
    private String calMeasure;
    private String calDim;
    private String calDenominator;
    private int solveOrder;
    private String formatString;
    private List advances;
    private String appModelType;

    public ZRateCalMember(Context ctx, String appmodelId, Dimension dim, String name, String caption, DimensionType dt, String schema) {
        super(ctx, appmodelId, dim, name, caption, dt, CalculatorType.zRate);
        try {
            this.fromXML(schema);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
    }

    public String getCalDenominator() {
        return this.calDenominator;
    }

    public String getCalDim() {
        return this.calDim;
    }

    @Override
    public String toMDX() {
        StringBuffer sb = new StringBuffer();
        sb.append(" member [");
        sb.append("Measures].[" + this.number);
        sb.append("] as '");
        sb.append(this.getMdx());
        sb.append("'");
        sb.append(",solveOrder=" + this.solveOrder + "");
        if (!StringUtil.isEmpty(this.formatString)) {
            sb.append(",formatString='" + this.formatString + "'");
        }
        if (!StringUtil.isEmpty(this.name)) {
            sb.append(",caption='" + this.name + "'");
        }
        return sb.toString();
    }

    public CalMember getCalMember() throws SQLException {
        AppModelView views = AppModelView.fromDB(this.appmodelId, this.ctx);
        AppModel apm = new AppModel(views, this.ctx);
        Dimension dimension = apm.getDimension(this.calDim);
        return ZRateCalMember.getCalMember(this.ctx, this.appmodelId, this.calDim, null, this.calDenominator);
    }

    private String getCalMemberMdx() {
        try {
            AppModelView views = AppModelView.fromDB(this.appmodelId, this.ctx);
            AppModel apm = new AppModel(views, this.ctx);
            Dimension dimension = apm.getDimension(this.calDim);
            CalMember calMember = ZRateCalMember.getCalMember(this.ctx, this.appmodelId, this.calDim, null, this.calDenominator);
            if (calMember != null) {
                return calMember.toMDX(dimension, this.ctx);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return "";
    }

    private boolean isExist(List lstCalMember, CalMember calMember) {
        for (int i = 0; i < lstCalMember.size(); ++i) {
            DimensionMember member = (DimensionMember)lstCalMember.get(i);
            String name = member.getDimension().getDimensionDef().getDimensionType().getName();
            if (!name.equals(calMember.getDimensionType().getName())) continue;
            return true;
        }
        return false;
    }

    private String getMdx() {
        StringBuffer sb = new StringBuffer();
        sb.append(" (Measures.[");
        sb.append(this.calMeasure + "])/(Measures.[" + this.calMeasure + "]," + this.getDenominatorMdx() + ")");
        return sb.toString();
    }

    private String getDenominatorMdx() {
        StringBuffer sb = new StringBuffer();
        if (this.calDenominator.equalsIgnoreCase("parent")) {
            sb.append("[" + this.calDim + "].CurrentMember.Parent");
        } else {
            sb.append("[" + this.calDim + "].[" + this.calDenominator + "]");
        }
        return sb.toString();
    }

    private void fromXML(String xml) throws IOException, JDOMException {
        if (StringUtil.isEmpty(xml)) {
            this.solveOrder = 1;
            return;
        }
        Element e = XmlUtil.toRootElement(xml);
        this.calMeasure = e.getAttributeValue("calMeasure");
        this.calDim = e.getAttributeValue("calDim");
        this.calDenominator = e.getAttributeValue("calDenominator");
        this.appModelType = e.getAttributeValue("appModelType");
        this.formatString = e.getAttributeValue("formatString");
        this.solveOrder = 1;
        try {
            this.solveOrder = Integer.parseInt(e.getAttributeValue("solveOrder"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        List eles = e.getChildren("measure");
        if (eles == null || eles.size() > 0) {
            // empty if block
        }
    }

    @Override
    public String getSchema() {
        StringBuffer sb = new StringBuffer();
        sb.append("");
        sb.append("");
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        sb.append("<ZRate");
        sb.append(" calMeasure=\"" + this.calMeasure + "\"");
        sb.append(" calDim=\"" + this.calDim + "\"");
        sb.append(" calDenominator=\"" + this.calDenominator + "\"");
        sb.append(" formatString=\"" + this.formatString + "\"");
        sb.append(" appModelType=\"" + this.appModelType + "\"");
        sb.append(" solveOrder=\"" + this.solveOrder + "\" >");
        sb.append("</ZRate>");
        return sb.toString();
    }

    public int getSolveOrder() {
        return this.solveOrder;
    }

    public int getCalMeasureIndex(ZRateDetailPanel zRateDetailPanel) {
        int i = zRateDetailPanel.calMeasure.getItemCount();
        for (int y = 0; y < i; ++y) {
            Member measure = (Member)zRateDetailPanel.calMeasure.getItemAt(y);
            String number = measure.getNumber();
            if (!number.equals(this.calMeasure)) continue;
            return y;
        }
        return 0;
    }

    public int getCalDimIndex(ZRateDetailPanel zRateDetailPanel) {
        int i = zRateDetailPanel.calDimension.getItemCount();
        for (int y = 0; y < i; ++y) {
            DimensionMeta dim = (DimensionMeta)zRateDetailPanel.calDimension.getItemAt(y);
            String number = dim.getDimensionType().getName();
            if (!number.equals(this.calDim)) continue;
            return y;
        }
        return 0;
    }

    public int getCalDenominatorIndex(ZRateDetailPanel zRateDetailPanel) {
        int i = zRateDetailPanel.cmbDenominator.getItemCount();
        for (int y = 0; y < i; ++y) {
            CalMember calMember;
            EnumObj provider;
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)zRateDetailPanel.cmbDenominator.getItemAt(y);
            if (!(node.getUserObject() instanceof CalSelProvider ? (provider = (EnumObj)node.getUserObject()).getName().equals(this.calDenominator) : (calMember = (CalMember)node.getUserObject()).getNumber().equals(this.calDenominator))) continue;
            return y;
        }
        return 0;
    }

    public int getFormatStringIndex(ZRateDetailPanel zRateDetailPanel) {
        int i = zRateDetailPanel.cmbFormatString.getItemCount();
        for (int y = 0; y < i; ++y) {
            FormatString format = (FormatString)zRateDetailPanel.cmbFormatString.getItemAt(y);
            if (!format.getName().equals(this.formatString)) continue;
            return y;
        }
        return 0;
    }

    @Override
    public String toMDX(Dimension dim, Context ctx) {
        return null;
    }
}

