/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.rt.dim;

import com.kingdee.bos.Context;
import com.kingdee.bos.bi.model.DB.DBUtil;
import com.kingdee.bos.bi.model.exception.BIModelException;
import com.kingdee.bos.bi.model.rt.appmodel.AppModel;
import com.kingdee.bos.bi.model.rt.dim.DimensionMeta;
import com.kingdee.bos.bi.model.rt.dim.DimensionView;
import com.kingdee.bos.bi.model.rt.dim.Property;
import com.kingdee.bos.bi.model.security.SecureUtil;
import com.kingdee.bos.bi.model.util.LRULinkedHashMap;
import com.kingdee.bos.ctrl.analysis.web.solution.BISystem;
import com.kingdee.bos.ctrl.bibench.platform.common.RDRowSet;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Dimension
implements Serializable {
    protected AppModel appmodel;
    protected DimensionMeta dm;
    private Map memberCache = new HashMap();
    private Map mapProperties = new LRULinkedHashMap(this.getMaxCacheSize());

    public Dimension(AppModel appmodel, DimensionMeta dm) {
        this.appmodel = appmodel;
        this.dm = dm;
    }

    public AppModel getAppModel() {
        return this.appmodel;
    }

    public DimensionMeta getDimensionDef() {
        return this.dm;
    }

    public String getViewId() {
        return this.getDimensionView().getId();
    }

    public DimensionView getDimensionView() {
        return this.appmodel.getAppModelView().getDimRef().getDimensionView(this.dm.getType());
    }

    public String getTablename() {
        return this.dm.getTablename(this.appmodel.getPubnumber());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getMembers(Connection cn, Context ctx, boolean bSecureFilter, boolean bTreeFilter) throws SQLException {
        ArrayList<String> lstRet = new ArrayList<String>();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            String sql = this.getAllMembersSql(ctx, bSecureFilter, bTreeFilter);
            stmt = cn.prepareStatement(sql);
            rs = stmt.executeQuery();
            while (rs.next()) {
                lstRet.add(rs.getObject(1).toString());
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, stmt);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        return lstRet;
    }

    public String getAllMembersSql(Context ctx, boolean bSecureFilter, boolean bTreeFilter) throws SQLException {
        String pubNumber = this.appmodel.getPubnumber();
        String tablename = this.dm.getTablename(pubNumber);
        String parentColumn = this.dm.getParentNumber();
        StringBuffer sbSql = new StringBuffer();
        sbSql.append("select * from " + tablename + " where FFlag is null or FFlag = 0");
        if (bSecureFilter) {
            String sqlTemp;
            String sqlPermission = SecureUtil.getRowSecureSQL(ctx, this);
            if (!StringUtils.isEmpty((String)sqlPermission)) {
                sqlTemp = sbSql.toString();
                sbSql = new StringBuffer();
                sbSql.append("select * from (");
                sbSql.append(sqlTemp);
                sbSql.append(") as sto_xxx where ");
                sbSql.append(sqlPermission);
            }
            if (bTreeFilter && parentColumn != null) {
                sqlTemp = sbSql.toString();
                sbSql = new StringBuffer();
                String sqlParent = "select " + parentColumn + " from (" + sqlTemp + ") as sto_mmm";
                sbSql.append("select * from (");
                sbSql.append(sqlTemp);
                sbSql.append(") as sto_yyy where sto_yyy.");
                sbSql.append(parentColumn);
                sbSql.append(" is null or sto_yyy.");
                sbSql.append(parentColumn);
                sbSql.append(" in (");
                sbSql.append(sqlParent);
                sbSql.append(")");
            }
        }
        if (this.dm.getSortFields().size() > 0) {
            Iterator it = this.dm.getSortFields().iterator();
            sbSql.append(" order by ");
            boolean isFirst = true;
            while (it.hasNext()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sbSql.append(",");
                }
                String field = (String)it.next();
                sbSql.append(field);
            }
            sbSql.append(" " + (this.dm.sortIsASC() ? "asc" : "desc"));
        }
        return sbSql.toString();
    }

    public String findInnerKey(String pubnumber, String bizKey, Connection cn) throws SQLException {
        if (!this.dm.hasCreateInnerID()) {
            return bizKey;
        }
        Object prop = this.findProperty(bizKey, "FID", cn);
        if (prop != null) {
            return prop.toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object findProperty(String bizKeyValue, String prop, Connection cn) throws SQLException {
        String pubnumber = this.appmodel.getPubnumber();
        Property p = this.dm.findProperty(prop);
        String propField = p != null ? p.getField() : prop;
        Object ret = null;
        String propKey = pubnumber + this.dm.getType() + bizKeyValue + prop;
        if (this.mapProperties.containsKey(propKey)) {
            return this.mapProperties.get(propKey);
        }
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String tablename = this.dm.getTablename(pubnumber);
        String key = this.dm.getBizKey();
        try {
            String sql = "select " + propField + " from " + tablename + " where " + key + "='" + bizKeyValue + "'";
            stmt = cn.prepareStatement(sql);
            rs = stmt.executeQuery();
            if (rs.next()) {
                ret = rs.getObject(1);
                this.mapProperties.put(propKey, ret);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, stmt);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RDRowSet getChildrenMembers(Context ctx, Object parentNum, boolean bSecureFilter) throws SQLException {
        String sqlPermission;
        String sql = "";
        String pubnumber = this.appmodel.getPubnumber();
        sql = "select * from " + this.dm.getTablename(pubnumber);
        String parentColumn = this.dm.getParentNumber();
        String number = this.dm.getBizKey();
        if (parentColumn == null) {
            return null;
        }
        Object[] param = null;
        if (parentNum == null || parentNum.toString().equals("")) {
            sql = sql + " where " + parentColumn + " is null or " + parentColumn + "=" + number;
        } else {
            sql = sql + " where " + parentColumn + "=?";
            param = new Object[]{parentNum};
        }
        if (bSecureFilter && !StringUtils.isEmpty((String)(sqlPermission = SecureUtil.getRowSecureSQL(ctx, this)))) {
            sql = "select * from (" + sql + ") as xxx where " + sqlPermission;
        }
        Connection cn = null;
        RDRowSet ret = null;
        try {
            cn = BISystem.getJdbcConnection((Context)ctx);
            ret = DBUtil.executeQuery(sql, param, cn);
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
        return ret;
    }

    public RDRowSet getMember(Connection cn, Context ctx, String func, Object[] params, boolean bSecureFilter, boolean bTreeFilter) throws BIModelException, SQLException {
        StringBuffer sb = new StringBuffer();
        String sql = this.getAllMembersSql(ctx, bSecureFilter, bTreeFilter);
        if ("max".equalsIgnoreCase(func)) {
            String column = this.dm.getBizKey();
            if (params != null && params.length >= 1) {
                column = params[0].toString();
            }
            sb.append("select top 1 * from (" + sql + ") as aaawhere " + column + "in(");
            sb.append("select max(" + column + ") from (" + sql + ") as bbb )");
        } else if ("min".equalsIgnoreCase(func)) {
            String column = this.dm.getBizKey();
            if (params != null && params.length >= 1) {
                column = params[0].toString();
            }
            sb.append("select top 1 * from (" + sql + ") as aaawhere " + column + "in(");
            sb.append("select min(" + column + ") from (" + sql + ") as bbb )");
        } else if ("root".equalsIgnoreCase(func)) {
            String orderColumn = this.dm.getBizKey();
            String orderBy = "asc";
            String bizKey = this.dm.getBizKey();
            String parentColumn = this.dm.getParentNumber();
            if (params != null) {
                if (params.length >= 1) {
                    orderColumn = params[0].toString();
                }
                if (!(params.length < 2 || (orderBy = params[1].toString()).equalsIgnoreCase("asc") && orderBy.equalsIgnoreCase("desc"))) {
                    throw new BIModelException("error parameter,except asc or desc!");
                }
            }
            sb.append("select top 1 * from (" + sql + ") as aaa");
            sb.append(" where " + bizKey + " is null ");
            sb.append(" or " + bizKey + "=" + parentColumn);
            sb.append(" order by " + orderColumn + " " + orderBy);
        } else if ("random".equalsIgnoreCase(func)) {
            sb.append("select top 1 * from (" + sql + ") as aaa");
        }
        return DBUtil.executeQuery(sb.toString(), cn);
    }

    public boolean verifyPermission(Connection cn, Context ctx, Object member, boolean bTreeFilter) throws SQLException {
        String sql = this.getAllMembersSql(ctx, true, bTreeFilter);
        String bizColumn = this.dm.getBizKey();
        sql = "select * from (" + sql + ") aaa where " + bizColumn + "=?";
        return DBUtil.executeQuery(sql, new Object[]{member}, cn).getRow() > 0;
    }

    protected int getMaxCacheSize() {
        return 0;
    }

    public List findFullPath(String name, Context ctx) throws SQLException {
        ArrayList<String> lstPath = new ArrayList<String>();
        lstPath.add(name);
        String fieldParent = this.getDimensionDef().getParentNumber();
        String fieldKey = this.getDimensionDef().getBizKey();
        if (StringUtil.isEmptyString((String)fieldParent)) {
            return lstPath;
        }
        Map map = this.getAllUserMembered(fieldParent, fieldKey, ctx);
        String child = name;
        String parent = null;
        while ((parent = (String)map.get(child)) != null && !StringUtil.equalsIgnoreCase((String)parent, (String)child)) {
            lstPath.add(parent);
            child = parent;
        }
        return lstPath;
    }

    private String findParent(String child, String fieldParent, String fieldKey, Context ctx) throws SQLException {
        String parent = null;
        StringBuffer sbSql = new StringBuffer();
        sbSql.append("select " + fieldParent);
        sbSql.append(" from " + this.getTablename());
        sbSql.append(" where " + fieldKey + "=?");
        Connection cn = BISystem.getJdbcConnection((Context)ctx);
        RDRowSet rs = DBUtil.executeQuery(sbSql.toString(), new Object[]{child}, cn);
        if (rs.next()) {
            Object obj = rs.getObject(0);
            String string = parent = obj == null ? null : obj.toString();
            if (child.equals(parent)) {
                return null;
            }
        }
        return parent;
    }

    private synchronized Map getAllUserMembered(String fieldParent, String fieldKey, Context ctx) throws SQLException {
        if (this.memberCache.isEmpty()) {
            StringBuffer sbSql = new StringBuffer();
            sbSql.append("select ").append(fieldKey).append(" , ").append(fieldParent).append(" ");
            sbSql.append("from ").append(this.getTablename()).append(" where  FFlag=0 ");
            RDRowSet rs = DBUtil.executeQuery(sbSql.toString(), BISystem.getJdbcConnection((Context)ctx));
            while (rs.next()) {
                this.memberCache.put(rs.getObject(fieldKey), rs.getObject(fieldParent));
            }
        }
        return this.memberCache;
    }
}

