/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.security;

import com.kingdee.bos.Context;
import com.kingdee.bos.bi.model.security.SecurityObject;
import com.kingdee.bos.bi.model.security.SecurityObjectType;
import com.kingdee.bos.bi.model.security.exception.BISecurityException;
import com.kingdee.bos.ctrl.analysis.web.solution.BISystem;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.db.SQLUtils;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SelSecurityObjects
implements Serializable {
    private static final long serialVersionUID = 8729547989107533030L;
    private SecurityObjectType type;
    private List lstSO;
    public static final String split_opr = " ";

    public SelSecurityObjects(SecurityObjectType type, List sos) {
        this.type = type;
        this.lstSO = sos;
    }

    public Object clone() {
        SecurityObjectType newType = (SecurityObjectType)this.type.clone();
        ArrayList<Object> newSos = null;
        if (this.lstSO != null) {
            newSos = new ArrayList<Object>();
            for (SecurityObject so : this.lstSO) {
                newSos.add(so.clone());
            }
        }
        return new SelSecurityObjects(newType, newSos);
    }

    public String[] getIds() {
        ArrayList<String> lstID = new ArrayList<String>();
        for (SecurityObject so : this.lstSO) {
            lstID.add(so.getId());
        }
        return lstID.toArray(new String[1]);
    }

    public SelSecurityObjects(String typename, List lstSO) {
        this(SecurityObjectType.getObj(typename), lstSO);
    }

    public SelSecurityObjects(SecurityObjectType type, String[] ids, Context ctx) throws BISecurityException {
        this.type = type;
        this.lstSO = this.getSecurityObjectList(ctx, ids, type);
    }

    public List getSecurityObjectList() {
        return this.lstSO;
    }

    public SelSecurityObjects(String typename, String[] ids, Context ctx) throws BISecurityException {
        this(SecurityObjectType.getObj(typename), ids, ctx);
    }

    public SecurityObjectType getType() {
        return this.type;
    }

    private List getSecurityObjectList(Context ctx, String[] ids, SecurityObjectType type) throws BISecurityException {
        StringBuffer sb = new StringBuffer();
        String tablename = "";
        if (SecurityObjectType.user.equals(type)) {
            tablename = "t_pm_user";
        } else if (SecurityObjectType.role.equals(type)) {
            tablename = "t_pm_role";
        } else if (SecurityObjectType.org.equals(type)) {
            tablename = "t_org_baseunit";
        }
        sb.append("select fid,fname_l2,fnumber from " + tablename + " where fid in(");
        for (int i = 0; i < ids.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append("'" + ids[i] + "'");
        }
        sb.append(")");
        ArrayList<SecurityObject> lstOS = new ArrayList<SecurityObject>();
        Connection cn = null;
        ResultSet rs = null;
        PreparedStatement stmt = null;
        try {
            cn = BISystem.getJdbcConnection((Context)ctx);
            stmt = cn.prepareStatement(sb.toString());
            rs = stmt.executeQuery();
            while (rs.next()) {
                SecurityObject so = new SecurityObject(rs.getString(1), rs.getString(2), rs.getString(3));
                lstOS.add(so);
            }
        }
        catch (SQLException e) {
            try {
                throw new BISecurityException("\u8bfb\u53d6\u6570\u636e\u5e93\u5931\u8d25\uff01", e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)cn);
        return lstOS;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Iterator it = this.lstSO.iterator();
        boolean isFirst = true;
        while (it.hasNext()) {
            SecurityObject so = (SecurityObject)it.next();
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(",");
            }
            sb.append(so.getName());
            sb.append("(");
            sb.append(so.getNumber());
            sb.append(")");
        }
        return sb.toString();
    }

    public boolean match(Context ctx) throws SQLException {
        block4: {
            String orgId;
            block3: {
                String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
                orgId = ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString();
                if (SecurityObjectType.role.equals(this.type)) {
                    return this.inRole(ctx, this.lstSO, userId, orgId);
                }
                if (!SecurityObjectType.user.equals(this.type)) break block3;
                for (SecurityObject so : this.lstSO) {
                    if (!so.getId().equals(userId)) continue;
                    return true;
                }
                break block4;
            }
            if (!SecurityObjectType.org.equals(this.type)) break block4;
            for (SecurityObject so : this.lstSO) {
                if (!so.getId().equals(orgId)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean inRole(Context ctx, List lstSO, String userId, String orgId) throws SQLException {
        PreparedStatement stmt;
        ResultSet rs;
        Connection cn;
        block5: {
            boolean bl;
            cn = null;
            rs = null;
            stmt = null;
            try {
                cn = BISystem.getJdbcConnection((Context)ctx);
                StringBuffer sb = new StringBuffer();
                sb.append("SELECT * FROM T_PM_USERROLEORG where FUserID='");
                sb.append(userId);
                sb.append("' and FOrgID='");
                sb.append(orgId);
                sb.append("' and FRoleID in(");
                Iterator it = lstSO.iterator();
                boolean isFirst = true;
                while (it.hasNext()) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        sb.append(",");
                    }
                    SecurityObject so = (SecurityObject)it.next();
                    sb.append("'");
                    sb.append(so.getId());
                    sb.append("'");
                }
                sb.append(")");
                stmt = cn.prepareStatement(sb.toString());
                rs = stmt.executeQuery();
                if (!rs.next()) break block5;
                bl = true;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)cn);
                throw throwable;
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)cn);
            return bl;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)cn);
        return false;
    }
}

