/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.ui.content;

import com.kingdee.bos.bi.model.common.dupont.DupontModel;
import com.kingdee.bos.bi.model.common.mm.measure.MeasureDimensionNode;
import com.kingdee.bos.bi.model.common.mm.metric.MetricDimensionNode;
import com.kingdee.bos.bi.model.common.mm.org.OrgDimensionNode;
import com.kingdee.bos.bi.model.common.mm.period.PeriodDimensionNode;
import com.kingdee.bos.bi.model.common.mm.year.YearDimensionNode;
import com.kingdee.bos.bi.model.service.IManagementFacade;
import com.kingdee.bos.bi.model.ui.content.AbstractContent;
import com.kingdee.bos.bi.model.ui.content.AbstractLeafViewUI;
import com.kingdee.bos.bi.model.ui.content.ContentTable;
import com.kingdee.bos.bi.model.ui.dialog.dupont.DupontModelDialog;
import com.kingdee.bos.bi.model.ui.dialog.dupont.SupplyAppModel;
import com.kingdee.bos.bi.model.ui.exception.BIModelRemoteException;
import com.kingdee.bos.ctrl.bibench.platform.common.RDRowSet;
import com.kingdee.bos.ctrl.bibench.platform.ui.etl.util.Util;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class DupontUI
extends AbstractLeafViewUI {
    public DupontUI(String captoin) {
        super(captoin);
    }

    @Override
    public String getViewType() {
        return "dupont";
    }

    @Override
    protected Map refreshImpl(IManagementFacade facade, Map sortParams) throws BIModelRemoteException {
        return facade.getViews(this.getViewType(), sortParams);
    }

    @Override
    protected void viewDetail(int rowIdx) {
        DupontModel model;
        String viewId = this.getRowID(rowIdx);
        String viewName = this.getRowName(rowIdx);
        try {
            if (!this.checkViewIdExist(viewId)) {
                WindowUtil.msgboxWarning((Object)(viewName + "\r\n\u8be5\u89c6\u56fe\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5c1d\u8bd5\u5237\u65b0\u540e\u518d\u64cd\u4f5c\u3002"), (String)this.createTitle("\u67e5\u770b", viewName), (Component)this.getRootCtrl());
                return;
            }
        }
        catch (BIModelRemoteException ex) {
            log.error((Object)"", (Throwable)((Object)ex));
            return;
        }
        try {
            model = DupontModel.load(this.getManFacade(), viewId);
        }
        catch (BIModelRemoteException ex) {
            log.error((Object)"", (Throwable)((Object)ex));
            WindowUtil.msgboxInfo((Object)("\u4e0d\u80fd\u6b63\u786e\u8bfb\u53d6\u5185\u5bb9\u3002" + ex.getMessage()), (String)this.createTitle("\u67e5\u770b", viewName), (Component)this.getRootCtrl());
            return;
        }
        this.innerEdit(viewId, viewName, "\u67e5\u770b", true, model);
    }

    @Override
    protected void doEdit(String viewId, String viewName) {
        DupontModel model;
        try {
            model = DupontModel.load(this.getManFacade(), viewId);
        }
        catch (BIModelRemoteException ex) {
            log.error((Object)"", (Throwable)((Object)ex));
            WindowUtil.msgboxInfo((Object)("\u4e0d\u80fd\u6b63\u786e\u8bfb\u53d6\u5185\u5bb9\u3002" + ex.getMessage()), (String)this.createTitle("\u7f16\u8f91", viewName), (Component)this.getRootCtrl());
            return;
        }
        this.innerEdit(viewId, viewName, "\u7f16\u8f91", false, model);
    }

    @Override
    protected boolean innerEdit(String viewId, String viewName, String operate, boolean isReadOnly, Object param) {
        DupontModel model = (DupontModel)param;
        DupontModelDialog dlg = (DupontModelDialog)((Object)WindowUtil.createWindow(DupontModelDialog.class, (Component)((Object)this.getTable())));
        dlg.setTitle(this.createTitle(operate, viewName));
        dlg.setSize(800, 600);
        dlg.setSupplyer(new Supplyer());
        dlg.setModel(model);
        dlg.setReadOnly(isReadOnly);
        try {
            dlg.setDiscriptionTxt(this.getManFacade().loadViewDiscription(this.getViewType(), viewId));
        }
        catch (BIModelRemoteException bIModelRemoteException) {
            // empty catch block
        }
        if (dlg.showDialog()) {
            try {
                DupontModel.save(this.getManFacade(), viewId, dlg.getModel());
                this.getManFacade().updateViewDiscription(this.getViewType(), viewId, dlg.getDiscriptionTxt());
            }
            catch (BIModelRemoteException ex) {
                log.error((Object)"", (Throwable)((Object)ex));
                WindowUtil.msgboxInfo((Object)("\u4e0d\u80fd\u6b63\u786e\u4fdd\u5b58\u5185\u5bb9\u3002" + ex.getMessage()), (String)dlg.getTitle(), (Component)this.getRootCtrl());
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public String getDimensionType() {
        return null;
    }

    @Override
    protected ContentTable getTable() {
        ContentTable table = super.getTable();
        if (table.getColumn("PUBLISHPATH") == null) {
            IColumn col = table.addColumn(5);
            col.setKey("PUBLISHPATH");
            table.setHeadText("PUBLISHPATH", "\u53d1\u5e03\u8def\u5f84");
            table.setColumnWidth("PUBLISHPATH", 200);
        }
        return table;
    }

    @Override
    protected void updateTable(Map allAttrs) {
        super.updateTable(allAttrs);
        ContentTable t = this.getTable();
        String[] ids = (String[])allAttrs.get("ID");
        int r = 0;
        for (int i = 0; i < ids.length; ++i) {
            HashMap attrs = Util.makeRowAtts((int)i, (HashMap)((HashMap)allAttrs));
            String reportPathCaption = "";
            String dupontReportPathName = (String)attrs.get("PUBLISHPATH");
            if (!StringUtils.isEmpty((String)dupontReportPathName) && "1".equalsIgnoreCase((String)attrs.get("USEFLAG"))) {
                try {
                    reportPathCaption = this.getManFacade().getThemeReportPathCaption(dupontReportPathName);
                }
                catch (BIModelRemoteException bIModelRemoteException) {
                    // empty catch block
                }
            }
            t.setCellValue(r, "PUBLISHPATH", reportPathCaption);
            ++r;
        }
    }

    private class Supplyer
    implements DupontModelDialog.ISupplyer {
        private Supplyer() {
        }

        @Override
        public SupplyAppModel[] getSourceAppModels() {
            RDRowSet rowset;
            StringBuffer sb = new StringBuffer();
            sb.append("select FID,FName from T_BI_AppModel ");
            sb.append("where FPublishFlag=1 and (FType='finance' or Ftype is null or FType='') ");
            try {
                rowset = DupontUI.this.getManFacade().executeQuery(sb.toString());
            }
            catch (SQLException e) {
                AbstractContent.log.error((Object)"\u675c\u90a6\u6a21\u578b\u8bbe\u8ba1-\u83b7\u53d6\u5907\u9009\u5e94\u7528\u6a21\u578b\u51fa\u9519\u3002", (Throwable)e);
                return null;
            }
            catch (BIModelRemoteException e) {
                AbstractContent.log.error((Object)"\u675c\u90a6\u6a21\u578b\u8bbe\u8ba1-\u83b7\u53d6\u5907\u9009\u5e94\u7528\u6a21\u578b\u51fa\u9519\u3002", (Throwable)((Object)e));
                return null;
            }
            ArrayList<SupplyAppModel> result = new ArrayList<SupplyAppModel>();
            while (rowset.next()) {
                String id = rowset.getString("FID");
                String name = rowset.getString("FName");
                result.add(new SupplyAppModel(id, name));
            }
            return result.toArray(new SupplyAppModel[0]);
        }

        @Override
        public MetricDimensionNode getMetricTree(String appModelId) {
            try {
                return DupontUI.this.getManFacade().getPublishedMetricTree(appModelId);
            }
            catch (BIModelRemoteException e) {
                AbstractContent.log.error((Object)("\u675c\u90a6\u6a21\u578b\u8bbe\u8ba1-\u83b7\u53d6\u6307\u6807\u7ef4\u5ea6\u51fa\u9519\u3002AppModelId: " + appModelId), (Throwable)((Object)e));
                return null;
            }
        }

        @Override
        public OrgDimensionNode getOrgTree(String appModelId) {
            try {
                return DupontUI.this.getManFacade().getPublishedOrgTree(appModelId);
            }
            catch (BIModelRemoteException e) {
                AbstractContent.log.error((Object)("\u675c\u90a6\u6a21\u578b\u8bbe\u8ba1-\u83b7\u53d6\u7ec4\u7ec7\u7ef4\u5ea6\u51fa\u9519\u3002AppModelId: " + appModelId), (Throwable)((Object)e));
                return null;
            }
        }

        @Override
        public YearDimensionNode getYearModel(String appModelId) {
            try {
                return DupontUI.this.getManFacade().getPublishedYearTree(appModelId);
            }
            catch (BIModelRemoteException e) {
                AbstractContent.log.error((Object)("\u675c\u90a6\u6a21\u578b\u8bbe\u8ba1-\u83b7\u53d6\u5e74\u7ef4\u5ea6\u51fa\u9519\u3002AppModelId: " + appModelId), (Throwable)((Object)e));
                return null;
            }
        }

        @Override
        public PeriodDimensionNode getPeriodModel(String appModelId) {
            try {
                return DupontUI.this.getManFacade().getPublishedPeriodTree(appModelId);
            }
            catch (BIModelRemoteException e) {
                AbstractContent.log.error((Object)("\u675c\u90a6\u6a21\u578b\u8bbe\u8ba1-\u83b7\u53d6\u8d22\u52a1\u671f\u95f4\u51fa\u9519\u3002AppModelId: " + appModelId), (Throwable)((Object)e));
                return null;
            }
        }

        @Override
        public MeasureDimensionNode getMeasureModel(String appModelId) {
            try {
                return DupontUI.this.getManFacade().getPublishedMeasureTree(appModelId);
            }
            catch (BIModelRemoteException e) {
                AbstractContent.log.error((Object)("\u675c\u90a6\u6a21\u578b\u8bbe\u8ba1-\u83b7\u53d6\u5ea6\u91cf\u7ef4\u5ea6\u51fa\u9519\u3002AppModelId: " + appModelId), (Throwable)((Object)e));
                return null;
            }
        }
    }
}

